/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.security.jaas;

import java.util.HashMap;
import java.util.Map;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import org.nuiton.topia.security.TopiaSecurityService;
import org.nuiton.topia.security.util.TopiaSecurityUtil;

public class TopiaConfiguration
extends Configuration {
    private Map<String, AppConfigurationEntry[]> appConfEntries = new HashMap<String, AppConfigurationEntry[]>();

    public TopiaConfiguration(String name, TopiaSecurityService securityManager) {
        this.addEntry(name, securityManager);
    }

    private void addEntry(String name, TopiaSecurityService securityManager) {
        AppConfigurationEntry[] confEntries = this.getAppConfigurationEntry(name);
        if (confEntries != null) {
            int i;
            for (i = 0; i < confEntries.length && !TopiaSecurityUtil.TOPIA_LOGIN_MODULE.equals(confEntries[i].getLoginModuleName()); ++i) {
            }
            if (i == confEntries.length) {
                AppConfigurationEntry[] tmpConfEntries = confEntries;
                confEntries = new AppConfigurationEntry[confEntries.length + 1];
                for (int j = 0; j < confEntries.length; ++j) {
                    confEntries[j] = tmpConfEntries[j];
                }
                confEntries[confEntries.length - 1] = this.createEntry(securityManager);
            } else if (!(AppConfigurationEntry.LoginModuleControlFlag.REQUIRED.equals(confEntries[i].getControlFlag()) && confEntries[i].getOptions().containsKey("topia.app.security.manager") && confEntries[i].getOptions().get("topia.app.security.manager").equals(securityManager))) {
                confEntries[i] = this.createEntry(securityManager, confEntries[i].getOptions());
            }
        } else {
            confEntries = new AppConfigurationEntry[]{this.createEntry(securityManager)};
        }
        this.appConfEntries.put(name, confEntries);
    }

    private AppConfigurationEntry createEntry(TopiaSecurityService securityManager) {
        return this.createEntry(securityManager, null);
    }

    private AppConfigurationEntry createEntry(TopiaSecurityService securityManager, Map options) {
        if (options == null) {
            options = new HashMap<String, TopiaSecurityService>();
        }
        options.put("topia.app.security.manager", securityManager);
        return new AppConfigurationEntry(TopiaSecurityUtil.TOPIA_LOGIN_MODULE, AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, options);
    }

    @Override
    public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
        return this.appConfEntries.get(name);
    }

    @Override
    public void refresh() {
    }
}

