package org.nuiton.topia;

import java.lang.reflect.Array;
import java.util.Arrays;
import javax.annotation.Generated;
import org.apache.commons.lang3.ArrayUtils;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.TopiaDAO;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityEnum;
import org.nuiton.topia.persistence.util.EntityOperatorStore;
import org.nuiton.topia.persistence.util.TopiaEntityHelper;
import org.nuiton.topia.security.entities.authorization.TopiaAssociationAuthorization;
import org.nuiton.topia.security.entities.authorization.TopiaAssociationAuthorizationDAO;
import org.nuiton.topia.security.entities.authorization.TopiaAuthorization;
import org.nuiton.topia.security.entities.authorization.TopiaAuthorizationDAO;
import org.nuiton.topia.security.entities.authorization.TopiaEntityAuthorization;
import org.nuiton.topia.security.entities.authorization.TopiaEntityAuthorizationDAO;
import org.nuiton.topia.security.entities.authorization.TopiaExpressionLink;
import org.nuiton.topia.security.entities.authorization.TopiaExpressionLinkDAO;
import org.nuiton.topia.security.entities.user.TopiaGroup;
import org.nuiton.topia.security.entities.user.TopiaGroupDAO;
import org.nuiton.topia.security.entities.user.TopiaUser;
import org.nuiton.topia.security.entities.user.TopiaUserDAO;
import org.nuiton.topia.taas.entities.TaasAuthorization;
import org.nuiton.topia.taas.entities.TaasAuthorizationDAO;
import org.nuiton.topia.taas.entities.TaasPrincipal;
import org.nuiton.topia.taas.entities.TaasPrincipalDAO;
import org.nuiton.topia.taas.entities.TaasUser;
import org.nuiton.topia.taas.entities.TaasUserDAO;

@Generated(value = "org.nuiton.topia.generator.DAOHelperTransformer", date = "Thu Aug 13 08:26:44 CEST 2015")
public class TopiaSecurityDAOHelper {

    public enum TopiaSecurityEntityEnum implements TopiaEntityEnum {
        TopiaAssociationAuthorization(TopiaAssociationAuthorization.class, null, "topiaassociationauthorization", ArrayUtils.EMPTY_STRING_ARRAY),
        TopiaAuthorization(TopiaAuthorization.class, null, "topiaauthorization", ArrayUtils.EMPTY_STRING_ARRAY),
        TopiaEntityAuthorization(TopiaEntityAuthorization.class, null, "topiaentityauthorization", ArrayUtils.EMPTY_STRING_ARRAY),
        TopiaExpressionLink(TopiaExpressionLink.class, null, "topiaexpressionlink", ArrayUtils.EMPTY_STRING_ARRAY),
        TopiaGroup(TopiaGroup.class, null, "topiagroup", ArrayUtils.EMPTY_STRING_ARRAY),
        TopiaUser(TopiaUser.class, null, "topiauser", ArrayUtils.EMPTY_STRING_ARRAY),
        TaasAuthorization(TaasAuthorization.class, null, "taasauthorization", ArrayUtils.EMPTY_STRING_ARRAY),
        TaasPrincipal(TaasPrincipal.class, null, "taasprincipal", ArrayUtils.EMPTY_STRING_ARRAY),
        TaasUser(TaasUser.class, null, "taasuser", ArrayUtils.EMPTY_STRING_ARRAY);

        /**
         * The contract of the entity.
         */
        protected Class<? extends TopiaEntity> contract;

        /**
         * The optional name of database schema of the entity (if none was filled, will be {@code null}).
         */
        protected String dbSchemaName;

        /**
         * The name of the database table for the entity.
         */
        protected String dbTableName;

        /**
         * The fully qualified name of the implementation of the entity.
         */
        protected String implementationFQN;

        /**
         * The implementation class of the entity (will be lazy computed at runtime).
         */
        protected Class<? extends TopiaEntity> implementation;

        /**
         * The array of property involved in the natural key of the entity.
         */
        protected String[] naturalIds;

        /**
         * The array of not null properties of the entity.
         */
        protected String[] notNulls;

        TopiaSecurityEntityEnum(Class<? extends TopiaEntity > contract, String dbSchemaName, String dbTableName, String[] notNulls, String... naturalIds)     {
        this.contract = contract;
        this.dbSchemaName = dbSchemaName;
        this.dbTableName = dbTableName;
        this.notNulls = notNulls;
        this.naturalIds = naturalIds;
        implementationFQN = contract.getName() + "Impl";
        }

        @Override
        public Class<? extends TopiaEntity> getContract()     {
        return contract;
        }

        @Override
        public String dbSchemaName()     {
        return dbSchemaName;
        }

        @Override
        public String dbTableName()     {
        return dbTableName;
        }

        @Override
        public String[] getNaturalIds()     {
        return naturalIds;
        }

        @Override
        public boolean isUseNaturalIds()     {
        return naturalIds.length > 0;
        }

        @Override
        public String[] getNotNulls()     {
        return notNulls;
        }

        @Override
        public boolean isUseNotNulls()     {
        return notNulls.length > 0;
        }

        @Override
        public String getImplementationFQN()     {
        return implementationFQN;
        }

        @Override
        public void setImplementationFQN(String implementationFQN)     {
        this.implementationFQN = implementationFQN;
        this.implementation = null;
        }

        @Override
        public boolean accept(Class<? extends TopiaEntity> klass)     {
        return TopiaSecurityDAOHelper.getContractClass(klass) == contract;
        }

        @Override
        public Class<? extends TopiaEntity> getImplementation()     {
        if (implementation == null) {
        try {
                implementation = (Class<? extends TopiaEntity>) Class.forName(implementationFQN);
            } catch (ClassNotFoundException e) {
                throw new TopiaRuntimeException("could not find class " + implementationFQN, e);
            }
        }
        return implementation;
        }

        public static TopiaSecurityEntityEnum valueOf(TopiaEntity entity)     {
        return valueOf(entity.getClass());
        }

        public static TopiaSecurityEntityEnum valueOf(Class<?> klass)     {
        if (klass.isInterface()) {
           return valueOf(klass.getSimpleName());
        }

        Class<?> contractClass = TopiaEntityHelper.getContractClass(TopiaSecurityEntityEnum.values(), (Class) klass);

        if (contractClass != null) {

            return valueOf(contractClass.getSimpleName());
        }

        throw new IllegalArgumentException("no entity defined for the class " + klass + " in : " + Arrays.toString(TopiaSecurityEntityEnum.values()));
        }

    } //TopiaSecurityEntityEnum

    protected TopiaSecurityDAOHelper() { }

    public static String getModelVersion() {
        return "1.1";
    }

    public static String getModelName() {
        return "TopiaSecurity";
    }

    public static TopiaAssociationAuthorizationDAO getTopiaAssociationAuthorizationDAO(TopiaContext context) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        TopiaAssociationAuthorizationDAO result = ci.getDAO(TopiaAssociationAuthorization.class, TopiaAssociationAuthorizationDAO.class);
        return result;
    }

    public static TopiaAuthorizationDAO getTopiaAuthorizationDAO(TopiaContext context) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        TopiaAuthorizationDAO result = ci.getDAO(TopiaAuthorization.class, TopiaAuthorizationDAO.class);
        return result;
    }

    public static TopiaEntityAuthorizationDAO getTopiaEntityAuthorizationDAO(TopiaContext context) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        TopiaEntityAuthorizationDAO result = ci.getDAO(TopiaEntityAuthorization.class, TopiaEntityAuthorizationDAO.class);
        return result;
    }

    public static TopiaExpressionLinkDAO getTopiaExpressionLinkDAO(TopiaContext context) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        TopiaExpressionLinkDAO result = ci.getDAO(TopiaExpressionLink.class, TopiaExpressionLinkDAO.class);
        return result;
    }

    public static TopiaGroupDAO getTopiaGroupDAO(TopiaContext context) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        TopiaGroupDAO result = ci.getDAO(TopiaGroup.class, TopiaGroupDAO.class);
        return result;
    }

    public static TopiaUserDAO getTopiaUserDAO(TopiaContext context) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        TopiaUserDAO result = ci.getDAO(TopiaUser.class, TopiaUserDAO.class);
        return result;
    }

    public static TaasAuthorizationDAO getTaasAuthorizationDAO(TopiaContext context) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        TaasAuthorizationDAO result = ci.getDAO(TaasAuthorization.class, TaasAuthorizationDAO.class);
        return result;
    }

    public static TaasPrincipalDAO getTaasPrincipalDAO(TopiaContext context) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        TaasPrincipalDAO result = ci.getDAO(TaasPrincipal.class, TaasPrincipalDAO.class);
        return result;
    }

    public static TaasUserDAO getTaasUserDAO(TopiaContext context) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        TaasUserDAO result = ci.getDAO(TaasUser.class, TaasUserDAO.class);
        return result;
    }

    public static <T extends TopiaEntity, D extends TopiaDAO<? super T>> D getDAO(TopiaContext context, Class<T> klass) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        TopiaSecurityEntityEnum constant = TopiaSecurityEntityEnum.valueOf(klass);
        D dao = (D) ci.getDAO(constant.getContract());
        return dao;
    }

    public static <T extends TopiaEntity, D extends TopiaDAO<? super T>> D getDAO(TopiaContext context, T entity) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        TopiaSecurityEntityEnum constant = TopiaSecurityEntityEnum.valueOf(entity);
        D dao = (D) ci.getDAO(constant.getContract());
        return dao;
    }

    public static <T extends TopiaEntity> Class<T> getContractClass(Class<T> klass) {
        TopiaSecurityEntityEnum constant = TopiaSecurityEntityEnum.valueOf(klass);
        return (Class<T>) constant.getContract();
    }

    public static <T extends TopiaEntity> Class<T> getImplementationClass(Class<T> klass) {
        TopiaSecurityEntityEnum constant = TopiaSecurityEntityEnum.valueOf(klass);
        return (Class<T>) constant.getImplementation();
    }

    public static Class<? extends TopiaEntity>[] getContractClasses() {
        TopiaSecurityEntityEnum[] values = TopiaSecurityEntityEnum.values();
        Class<? extends TopiaEntity>[] result = (Class<? extends TopiaEntity>[]) Array.newInstance(Class.class, values.length);
        for (int i = 0; i < values.length; i++) {
            result[i] = values[i].getContract();
        }
        return result;
    }

    public static Class<? extends TopiaEntity>[] getImplementationClasses() {
        TopiaSecurityEntityEnum[] values = TopiaSecurityEntityEnum.values();
        Class<? extends TopiaEntity>[] result = (Class<? extends TopiaEntity>[]) Array.newInstance(Class.class, values.length);
        for (int i = 0; i < values.length; i++) {
            result[i] = values[i].getImplementation();
        }
        return result;
    }

    public static String getImplementationClassesAsString() {
        StringBuilder buffer = new StringBuilder();
        for (Class<? extends TopiaEntity> aClass : getImplementationClasses()) {
            buffer.append(',').append(aClass.getName());
        }
        return buffer.substring(1);
    }

    public static TopiaSecurityEntityEnum[] getContracts() {
        return TopiaSecurityEntityEnum.values();
    }

} //TopiaSecurityDAOHelper
