/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.replication;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityEnum;
import org.nuiton.topia.persistence.util.TopiaEntityHelper;
import org.nuiton.topia.replication.TopiaReplicationImplementor;
import org.nuiton.topia.replication.TopiaReplicationOperation;
import org.nuiton.topia.replication.model.ReplicationModel;
import org.nuiton.topia.replication.model.ReplicationNode;
import org.nuiton.topia.replication.model.ReplicationOperationDef;
import org.nuiton.topia.replication.model.ReplicationOperationPhase;

public class ReplicationEngine
implements TopiaReplicationImplementor {
    private static final Log log = LogFactory.getLog(ReplicationEngine.class);
    protected TopiaContextImplementor context;
    protected static TopiaReplicationOperation[] operations;

    public String getServiceName() {
        return "replication";
    }

    public Class<?>[] getPersistenceClasses() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean preInit(TopiaContextImplementor context) {
        if (operations == null) {
            ReplicationEngine replicationEngine = this;
            synchronized (replicationEngine) {
                ServiceLoader<TopiaReplicationOperation> loader = ServiceLoader.load(TopiaReplicationOperation.class);
                ArrayList<TopiaReplicationOperation> discoveredOperations = new ArrayList<TopiaReplicationOperation>();
                for (TopiaReplicationOperation op : loader) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("detected operation " + op));
                    }
                    discoveredOperations.add(op);
                }
                operations = discoveredOperations.toArray(new TopiaReplicationOperation[discoveredOperations.size()]);
            }
        }
        return true;
    }

    public boolean postInit(TopiaContextImplementor context) {
        this.context = context;
        return true;
    }

    @Override
    public ReplicationModel prepare(TopiaEntityEnum[] contracts, String ... entities) throws TopiaException {
        ReplicationModel model = this.createModel(contracts, entities);
        this.initModel(model, true);
        return model;
    }

    @Override
    public ReplicationModel prepareForAll(TopiaEntityEnum[] contracts) throws TopiaException {
        ReplicationModel model = this.createModelForAll(contracts);
        this.initModel(model, true);
        return model;
    }

    @Override
    public ReplicationModel prepareWithComputedOrder(TopiaEntityEnum[] contracts, String ... topiaIds) throws TopiaException {
        ReplicationModel model = this.createModelWithComputedOrder(contracts, topiaIds);
        this.initModel(model, false);
        return model;
    }

    @Override
    public void addBeforeOperation(ReplicationModel model, TopiaEntityEnum type, Class<? extends TopiaReplicationOperation> operationClass, Object ... parameters) {
        this.createOperation(model, type, ReplicationOperationPhase.before, operationClass, parameters);
    }

    @Override
    public void addAfterOperation(ReplicationModel model, TopiaEntityEnum type, Class<? extends TopiaReplicationOperation> operationClass, Object ... parameters) {
        this.createOperation(model, type, ReplicationOperationPhase.after, operationClass, parameters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doReplicate(ReplicationModel model, TopiaContext dstCtxt) throws Exception {
        ReplicationEngine.checkNotNull("doReplicate", "model", model);
        ReplicationEngine.checkNotNull("doReplicate", "dstCtxt", dstCtxt);
        TopiaContextImplementor srcCtxt = null;
        Map<Class<? extends TopiaEntity>, List<String>> data = null;
        ArrayList<ReplicationNode> treated = new ArrayList<ReplicationNode>();
        try {
            srcCtxt = (TopiaContextImplementor)this.context.beginTransaction();
            data = this.getIds(model, srcCtxt);
            srcCtxt.closeContext();
            model.adjustOperations(data);
            boolean needTransaction = true;
            for (ReplicationNode node : model.getOrder()) {
                srcCtxt = (TopiaContextImplementor)this.context.beginTransaction();
                TopiaContext tx = needTransaction ? dstCtxt.beginTransaction() : dstCtxt;
                try {
                    this.doReplicateNode(node, (TopiaContext)srcCtxt, tx, data, treated);
                }
                catch (Exception e) {
                    tx.rollbackTransaction();
                    throw e;
                }
                finally {
                    srcCtxt.closeContext();
                    if (!needTransaction) continue;
                    tx.closeContext();
                }
            }
        }
        finally {
            if (data != null) {
                data.clear();
            }
            if (treated != null) {
                treated.clear();
            }
            if (srcCtxt != null && !srcCtxt.isClosed()) {
                srcCtxt.rollbackTransaction();
                srcCtxt.closeContext();
            }
        }
    }

    @Override
    public ReplicationModel createModel(TopiaEntityEnum[] contracts, String ... topiaIds) throws TopiaException {
        Set<Class<? extends TopiaEntity>> detectTypes = this.detectTypes(contracts, topiaIds);
        ReplicationModel model = new ReplicationModel(contracts, detectTypes, topiaIds);
        return model;
    }

    @Override
    public ReplicationModel createModelWithComputedOrder(TopiaEntityEnum[] contracts, String ... topiaIds) throws TopiaException {
        ReplicationModel model = new ReplicationModel(contracts, false, topiaIds);
        return model;
    }

    @Override
    public ReplicationModel createModelForAll(TopiaEntityEnum[] contracts) throws TopiaException {
        ReplicationModel model = new ReplicationModel(contracts, true, new String[0]);
        return model;
    }

    @Override
    public ReplicationModel initModel(ReplicationModel model, boolean computeOrder) throws TopiaException {
        ReplicationEngine.checkNotNull("initModel", "model", model);
        model.detectAssociations(new TopiaEntityEnum[0]);
        model.detectDirectDependencies();
        if (computeOrder) {
            model.detectShell();
            model.detectDependencies();
        }
        model.detectObjectsToDettach();
        model.detectOperations();
        return model;
    }

    @Override
    public TopiaReplicationOperation getOperation(Class<? extends TopiaReplicationOperation> operationClass) {
        ReplicationEngine.checkNotNull("getOperation", "operationClass", operationClass);
        if (operations == null) {
            throw new IllegalStateException("service was not init!");
        }
        TopiaReplicationOperation result = null;
        for (TopiaReplicationOperation op : operations) {
            if (!operationClass.isAssignableFrom(op.getClass())) continue;
            result = op;
            break;
        }
        return result;
    }

    @Override
    public void createOperation(ReplicationModel model, TopiaEntityEnum type, ReplicationOperationPhase phase, Class<? extends TopiaReplicationOperation> operationClass, Object ... parameters) {
        ReplicationEngine.checkNotNull("createOperation", "model", model);
        ReplicationEngine.checkNotNull("createOperation", "type", type);
        ReplicationEngine.checkNotNull("createOperation", "phase", (Object)phase);
        ReplicationEngine.checkNotNull("createOperation", "operationClass", operationClass);
        TopiaReplicationOperation operation = this.getOperation(operationClass);
        if (operation == null) {
            throw new IllegalArgumentException(I18n._((String)"topia.replication.engine.error.unkown.operation", (Object[])new Object[]{operationClass.getSimpleName(), Arrays.toString(operations)}));
        }
        ReplicationNode node = model.getNode(type);
        if (node == null) {
            throw new IllegalArgumentException(I18n._((String)"topia.replication.engine.error.unkown.owner.node", (Object[])new Object[]{type, operationClass.getSimpleName(), model.getNodes()}));
        }
        operation.register(model, node, phase, parameters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Class<? extends TopiaEntity>> detectTypes(TopiaEntityEnum[] contracts, String ... ids) throws TopiaException {
        TopiaContext ctxt = this.context.beginTransaction();
        try {
            TopiaEntity[] entities = ReplicationEngine.getEntities(ctxt, ids);
            Set types = TopiaEntityHelper.detectTypes((TopiaEntityEnum[])contracts, (TopiaEntity[])entities);
            if (log.isDebugEnabled()) {
                log.debug((Object)("for type : " + entities.getClass()));
                for (Class k : types) {
                    log.debug((Object)k);
                }
            }
            Set set = types;
            return set;
        }
        finally {
            ctxt.closeContext();
        }
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<String>> getIds(ReplicationModel model, TopiaContextImplementor srcCtxt) throws TopiaException {
        HashMap<Class<? extends TopiaEntity>, List<String>> data;
        if (model.isReplicateAll()) {
            data = new HashMap();
            for (TopiaEntityEnum e : model.getContracts()) {
                List ids = srcCtxt.getDAO(e.getContract()).findAllIds();
                data.put(e.getContract(), ids);
            }
        } else {
            TopiaEntity[] entities = ReplicationEngine.getEntities((TopiaContext)srcCtxt, model.getTopiaIds());
            data = TopiaEntityHelper.detectEntityIds((TopiaEntityEnum[])model.getContracts(), model.getTypes(), (TopiaEntity[])entities);
        }
        return data;
    }

    @Override
    public void doReplicateNode(ReplicationNode node, TopiaContext srcCtxt, TopiaContext dstCtxt, Map<Class<? extends TopiaEntity>, List<String>> data, List<ReplicationNode> treated) throws Exception {
        node.sortOperations();
        List<ReplicationOperationDef> operationDefs = node.getOperations();
        if (operationDefs.isEmpty()) {
            log.info((Object)("skip node " + node + " - no operation detected."));
        } else {
            log.info((Object)("start for " + node + " : " + operationDefs.size() + " operation(s)"));
            List<String> nodeEntityIds = data.get(node.getContract().getContract());
            if (log.isInfoEnabled()) {
                log.info((Object)("will replicate on " + nodeEntityIds.size() + " entity(ies)"));
            }
            if (log.isDebugEnabled()) {
                for (String id : nodeEntityIds) {
                    log.debug((Object)id);
                }
            }
            List<? extends TopiaEntity> nodeEntities = ReplicationEngine.getEntitiesList(srcCtxt, nodeEntityIds.toArray(new String[nodeEntityIds.size()]));
            for (ReplicationOperationDef operationDef : operationDefs) {
                log.info((Object)("start " + operationDef));
                TopiaReplicationOperation operation = this.getOperation(operationDef.getOperationClass());
                operation.run(operationDef, (TopiaContextImplementor)srcCtxt, (TopiaContextImplementor)dstCtxt, nodeEntities, data);
            }
            srcCtxt.rollbackTransaction();
        }
        treated.add(node);
    }

    public static <E extends TopiaEntity> List<E> getEntities(TopiaContextImplementor srcCtxt, List<E> entityList, boolean canBeNull) throws TopiaException {
        ArrayList<TopiaEntity> srcList = new ArrayList<TopiaEntity>(entityList.size());
        for (TopiaEntity e : entityList) {
            TopiaEntity e2 = srcCtxt.findByTopiaId(e.getTopiaId());
            if (e2 == null && !canBeNull) {
                if (canBeNull) continue;
                throw new IllegalStateException("topia.replication.engine.error.entity.must.exists");
            }
            srcList.add(e2);
        }
        return srcList;
    }

    public static TopiaEntity[] getEntities(TopiaContext srcCtxt, String ... entityList) throws TopiaException {
        TopiaEntity[] srcList = new TopiaEntity[entityList.length];
        int index = 0;
        for (String id : entityList) {
            TopiaEntity e2 = srcCtxt.findByTopiaId(id);
            srcList[index++] = e2;
        }
        return srcList;
    }

    public static List<? extends TopiaEntity> getEntitiesList(TopiaContext srcCtxt, String ... entityList) throws TopiaException {
        ArrayList<TopiaEntity> srcList = new ArrayList<TopiaEntity>(entityList.length);
        for (String id : entityList) {
            TopiaEntity e2 = srcCtxt.findByTopiaId(id);
            srcList.add(e2);
        }
        return srcList;
    }

    public static void checkNotNull(String methodName, String parameterName, Object value) {
        if (value == null) {
            throw new NullPointerException(I18n._((String)"topia.replication.engine.error.null.param", (Object[])new Object[]{parameterName, methodName}));
        }
    }

    public static void checkParameters(Class<?>[] paramsType, Object ... params) {
        ReplicationEngine.checkSize(paramsType.length, params);
        int j = paramsType.length;
        for (int i = 0; i < j; ++i) {
            ReplicationEngine.checkType(paramsType, i, params);
        }
    }

    public static void checkSize(int size, Object[] params) {
        if (params.length != size) {
            throw new IllegalArgumentException("l'operation requiere " + size + " parametres mais en a " + params.length);
        }
    }

    public static void checkType(Class<?>[] paramsType, int index, Object[] params) {
        Class<?> requiredType = paramsType[index];
        Object value = params[index];
        if (value == null) {
            throw new IllegalArgumentException("le parametre de positiion" + index + " est null!");
        }
        Class<?> foundType = value.getClass();
        if (!requiredType.isAssignableFrom(foundType)) {
            throw new IllegalArgumentException("le paremetre de position " + index + "  requiere un parametre de type " + requiredType + " mais est de type " + foundType);
        }
    }
}

