package org.nuiton.topia.migration;

import java.util.Arrays;
import java.util.List;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.TopiaDAO;
import org.nuiton.topia.persistence.TopiaDAOImpl;


public abstract class TMSVersionDAOAbstract<E extends TMSVersion> extends TopiaDAOImpl<E> implements TopiaDAO<E> {

    /**
     * getEntityClass :
     * @return Class<E> 
     */

    public Class<E> getEntityClass() {
        return (Class<E>)TMSVersion.class;
    }

    /**
     * delete :
     * @param entity 
     * @throws TopiaException
     */

    public void delete(E entity) throws TopiaException {
        super.delete(entity);
    }

    /**
     * findByVersion :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut version le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByVersion(String v) throws TopiaException {
        E result = findByProperty("version", v);
        return result;
    }

    /**
     * findAllByVersion :
     * Retourne les éléments ayant comme valeur pour l'attribut version le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByVersion(String v) throws TopiaException {
        List<E> result = findAllByProperty("version", v);
        return result;
    }


} //TMSVersionDAOAbstract<E extends TMSVersion>
