/* *##% 
 * ToPIA :: Service Index
 * Copyright (C) 2004 - 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * ##%*/

/* *
 * IndexEngin.java
 *
 * Created: 8 oct. 06 17:15:00
 *
 * @author poussin
 * @version $Revision: 1459 $
 *
 * Last update: $Date: 2009-05-16 09:56:47 +0200 (Sat, 16 May 2009) $
 * by : $Author: tchemit $
 */

package org.nuiton.topia.index;

import java.util.Map;
import java.util.SortedSet;

import org.nuiton.topia.framework.TopiaService;


/**
 * User visible interface for indexation engin
 * 
 * To use indexer you must have properties defined in config file:
 * <li>topia.index.engin=[class used to indexation]
 * <li>possible specific property for index engin used
 * 
 * Usage example:
 * <pre>
 * SortedSet&lt;IndexEntry&gt; result = context.getIndexEngin().search("quelque chose")
 * SortedSet&lt;IndexEntry&gt; result = context.getIndexEngin().search("class:org.nuiton.chorem.entities.Person name:poussin")
 * // or with map 
 * Map m = new HashMap();
 * m.put("class", "org.nuiton.chorem.entities.Person");
 * m.put("name", "poussin");
 * SortedSet&lt;IndexEntry&gt; result = context.getIndexEngin().search(m);
 * </pre>
 * 

 * @author poussin
 */
public interface TopiaIndexService extends TopiaService {

    public static final String SERVICE_NAME = "index";
    
    /**
     * Permet de faire une recherche, par exemple:
     * 
     * class:org.nuiton.chorem.entities.Person name:poussin
     *  
     * @param queryText
     * @return une list triée, le premier élement a le plus gros score
     */
    public SortedSet<IndexEntry> search(String queryText);

    /**
     * Permet de faire une recherche
     * 
     * @param query la cle de la map est le nom du champ sur lequel faire la
     * recherche, et la valeur la valeur souhaitée pour ce champs
     * @return une list triée, le premier élement a le plus gros score
     */
    public SortedSet<IndexEntry> search(Map query);
    
}


