package org.nuiton.topia;

import java.lang.reflect.Array;
import java.util.Arrays;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.history.entities.History;
import org.nuiton.topia.history.entities.HistoryDAO;
import org.nuiton.topia.persistence.TopiaDAO;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityEnum;


public class TopiaHistoryDAOHelper {



    public enum TopiaHistoryEntityEnum implements TopiaEntityEnum {

        History(History.class);
        /**
         * the contract of the entity
         */
        protected Class<? extends TopiaEntity> contract;
        /**
         * the fully qualified name of the implementation of the entity
         */
        protected String implementationFQN;
        /**
         * the implementation class of the entity (will be lazy computed at runtime)
         */
        protected Class<? extends TopiaEntity> implementation;
        /**
         * TopiaHistoryEntityEnum :
             * @param contract 
     */

         TopiaHistoryEntityEnum(Class<? extends TopiaEntity > contract)     {
        this.contract = contract;
        this.implementationFQN = contract.getName()+"Impl";
        }

        /**
         * getContract :
             * @return Class<? extends TopiaEntity> 
     */

        public Class<? extends TopiaEntity> getContract()     {
        return contract;
        }

        /**
         * getImplementationFQN :
             * @return String 
     */

        public String getImplementationFQN()     {
        return implementationFQN;
        }

        /**
         * setImplementationFQN :
             * @param implementationFQN 
     */

        public void setImplementationFQN(String implementationFQN)     {
        this.implementationFQN = implementationFQN;
        this.implementation = null;
        }

        /**
         * accept :
             * @param klass 
         * @return boolean 
     */

        public boolean accept(Class<? extends TopiaEntity> klass)     {
         return TopiaHistoryDAOHelper.getContractClass(klass) == contract;
         }

        /**
         * getImplementation :
             * @return Class<? extends TopiaEntity> 
     */

        public Class<? extends TopiaEntity> getImplementation()     {
         if (implementation == null) {
            try {
                    implementation = (Class<? extends TopiaEntity>) Class.forName(implementationFQN);
                } catch (ClassNotFoundException e) {
                    throw new RuntimeException("could not find class " + implementationFQN);
                }
         }
         return implementation;
         }

        /**
         * valueOf :
             * @param entity 
         * @return TopiaHistoryEntityEnum 
     */

        public static TopiaHistoryEntityEnum valueOf(TopiaEntity entity)     {
         return valueOf(entity.getClass());
         }

        /**
         * valueOf :
             * @param klass 
         * @return TopiaHistoryEntityEnum 
     */

        public static TopiaHistoryEntityEnum valueOf(Class<?> klass)     {
         if (klass.isInterface()) {
            return TopiaHistoryEntityEnum.valueOf(klass.getSimpleName());
         }
         for (TopiaHistoryEntityEnum entityEnum : TopiaHistoryEntityEnum.values()) {
             if (entityEnum.getContract().isAssignableFrom(klass)) {
                 //todo check it works for inheritance
                 return entityEnum;
             }
         }
         throw new IllegalArgumentException("no entity defined for the class " + klass + " in : " + Arrays.toString(TopiaHistoryEntityEnum.values()));
         }


    } //TopiaHistoryEntityEnum
        /**
         * TopiaHistoryDAOHelper :
         */

        protected TopiaHistoryDAOHelper()     {     }

        /**
         * getModelVersion :
             * @return String 
     */

        public static String getModelVersion()     {
        return "1.1";
        }

        /**
         * getModelName :
             * @return String 
     */

        public static String getModelName()     {
        return "TopiaHistory";
        }

        /**
         * getHistoryDAO :
             * @param context 
         * @return HistoryDAO 
         * @throws TopiaException
     */

        public static HistoryDAO getHistoryDAO(TopiaContext context) throws TopiaException     {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        HistoryDAO result = (HistoryDAO) ci.getDAO(History.class);
        return result;
        }

        /**
         * getDAO :
             * @param context 
         * @param klass 
         * @return <T extends TopiaEntity, D extends TopiaDAO<? super T>> D 
         * @throws TopiaException
     */

        public static <T extends TopiaEntity, D extends TopiaDAO<? super T>> D getDAO(TopiaContext context, Class<T> klass) throws TopiaException     {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        TopiaHistoryEntityEnum constant = TopiaHistoryEntityEnum.valueOf(klass);
        D dao = (D) ci.getDAO(constant.getContract());
        return dao;
        }

        /**
         * getDAO :
             * @param context 
         * @param entity 
         * @return <T extends TopiaEntity, D extends TopiaDAO<? super T>> D 
         * @throws TopiaException
     */

        public static <T extends TopiaEntity, D extends TopiaDAO<? super T>> D getDAO(TopiaContext context, T entity) throws TopiaException     {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        TopiaHistoryEntityEnum constant = TopiaHistoryEntityEnum.valueOf(entity);
        D dao = (D) ci.getDAO(constant.getContract());
        return dao;
        }

        /**
         * getContractClass :
             * @param klass 
         * @return <T extends TopiaEntity> Class<T> 
     */

        public static <T extends TopiaEntity> Class<T> getContractClass(Class<T> klass)     {
        TopiaHistoryEntityEnum constant = TopiaHistoryEntityEnum.valueOf(klass);
        return (Class<T>) constant.getContract();
        }

        /**
         * getImplementationClass :
             * @param klass 
         * @return <T extends TopiaEntity> Class<T> 
     */

        public static <T extends TopiaEntity> Class<T> getImplementationClass(Class<T> klass)     {
        TopiaHistoryEntityEnum constant = TopiaHistoryEntityEnum.valueOf(klass);
        return (Class<T>) constant.getImplementation();
        }

        /**
         * getContractClasses :
             * @return Class<? extends TopiaEntity>[] 
     */

        public static Class<? extends TopiaEntity>[] getContractClasses()     {
        TopiaHistoryEntityEnum[] values = TopiaHistoryEntityEnum.values();
        Class<? extends TopiaEntity>[] result = (Class<? extends TopiaEntity>[]) Array.newInstance(Class.class, values.length);
        for (int i = 0; i < values.length; i++) {
            result[i] = values[i].getContract();
        }
        return result;
        }

        /**
         * getImplementationClasses :
             * @return Class<? extends TopiaEntity>[] 
     */

        public static Class<? extends TopiaEntity>[] getImplementationClasses()     {
        TopiaHistoryEntityEnum[] values = TopiaHistoryEntityEnum.values();
        Class<? extends TopiaEntity>[] result = (Class<? extends TopiaEntity>[]) Array.newInstance(Class.class, values.length);
        for (int i = 0; i < values.length; i++) {
            result[i] = values[i].getImplementation();
        }
        return result;
        }

        /**
         * getImplementationClassesAsString :
             * @return String 
     */

        public static String getImplementationClassesAsString()     {
        StringBuilder buffer = new StringBuilder();
        for (Class<? extends TopiaEntity> aClass : getImplementationClasses()) {
            buffer.append(',').append(aClass.getName());
        }
        return buffer.substring(1);
        }

        /**
         * getContracts :
             * @return TopiaHistoryEntityEnum[] 
     */

        public static TopiaHistoryEntityEnum[] getContracts()     {
        return TopiaHistoryEntityEnum.values();
        }


    } //TopiaHistoryDAOHelper
