/*
 * #%L
 * ToPIA :: Persistence
 * 
 * $Id: TopiaDAOTest.java 2416 2012-03-02 10:08:59Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/topia/tags/topia-2.6.9/topia-persistence/src/test/java/org/nuiton/topia/persistence/TopiaDAOTest.java $
 * %%
 * Copyright (C) 2004 - 2010 CodeLutin, Chatellier Eric
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

package org.nuiton.topia.persistence;

import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.matchers.JUnitMatchers;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaDatabase;
import org.nuiton.topia.TopiaTestDAOHelper;
import org.nuiton.topia.test.entities.Person;
import org.nuiton.topia.test.entities.PersonDAO;

import java.util.List;

/**
 * Test on {@link TopiaDAO}.
 * <p/>
 * Last update : $Date: 2012-03-02 11:08:59 +0100 (Fri, 02 Mar 2012) $
 * By : $Author: tchemit $
 *
 * @author chatellier
 * @version $Revision: 2416 $
 */
public class TopiaDAOTest {

    @Rule
    public final TopiaDatabase db = new TopiaDatabase();

    /**
     * Test de creer une entité et de verifier qu'elle est
     * présente dans la persistence au sein de la transaction.
     *
     * @throws Exception if any exception while test
     */
    @Test
    public void testCreateAndFindInTransaction() throws Exception {

        TopiaContext context = db.beginTransaction();

        PersonDAO personDAO = TopiaTestDAOHelper.getPersonDAO(context);

        // appel 1 find all
        Person person = personDAO.create(Person.PROPERTY_NAME, "toto");
        List<Person> allPerson = personDAO.findAll();
        Assert.assertEquals(1, allPerson.size());
        context.commitTransaction();

        // recherce la personne créée dans la même transaction
        Person person2 = personDAO.create(Person.PROPERTY_NAME, "titi");
        allPerson = personDAO.findAll();
        Assert.assertEquals(2, allPerson.size());
        Assert.assertThat(allPerson, JUnitMatchers.hasItem(person2));

        context.rollbackTransaction();

        // meme test apres roolback
        Person person3 = personDAO.create(Person.PROPERTY_NAME, "tata");
        allPerson = personDAO.findAll();
        Assert.assertEquals(2, allPerson.size());
        Assert.assertThat(allPerson, JUnitMatchers.hasItem(person3));

        context.commitTransaction();
    }
}
