/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.persistence.csv.in;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.Map;
import java.util.Set;
import org.nuiton.topia.persistence.TopiaEntityEnum;

public class CsvFileImportResult<T extends TopiaEntityEnum>
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected final String importFileName;
    protected final Set<T> entityTypes;
    protected final Map<T, Integer> numberCreated;
    protected final Map<T, Integer> numberUpdated;

    public static <T extends TopiaEntityEnum> CsvFileImportResult<T> newResult(String importFileName, T ... universe) {
        CsvFileImportResult result = new CsvFileImportResult(importFileName, universe);
        return result;
    }

    public CsvFileImportResult(String importFileName, T ... universe) {
        this.importFileName = importFileName;
        this.entityTypes = Sets.newHashSet();
        this.numberCreated = Maps.newHashMap();
        this.numberUpdated = Maps.newHashMap();
        for (T t : universe) {
            this.numberCreated.put(t, 0);
            this.numberUpdated.put(t, 0);
        }
    }

    public Set<T> getEntityTypes() {
        return ImmutableSet.copyOf(this.entityTypes);
    }

    public int getNumberCreated(T entityType) {
        return this.getInteger(this.numberCreated, entityType);
    }

    public int getNumberUpdated(T entityType) {
        return this.getInteger(this.numberUpdated, entityType);
    }

    public String getImportFileName() {
        return this.importFileName;
    }

    public void incrementsNumberCreated(T entityType) {
        this.increments(this.numberCreated, entityType);
    }

    public void incrementsNumberUpdated(T entityType) {
        this.increments(this.numberUpdated, entityType);
    }

    protected int getInteger(Map<T, Integer> map, T entityType) {
        Integer result = map.get(entityType);
        return result == null ? 0 : result;
    }

    protected void increments(Map<T, Integer> map, T entityType) {
        Integer result = map.get(entityType);
        if (result == null) {
            this.entityTypes.add(entityType);
            result = 0;
        }
        result = result + 1;
        map.put(entityType, result);
    }
}

