package org.nuiton.topia;

import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.util.TopiaEntityBinder;
import org.nuiton.topia.persistence.util.TopiaEntityHelper;
import org.nuiton.topia.test.entities.Person;
import org.nuiton.topia.test.entities.Pet;
import org.nuiton.topia.test.entities.Race;
import org.nuiton.topiatest.Address;
import org.nuiton.topiatest.Bill;
import org.nuiton.topiatest.Company;
import org.nuiton.topiatest.Department;
import org.nuiton.topiatest.Employe;
import org.nuiton.topiatest.ExtraDAOEntity;
import org.nuiton.topiatest.NaturalizedEntity;
import org.nuiton.topiatest.Personne;
import org.nuiton.topiatest.Product;
import org.nuiton.topiatest.QueriedEntity;
import org.nuiton.topiatest.Store;
import org.nuiton.topiatest.Type;
import org.nuiton.topiatest.deletetest.Contact2;
import org.nuiton.topiatest.deletetest.Telephone2;
import org.nuiton.util.beans.BinderBuilder;
import org.nuiton.util.beans.BinderProvider;


public  class TopiaTestBinderHelper extends BinderProvider {

    /**
     * getTopiaBinder :
     * @param entityClass 
     * @param contextName 
     * @return <E extends TopiaEntity> TopiaEntityBinder<E> 
     */

    public static <E extends TopiaEntity> TopiaEntityBinder<E> getTopiaBinder(Class<E> entityClass, String contextName) {
        return (TopiaEntityBinder<E>) getBinder(entityClass, contextName);
    }

    /**
     * getSimpleTopiaBinder :
     * @param entityClass 
     * @return <E extends TopiaEntity> TopiaEntityBinder<E> 
     */

    public static <E extends TopiaEntity> TopiaEntityBinder<E> getSimpleTopiaBinder(Class<E> entityClass) {
        return getTopiaBinder(entityClass, "TopiaTest");
    }

    /**
     * registerTopiaBinder :
     * @param builder 
     * @param contextName 
     */

    public static void registerTopiaBinder(BinderBuilder builder, String contextName) {
       BinderProvider.registerBinder(builder, TopiaEntityBinder.class, contextName);
    }

    /**
     * registerTopiaBinder :
     * @param entityClass 
     * @param builder 
     * @param contextName 
     * @return <E extends TopiaEntity> TopiaEntityBinder<E> 
     */

    public static <E extends TopiaEntity> TopiaEntityBinder<E> registerTopiaBinder(Class<E> entityClass, BinderBuilder builder, String contextName) {
       BinderProvider.registerBinder(builder, TopiaEntityBinder.class, contextName);
       return getTopiaBinder(entityClass, contextName);
    }

    /**
     * copy :
     * @param contextName 
     * @param source 
     * @param target 
     * @param tech 
     */

    public static <E extends TopiaEntity> void copy(String contextName, E source, E target, boolean tech) {
        Class<E> entityClass = (Class<E>) TopiaEntityHelper.getContractClass(TopiaTestDAOHelper.getContracts(), target.getClass());
        TopiaEntityBinder<E> binder = getTopiaBinder(entityClass, contextName);
        if (binder == null) {
            throw new NullPointerException("could not find a simple topia binder of type : " + target.getClass());
        }
        binder.load(source, target, tech);
    }

    /**
     * simpleCopy :
     * @param source 
     * @param target 
     * @param tech 
     */

    public static <E extends TopiaEntity> void simpleCopy(E source, E target, boolean tech) {
        Class<E> entityClass = (Class<E>) TopiaEntityHelper.getContractClass(TopiaTestDAOHelper.getContracts(), target.getClass());
        TopiaEntityBinder<E> binder = getSimpleTopiaBinder(entityClass);
        if (binder == null) {
            throw new NullPointerException("could not find a simple topia binder of type : " + target.getClass());
        }
        binder.load(source, target, tech);
    }

    /**
     * initBinders :
     */

    protected static void initBinders() {
         BinderBuilder builder = new BinderBuilder();

        builder.createBinderModel(Person.class);
        builder.addSimpleProperties(
            Person.PROPERTY_NAME,
            Person.PROPERTY_FIRSTNAME
        );
        registerTopiaBinder(builder, "TopiaTest");
    
        builder.createBinderModel(Pet.class);
        builder.addSimpleProperties(
            Pet.PROPERTY_NAME,
            Pet.PROPERTY_TYPE,
            Pet.PROPERTY_PERSON,
            Pet.PROPERTY_RACE
        );
        registerTopiaBinder(builder, "TopiaTest");
    
        builder.createBinderModel(Race.class);
        builder.addSimpleProperties(
            Race.PROPERTY_NAME
        );
        registerTopiaBinder(builder, "TopiaTest");
    
        builder.createBinderModel(Address.class);
        builder.addSimpleProperties(
            Address.PROPERTY_CITY,
            Address.PROPERTY_ADRESS
        );
        registerTopiaBinder(builder, "TopiaTest");
    
        builder.createBinderModel(Bill.class);
        builder.addSimpleProperties(
            Bill.PROPERTY_COST,
            Bill.PROPERTY_DATE,
            Bill.PROPERTY_PAID
        );
        registerTopiaBinder(builder, "TopiaTest");
    
        builder.createBinderModel(Company.class);
        builder.addSimpleProperties(
            Company.PROPERTY_NAME,
            Company.PROPERTY_SIRET
        );
        registerTopiaBinder(builder, "TopiaTest");
    
        builder.createBinderModel(Department.class);
        builder.addSimpleProperties(
            Department.PROPERTY_NAME,
            Department.PROPERTY_LEADER,
            Department.PROPERTY_COMPANY
        );
        registerTopiaBinder(builder, "TopiaTest");
    
        builder.createBinderModel(Employe.class);
        builder.addSimpleProperties(
            Employe.PROPERTY_SALARY
        );
        registerTopiaBinder(builder, "TopiaTest");
    
        builder.createBinderModel(ExtraDAOEntity.class);
        builder.addSimpleProperties(
            ExtraDAOEntity.PROPERTY_ATTR1
        );
        registerTopiaBinder(builder, "TopiaTest");
    
        builder.createBinderModel(NaturalizedEntity.class);
        builder.addSimpleProperties(
            NaturalizedEntity.PROPERTY_NATURAL_ID_NOT_NULL,
            NaturalizedEntity.PROPERTY_NATURAL_ID_NULL
        );
        registerTopiaBinder(builder, "TopiaTest");
    
        builder.createBinderModel(Personne.class);
        builder.addSimpleProperties(
            Personne.PROPERTY_NAME,
            Personne.PROPERTY_GENDER,
            Personne.PROPERTY_ADDRESS
        );
        registerTopiaBinder(builder, "TopiaTest");
    
        builder.createBinderModel(Product.class);
        builder.addSimpleProperties(
            Product.PROPERTY_NAME,
            Product.PROPERTY_TYPE
        );
        registerTopiaBinder(builder, "TopiaTest");
    
        builder.createBinderModel(QueriedEntity.class);
        builder.addSimpleProperties(
            QueriedEntity.PROPERTY_TEST_ADD
        );
        registerTopiaBinder(builder, "TopiaTest");
    
        builder.createBinderModel(Store.class);
        builder.addSimpleProperties(
            Store.PROPERTY_NAME
        );
        registerTopiaBinder(builder, "TopiaTest");
    
        builder.createBinderModel(Type.class);
        builder.addSimpleProperties(
            Type.PROPERTY_NAME
        );
        registerTopiaBinder(builder, "TopiaTest");
    
        builder.createBinderModel(Contact2.class);
        builder.addSimpleProperties(
            Contact2.PROPERTY_CONTACT_VALUE,
            Contact2.PROPERTY_TYPE
        );
        registerTopiaBinder(builder, "TopiaTest");
    
        builder.createBinderModel(Telephone2.class);
        builder.addSimpleProperties(
            Telephone2.PROPERTY_PREFIX,
            Telephone2.PROPERTY_COUNTRY
        );
        registerTopiaBinder(builder, "TopiaTest");
    }

static {
    
    initBinders();

    }

} //TopiaTestBinderHelper
