/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.asm.util;

import java.io.FileInputStream;
import java.io.InputStream;
import java.io.PrintWriter;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.CodeVisitor;
import org.objectweb.asm.util.PrintClassVisitor;
import org.objectweb.asm.util.TraceCodeVisitor;

public class TraceClassVisitor
extends PrintClassVisitor {
    protected final ClassVisitor cv;

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length < 1 || stringArray.length > 2) {
            TraceClassVisitor.printUsage();
        }
        int n = 0;
        boolean bl = true;
        if (stringArray[0].equals("-debug")) {
            n = 1;
            bl = false;
            if (stringArray.length != 2) {
                TraceClassVisitor.printUsage();
            }
        }
        ClassReader classReader = stringArray[n].endsWith(".class") ? new ClassReader((InputStream)new FileInputStream(stringArray[n])) : new ClassReader(stringArray[n]);
        classReader.accept((ClassVisitor)new TraceClassVisitor(null, new PrintWriter(System.out)), TraceClassVisitor.getDefaultAttributes(), bl);
    }

    private static void printUsage() {
        System.err.println("Prints a disassembled view of the given class.");
        System.err.println("Usage: TraceClassVisitor [-debug] <fully qualified class name or class file name>");
        System.exit(-1);
    }

    public TraceClassVisitor(ClassVisitor classVisitor, PrintWriter printWriter) {
        super(printWriter);
        this.cv = classVisitor;
    }

    public void visit(int n, int n2, String string, String string2, String[] stringArray, String string3) {
        int n3 = n & 0xFFFF;
        int n4 = n >>> 16;
        this.buf.setLength(0);
        this.buf.append("// class version " + n3 + "." + n4 + " (" + n + ")\n");
        if ((n2 & 0x20000) != 0) {
            this.buf.append("// DEPRECATED\n");
        }
        if (string3 != null) {
            this.buf.append("// compiled from ").append(string3).append("\n");
        }
        this.buf.append("// access flags ").append(n2).append("\n");
        this.appendAccess(n2 & 0xFFFFFFDF);
        if ((n2 & 0x2000) != 0) {
            this.buf.append("@interface ");
        } else if ((n2 & 0x200) != 0) {
            this.buf.append("interface ");
        } else if ((n2 & 0x4000) != 0) {
            this.buf.append("enum ");
        } else {
            this.buf.append("class ");
        }
        this.buf.append(string).append(" ");
        if (string2 != null && !string2.equals("java/lang/Object")) {
            this.buf.append("extends ").append(string2).append(" ");
        }
        if (stringArray != null && stringArray.length > 0) {
            this.buf.append("implements ");
            for (int i = 0; i < stringArray.length; ++i) {
                this.buf.append(stringArray[i]).append(" ");
            }
        }
        this.buf.append("{\n\n");
        this.text.add(this.buf.toString());
        if (this.cv != null) {
            this.cv.visit(n, n2, string, string2, stringArray, string3);
        }
    }

    public void visitInnerClass(String string, String string2, String string3, int n) {
        this.buf.setLength(0);
        this.buf.append("  INNERCLASS ").append(string).append(" ").append(string2).append(" ").append(string3).append(" ");
        this.appendAccess(n & 0xFFFFFFDF);
        if ((n & 0x4000) != 0) {
            this.buf.append("enum ");
        }
        this.buf.append("\n");
        this.text.add(this.buf.toString());
        if (this.cv != null) {
            this.cv.visitInnerClass(string, string2, string3, n);
        }
    }

    public void visitField(int n, String string, String string2, Object object, Attribute attribute) {
        this.buf.setLength(0);
        if ((n & 0x20000) != 0) {
            this.buf.append("  // DEPRECATED\n");
        }
        this.buf.append("  // access flags ").append(n).append("\n");
        this.buf.append("  ");
        this.appendAccess(n);
        if ((n & 0x4000) != 0) {
            this.buf.append("enum ");
        }
        this.buf.append(string2).append(" ").append(string);
        if (object != null) {
            this.buf.append(" = ");
            if (object instanceof String) {
                this.buf.append("\"").append(object).append("\"");
            } else {
                this.buf.append(object);
            }
        }
        Attribute attribute2 = attribute;
        while (attribute2 != null) {
            this.buf.append("  FIELD ATTRIBUTE ").append(attribute2.type).append(" : ").append(attribute2.toString()).append("\n");
            attribute2 = attribute2.next;
        }
        this.buf.append("\n");
        this.text.add(this.buf.toString());
        if (this.cv != null) {
            this.cv.visitField(n, string, string2, object, attribute);
        }
    }

    public CodeVisitor visitMethod(int n, String string, String string2, String[] stringArray, Attribute attribute) {
        this.buf.setLength(0);
        if ((n & 0x20000) != 0) {
            this.buf.append("  // DEPRECATED\n");
        }
        this.buf.append("  // access flags ").append(n).append("\n");
        this.buf.append("  ");
        this.appendAccess(n);
        if ((n & 0x100) != 0) {
            this.buf.append("native ");
        }
        if ((n & 0x80) != 0) {
            this.buf.append("varargs ");
        }
        if ((n & 0x40) != 0) {
            this.buf.append("bridge ");
        }
        this.buf.append(string).append(" ").append(string2);
        if (stringArray != null && stringArray.length > 0) {
            this.buf.append(" throws ");
            for (int i = 0; i < stringArray.length; ++i) {
                this.buf.append(stringArray[i]).append(" ");
            }
        }
        this.buf.append("\n");
        this.text.add(this.buf.toString());
        Attribute attribute2 = attribute;
        while (attribute2 != null) {
            this.buf.setLength(0);
            this.buf.append("    METHOD ATTRIBUTE ").append(attribute2.type).append(" : ").append(attribute2.toString()).append("\n");
            this.text.add(this.buf.toString());
            attribute2 = attribute2.next;
        }
        CodeVisitor codeVisitor = this.cv != null ? this.cv.visitMethod(n, string, string2, stringArray, attribute) : null;
        TraceCodeVisitor traceCodeVisitor = new TraceCodeVisitor(codeVisitor);
        this.text.add(traceCodeVisitor.getText());
        return traceCodeVisitor;
    }

    public void visitAttribute(Attribute attribute) {
        this.buf.setLength(0);
        this.buf.append("  CLASS ATTRIBUTE ").append(attribute.type).append(" : ").append(attribute.toString()).append("\n");
        this.text.add(this.buf.toString());
        if (this.cv != null) {
            this.cv.visitAttribute(attribute);
        }
    }

    public void visitEnd() {
        this.text.add("}\n");
        if (this.cv != null) {
            this.cv.visitEnd();
        }
        super.visitEnd();
    }

    private void appendAccess(int n) {
        if ((n & 1) != 0) {
            this.buf.append("public ");
        }
        if ((n & 2) != 0) {
            this.buf.append("private ");
        }
        if ((n & 4) != 0) {
            this.buf.append("protected ");
        }
        if ((n & 0x10) != 0) {
            this.buf.append("final ");
        }
        if ((n & 8) != 0) {
            this.buf.append("static ");
        }
        if ((n & 0x20) != 0) {
            this.buf.append("synchronized ");
        }
        if ((n & 0x40) != 0) {
            this.buf.append("volatile ");
        }
        if ((n & 0x80) != 0) {
            this.buf.append("transient ");
        }
        if ((n & 0x400) != 0) {
            this.buf.append("abstract ");
        }
        if ((n & 0x800) != 0) {
            this.buf.append("strictfp ");
        }
    }
}

