/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.scmwebeditor.uiweb;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.config.ApplicationConfig;
import org.nuiton.config.ArgumentsParserException;
import org.nuiton.scmwebeditor.api.ScmProvider;
import org.nuiton.scmwebeditor.api.SweInternalException;
import org.nuiton.scmwebeditor.uiweb.ScmWebEditorConfigOption;

/*
 * Exception performing whole class analysis ignored.
 */
public class ScmWebEditorConfig {
    private static final Log log = LogFactory.getLog(ScmWebEditorConfig.class);
    public static final String CONFIG_CODE_MIRROR_VERSION_PROPERTY = "swe.codeMirror.version";
    protected static ApplicationConfig config;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ApplicationConfig getConfig(String ... args) {
        if (config != null) return config;
        Class<ScmWebEditorConfig> clazz = ScmWebEditorConfig.class;
        synchronized (ScmWebEditorConfig.class) {
            if (config != null) return config;
            config = new ApplicationConfig(ScmWebEditorConfigOption.CONFIG_FILE.getDefaultValue());
            try {
                config.parse(args);
            }
            catch (ArgumentsParserException e) {
                if (!log.isErrorEnabled()) return config;
                log.error((Object)"Error when parsing ApplicationConfig", (Throwable)e);
            }
            return config;
        }
    }

    public static List<String> getEditableFiles() {
        return ScmWebEditorConfig.getConfig((String[])new String[0]).getOptionAsList(ScmWebEditorConfigOption.EDITABLE_FILES.getKey()).getOption();
    }

    public static String getLocalRepositoriesPath() {
        String key = ScmWebEditorConfigOption.LOCAL_REPOSITORIES_PATH.getKey();
        return ScmWebEditorConfig.getConfig((String[])new String[0]).getOption(key);
    }

    public static Map<String, String> getProviders() {
        HashMap<String, String> providers = new HashMap<String, String>();
        String key = ScmWebEditorConfigOption.PROVIDERS.getKey();
        Properties options = ScmWebEditorConfig.getConfig((String[])new String[0]).getOptionStartsWith(key);
        for (String propertyName : options.stringPropertyNames()) {
            String providerKey = propertyName.substring(propertyName.lastIndexOf(46) + 1);
            String providerClass = ScmWebEditorConfig.getConfig((String[])new String[0]).getOption(propertyName);
            providers.put(providerKey, providerClass);
        }
        return providers;
    }

    public static String getKey() {
        return ScmWebEditorConfig.getConfig((String[])new String[0]).getOption(ScmWebEditorConfigOption.COOKIES_PRIVATE_KEY.getKey());
    }

    public static String getVersion() {
        return ScmWebEditorConfig.getConfig((String[])new String[0]).getOption(ScmWebEditorConfigOption.VERSION.getKey());
    }

    public static String getCodeMirrorVersion() {
        return ScmWebEditorConfig.getConfig((String[])new String[0]).getOption("swe.codeMirror.version");
    }

    public static int getAutoSaveInterval() {
        String readValue = ScmWebEditorConfig.getConfig((String[])new String[0]).getOption(ScmWebEditorConfigOption.AUTO_SAVE_INTERVAL.getKey());
        return Integer.parseInt(readValue);
    }

    public static ScmProvider getProvider(String scmType) {
        Map providers = ScmWebEditorConfig.getProviders();
        String providerClassName = (String)providers.get(scmType);
        ScmProvider provider = null;
        if (providerClassName != null) {
            try {
                Class<?> providerClass = Class.forName(providerClassName);
                provider = (ScmProvider)providerClass.newInstance();
            }
            catch (ClassNotFoundException e) {
                if (log.isErrorEnabled()) {
                    log.error((Object)("Can not find SCM '" + scmType + "'"), (Throwable)e);
                }
                throw new SweInternalException("Can not find SCM '" + scmType + "'", (Throwable)e);
            }
            catch (InstantiationException e) {
                if (log.isErrorEnabled()) {
                    log.error((Object)("Can not instantiate class " + providerClassName), (Throwable)e);
                }
                throw new SweInternalException("Can not instantiate class '" + providerClassName + "'", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                if (log.isErrorEnabled()) {
                    log.error((Object)("Can not access to class " + providerClassName), (Throwable)e);
                }
                throw new SweInternalException("Can not access to class " + providerClassName, (Throwable)e);
            }
        } else {
            throw new SweInternalException("Can not find the provider '" + scmType + "' in the configuration file");
        }
        return provider;
    }
}

