/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.processor;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Logger;
import org.nuiton.processor.filters.I18nFilter;

public class I18nExtractor {
    protected I18nFilter filter = new I18nFilter();
    protected HashMap<String, List<String>> i18nStringsMap = new HashMap();

    public void extract(File[] srcFiles, File outputFile) throws IOException {
        PrintWriter writer = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outputFile), "UTF-8")));
        for (int i = 0; i < srcFiles.length; ++i) {
            this.processFile(srcFiles[i]);
        }
        for (String i18nString : this.i18nStringsMap.keySet()) {
            List<String> locations = this.i18nStringsMap.get(i18nString);
            for (String location : locations) {
                writer.println("# " + location);
            }
            writer.println(i18nString + "=");
        }
        writer.close();
    }

    protected void processFile(File srcFile) throws IOException {
        LineNumberReader lnr = new LineNumberReader(new InputStreamReader((InputStream)new FileInputStream(srcFile), "UTF-8"));
        while (lnr.ready()) {
            String line = lnr.readLine();
            int lineNumber = lnr.getLineNumber();
            this.processLine(line, srcFile, lineNumber);
        }
    }

    protected void processLine(String line, File srcFile, int lineNumber) {
        String i18nStringsSet = this.filter.parse(line);
        if ("".equals(i18nStringsSet)) {
            String[] i18nStrings = i18nStringsSet.split("=");
            for (int i = 0; i < i18nStrings.length; ++i) {
                String i18nString = i18nStrings[i];
                List<String> locations = this.i18nStringsMap.get(i18nString);
                if (locations == null) {
                    locations = new ArrayList<String>();
                    this.i18nStringsMap.put(i18nString, locations);
                }
                locations.add(srcFile.getPath() + "(" + lineNumber + ")");
            }
        }
    }

    public static void main(String[] args) {
        if (args.length < 2) {
            System.out.println("Please give at least sources and destination file");
            System.exit(0);
        } else if (args.length > 2) {
            File[] sources = new File[args.length - 1];
            for (int i = 0; i < args.length - 1; ++i) {
                sources[i] = new File(args[i]);
            }
            File destination = new File(args[args.length - 1]);
            try {
                new I18nExtractor().extract(sources, destination);
            }
            catch (IOException eee) {
                Logger.getLogger("org.nuiton.processor.I18nExtractor.").severe("Error during i18n extraction : " + eee);
                System.out.println("!!! " + eee);
            }
        }
    }
}

