/*
 * *##% 
 * Nuiton processor library
 * Copyright (C) 2002 - 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * ##%*
 */

/* *
 * GeneratorTemplatesFilter.java
 *
 * Created: Wed Sep  4 2002
 *
 * @author  <pineau@codelutin.com>
 * Copyright Code Lutin
 * @version $Revision: 268 $
 *
 * Mise a jour: $Date: 2009-08-29 18:46:57 +0200 (sam., 29 août 2009) $
 * par : $Author: tchemit $
 */

/**
 * MultilinesLitteralsFilter.java
 */

package org.nuiton.processor.filters;

/*
 * Classe principale du filtre de génération. Ce filtre recherche tout ce qu'il
 * y a entre les tag &#47;*{ et }*&#47; a l'interieur de ces tags un autre filtre
 * ({@link org.nuiton.processor.filters.GeneratorTemplatesFilterIn}) est
 * utilisé pour générer les tags &lt;% %&gt;, &lt;%= %&gt; et *).
 * <ul>
 *  <li>&#47;*{ et }*&#47; est remplacer par output.write("..."); pour chaque
 * ligne et les " sont coté</li>
 *  <li>&lt;% %&gt;</li>
 *  <li>&lt;%= %&gt;</li>
 *  <li>*) permet de fermer un commentaire sans le fermer réeellement, cela
 *      permet au éditeur faisant une analyse du code de continuer a fonctionner
 *      ce tag est remplacé par son equivalent *&#47; après génération.</li>
 * </ul>
 * Vous pouvez modifier le comportement du processor en mettant des options
 * Une option est incluse dans le tag et est de la forme
 * &#47;*{generator option: <optionName> = valeur}*&#47;
 * les options existantes sont:
 * <li>passEmptyLine: boolean; cette option permet de supprimer la première
 * et la dernière ligne si elles sont videx</li>
 * <li>wtriteString: String, default: output.write</li>
 */
public class GeneratorTemplatesFilter extends DefaultFilter {

    protected boolean passEmptyLine = false;
    protected String writeString = "output.write";

    protected GeneratorTemplatesFilterIn inFilter = new GeneratorTemplatesFilterIn(this);

    public String getWriteString(){
        return writeString;
    }

    /**
     * methode appele lorsqu'on a la chaine entiere entre le header
     * et le footer.
     * @param ch la chaine trouve
     * @return ce qu'il faut ecrire dans le fichier de sortie
     */
    protected String performInFilter(String ch){
        if(ch.matches("generator option: *passEmptyLine *= *(true|false)")){
            passEmptyLine =
                "true".equalsIgnoreCase(ch.substring(ch.length()-4));
            return EMPTY_STRING;
        }else if(ch.matches("generator option: *writeString *= *.*")){
            writeString =
                ch.replaceAll("generator option: *writeString *= *(.*)", "$1");
            return EMPTY_STRING;
        }else{
            if (passEmptyLine && ch.length() > 0){
                // suppression des premieres et dernieres lignes si elles sont vides
                String [] all = ch.split("\n");
                if (all.length > 0){
                    // si la derniere ne match que des blancs
                    if(all[all.length-1].matches("\\s*")){
                        int len = ch.length()-all[all.length-1].length()-1;
                        ch = ch.substring(0, Math.max(len,0));
                    }

                    // suppression de la 1er ligne si elle est vide
                    if(all[0].matches("\\s*")){
                        int len = all[0].length()+1;
                        ch = ch.substring(Math.min(ch.length(),len));
                    }
                }
            }

            String result = inFilter.parse(ch) + inFilter.flush();
            return getWriteString()+ "(\"" + result + "\");";
        }
    }

    /**
     * methode appele lorsqu'on a la chaine entiere a l'exterieur du
     * header/footer
     * @param ch la chaine trouve
     * @return ce qu'il faut ecrire dans le fichier de sortie
     */
    protected String performOutFilter(String ch) {
        return ch;
    }


    /** la chaine du header */
    protected String getHeader() {
        return "/*{";
    }

    /** la chaine du footer */
    protected String getFooter() {
        return "}*/";
    }

    public static void main(String[] args) {
    	Filter filter = new GeneratorTemplatesFilter();
    	String res = filter.parse("   public void generatePackageStatement(Writer output, ObjectModelClassifier clazz) throws IOException {\n/*{\n package <%=clazz.getPackageName()%>.persistence.jdo; \n}*/ }");
    	System.out.println(res);
    	res = filter.flush();
    	System.out.println(res);
	}
    
    
}
