/*
 * *##% nuiton-processor - maven plugin
 * Copyright (C) 2006 - 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>. ##%*
 */
package org.nuiton.processor.ant;

import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.nuiton.processor.Processor;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.nuiton.processor.ProcessorUtil;

/**
 * Tache ant pour lutinprocessor.
 * 
 * To use this task, put this code in ant build file:
 * 
 * <taskdef name="processor" classname="org.nuiton.processor.ant.ProcessorTask"
 *      classpath="lib/lutinprocessor.jar" />
 * 
 * and use it with:
 * 
 * <processor srcdir="${src}" destdir="${targetgen}" filters="org.nuiton.processor.filters.GeneratorTemplatesFilter" />
 *
 * Created: 14 janv. 2004
 * 
 * @author Benjamin Poussin <poussin@codelutin.com> Copyright Code Lutin
 * 
 * @version $Revision: 255 $
 * 
 * Mise a jour: $Date: 2009-08-16 09:50:25 +0200 (dim., 16 août 2009) $ par : $Author: tchemit $
 */
public class ProcessorTask extends MatchingTask { // ProcessorTask

    public static final int MSG_VERBOSE = Project.MSG_VERBOSE;
    protected File srcDir;
    protected File destDir;
    protected String[] includes = new String[]{};
    protected String[] excludes = new String[]{};
    protected String[] files;
    protected String fileInPattern = "";
    protected String fileOutPattern = "";
    protected String filters = "org.nuiton.processor.filters.NoActionFilter";
    protected boolean overwrite = true;
    protected boolean verbose = false;

    public ProcessorTask() {
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }

    public void setFileOutPattern(String fileOutPattern) {
        this.fileOutPattern = fileOutPattern;
    }

    public void setFileInPattern(String fileInPattern) {
        this.fileInPattern = fileInPattern;
    }

    public void setSrcdir(File srcDir) {
        this.srcDir = srcDir;
    }

    public void setDestdir(File destDir) {
        this.destDir = destDir;
    }

    public void setFilters(String filters) {
        this.filters = filters;
    }

    protected String applyTransformationFilename(String filename) {
        return filename.replaceAll(fileInPattern, fileOutPattern);
    }

    protected void doExecute() throws BuildException {
        Processor processor=null;
        try {
            processor = ProcessorUtil.newProcessor(this.filters, ",");
        } catch (Exception ex) {
            throw new BuildException("Could nto instanciate processor for reason : "+ex.getMessage(), ex);
        }
//        Processor processor = new Processor(getFilters());
        int numberFiles;
        for (numberFiles = 0; numberFiles < files.length; numberFiles++) {
            String inputFileName = absoluteSourceName(files[numberFiles]);
            String outputFileName = absoluteDestinationName(applyTransformationFilename(files[numberFiles]));
            if (verbose) {
                log("Using " + inputFileName);
            }
            if (overwrite || isNewer(inputFileName, outputFileName)) {
                if (verbose) {
                    log("Generating " + outputFileName);
                }
                // creation du repertoire pour le fichier destination
                new File(outputFileName).getParentFile().mkdirs();
                try {
                    processor.process(new FileReader(inputFileName),
                            new FileWriter(outputFileName));
                } catch (IOException eee) {
                    throw new BuildException(eee);
                }
            }
        }
        log("Generating " + numberFiles + " files to " + destDir);
    }

//    protected Filter[] getFilters() throws BuildException {
//        Filter[] result;
//        try {
//            result = ProcessorUtil.getFilters(filters, ",");
//        } catch (Exception eee) {
//            throw new BuildException(eee.getMessage(), eee);
//        }
////        String[] filterList = filters.split(",");
////        Filter[] result = new Filter[filterList.length];
////        for (int i = 0; i < filterList.length; i++) {
////            try {
////                // Class.forName semble fonctionner maintenant
////                // avant il fallait utiliser getClass().forName
////                result[i] = (Filter) Class.forName(filterList[i].trim())
////                        .newInstance();
////            } catch (Exception eee) {
////                throw new BuildException("Error during looking for '"
////                        + filterList[i].trim() + "' class", eee);
////            }
////        }
//        return result;
//    }

    @Override
    public void execute() throws BuildException {
        // first of all, make sure that we've got a srcdir
        if (srcDir == null) {
            throw new BuildException("srcdir attribute must be set!",
                    getLocation());
        }
        if (!srcDir.exists()) {
            throw new BuildException("srcdir \"" + srcDir.getPath() + "\" does not exist!", getLocation());
        }

        if (destDir == null) {
            destDir = srcDir;
        }
        if (!destDir.isDirectory()) {
            throw new BuildException("destination directory \"" + destDir + "\" does not exist or is not a directory", getLocation());
        }

        // Build the list of files to compute
        buildFileList();

        // generate the source files
        doExecute();
    }

    protected void buildFileList() {

        // Obtain this list of files within the source directory
        DirectoryScanner ds = getDirectoryScanner(srcDir);

        String[] includes = getIncludes();
        if (includes.length > 0) {
            ds.setIncludes(includes);
        }
        String[] excludes = getExcludes();
        if (excludes.length > 0) {
            ds.setExcludes(excludes);
        }

        ds.scan();

        // on recherche ceux que l'on doit vraiment refaire
        files = ds.getIncludedFiles();
    }

    protected boolean isNewer(String filein, String fileout) {
        boolean result = new File(filein).lastModified() > new File(fileout).lastModified();
        if (result) {
            log(filein + " is newer than " + fileout, MSG_VERBOSE);
        }
        return result;
    }

    protected String[] getExcludes() {
        return excludes;
    }

    protected String[] getIncludes() {
        return includes;
    }

    public void setIncludes(String[] includes) {
        this.includes = includes;
    }

    @Override
    public void setIncludes(String includes) {
        setIncludes(includes.split(","));
    }

    public void setExcludes(String[] excludes) {
        this.excludes = excludes;
    }

    @Override
    public void setExcludes(String excludes) {
        setExcludes(excludes.split(","));
    }

    protected String absoluteDestinationName(String fileName) {
        return destDir.getPath() + File.separator + fileName;
    }

    protected String absoluteSourceName(String fileName) {
        return srcDir.getPath() + File.separator + fileName;
    }
} // ProcessorTask
