/*
 * #%L
 * Graphical Widget
 * 
 * $Id: ApplicationMonitor.java 300 2010-11-17 21:35:44Z sletellier $
 * $HeadURL: http://svn.nuiton.org/svn/nuiton-widgets/tags/nuiton-widgets-1.0.4/src/main/java/org/nuiton/widget/ApplicationMonitor.java $
 * %%
 * Copyright (C) 2004 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

/*******************************************************************************
 * ApplicationMontior.java
 *
 * Created: Jul 29, 2004
 *
 * @author Cedric Pineau <pineau@codelutin.com>
 *
 * @version $Revision: 300 $
 *
 * Last update : $Date: 2010-11-17 22:35:44 +0100 (mer., 17 nov. 2010) $ by : $Author: sletellier $
 */

package org.nuiton.widget;

import static org.nuiton.i18n.I18n._;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.DateFormat;
import java.util.Date;
import java.util.Properties;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Part;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.log.LutinLog;
import org.nuiton.log.LutinLogEvent;
import org.nuiton.log.LutinLogFactory;
import org.nuiton.log.LutinLogListener;
import org.nuiton.log.LutinProgressEvent;

/**
 * @deprecated since 1.0.4, will be removed in 1.1, depends on remove lutinlog
 */
@Deprecated
public class ApplicationMonitor extends JPanel {

    private static final long serialVersionUID = 1L;
    
    /**
     * nombre de ligne a conserver au debut des logs ex: param de lancement si
     * egal a -1 en meme temps que DEFAULT_FOOTER_LINE alors tout le log est
     * conservé
     */
    public static int DEFAULT_HEADER_LINE = 100;

    /**
     * nombre de ligne a conserver en fin des logs ex: stack trace si egal a -1
     * en meme temps que DEFAULT_HEADER_LINE alors tout le log est conservé
     */
    public static int DEFAULT_FOOTER_LINE = 200;

    public final static String DEFAULT_LOGGING_SYSTEM = "";

    public final static String DEFAULT_SMTP_SERVER = "localhost";

    public final static String DEFAULT_FROM_ADDRESS = "applicationMonitor@users.net";

    public final static String DEFAULT_TO_ADDRESS = "cedric";

    /**
     * This is the default constructor
     */
    public ApplicationMonitor() {
        this(DEFAULT_LOGGING_SYSTEM);
    }

    public ApplicationMonitor(String loggingSystem) {
        this(loggingSystem, DEFAULT_SMTP_SERVER, DEFAULT_FROM_ADDRESS,
                DEFAULT_TO_ADDRESS);
    }

    public ApplicationMonitor(String loggingSystem, String smtpServer,
            String from, String to) {
        super();
        this.loggingSystem = loggingSystem;
        this.smtpServer = smtpServer;
        this.from = from;
        this.to = to;
        initialize();
    }

    public void resetConsoleContent() {
        getAllStreamsTextArea().setText(null);
        getOutputStreamTextArea().setText(null);
        getErrorStreamTextArea().setText(null);
        getLogStreamTextArea().setText(null);
        getStatusBar().clearStatus();
    }

    public void sendConsoleContentByMail() {
        try {
            send(smtpServer, to, from, _("nuitonwidgets.monitor.mail.subject"),
                    _("nuitonwidgets.monitor.mail.stream.all") + "\n"
                            + getAllStreamsTextArea().getText() + "\n\n\n"
                            + _("nuitonwidgets.monitor.mail.stream.output")
                            + "\n" + getOutputStreamTextArea().getText()
                            + "\n\n\n"
                            + _("nuitonwidgets.monitor.mail.stream.error") + "\n"
                            + getErrorStreamTextArea().getText() + "\n\n\n"
                            + _("nuitonwidgets.monitor.mail.stream.log") + " "
                            + loggingSystem + " :\n"
                            + getLogStreamTextArea().getText());
            getStatusBar().setStatus(_("nuitonwidgets.monitor.mail.report", to));
        } catch (MessagingException eee) {
            getStatusBar().setStatus(
                    _("nuitonwidgets.monitor.mail.failed", smtpServer));
        }
    }

    protected String loggingSystem;

    protected String smtpServer;

    protected String to;

    protected String from;

    protected PrintStream stdout = null;

    protected PrintStream stderr = null;

    protected LogListener logListener = null;

    /**
     * @param smtpServer the smtpServer to set
     */
    public void setSmtpServer(String smtpServer) {
        this.smtpServer = smtpServer;
    }

    /**
     * @param to the to to set
     */
    public void setEmailTo(String to) {
        this.to = to;
    }

    /**
     * @param from the from to set
     */
    public void setEmailFrom(String from) {
        this.from = from;
    }

    protected void initialize() {
        initializeUI();
        initializeRedirect();
        initializeLoggingHandler();
    }

    /**
     * Sets new OutputStreams for System.out and System.err
     */
    protected void initializeRedirect() {
        stdout = System.out;
        stderr = System.err;

        System.setOut(new JTextAreaOutputStream(getAllStreamsTextArea(),
                new JTextAreaOutputStream(getOutputStreamTextArea(), stdout,
                        true), true));
        System.setErr(new JTextAreaOutputStream(getAllStreamsTextArea(),
                new JTextAreaOutputStream(getErrorStreamTextArea(), stderr,
                        true), true));
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#finalize()
     */
    @Override
    protected void finalize() throws Throwable {
        super.finalize();
        System.setOut(stdout);
        System.setErr(stderr);
    }

    /**
     * Set a logging handler up
     */
    protected void initializeLoggingHandler() {
        LogFactory factory = LogFactory.getFactory();
        if (factory instanceof LutinLogFactory) {
            logListener = new LogListener();
            ((LutinLogFactory) factory).addLutinLogListener(logListener);
        } else {
            // use java logging
            Logger.getLogger(loggingSystem).addHandler(new LoggingHandler());
        }
    }

    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();

    /**
     * Send an email using the given informations (stmpServer, toAddress,
     * fromAddress, subject and body).
     * 
     * @param smtpServer
     * @param to
     * @param from
     * @param subject
     * @param body 
     * @throws MessagingException
     * @throws AddressException
     */
    protected void send(String smtpServer, String to, String from,
            String subject, String body) throws AddressException,
            MessagingException {

        try {

            // Zippage du body pour le mettre en piece jointe
            ZipOutputStream zipOutputStream = new ZipOutputStream(
                    byteArrayOutputStream);
            BufferedWriter zipWriter = new BufferedWriter(
                    new OutputStreamWriter(zipOutputStream));
            zipOutputStream.putNextEntry(new ZipEntry("report.txt"));
            zipWriter.write(body);
            zipWriter.flush();
            zipOutputStream.closeEntry();
            zipWriter.close();

            Properties props = System.getProperties();

            // -- Attaching to default Session, or we could start a new one --
            props.put("mail.smtp.host", smtpServer);
            Session session = Session.getDefaultInstance(props, null);

            // -- Create a new message --
            Message msg = new MimeMessage(session);

            // -- Set the FROM and TO fields --
            msg.setFrom(new InternetAddress(from));
            msg.setRecipients(Message.RecipientType.TO, InternetAddress.parse(
                    to, false));

            // -- Set the subject and body text --
            msg.setSubject(subject);

            MimeMultipart bodyMime = new MimeMultipart("mixed");
            BodyPart attPart = new MimeBodyPart();
            attPart.setDataHandler(new DataHandler(new DataSource() {

                @Override
                public String getContentType() {
                    return "application/zip";
                }

                @Override
                public InputStream getInputStream() throws IOException {
                    return new ByteArrayInputStream(byteArrayOutputStream
                            .toByteArray());
                }

                @Override
                public String getName() {
                    return "report.zip";
                }

                @Override
                public OutputStream getOutputStream() throws IOException {
                    // TODO Auto-generated method stub
                    return null;
                }

            }));
            attPart.setDisposition(Part.ATTACHMENT);
            bodyMime.addBodyPart(attPart);

            msg.setContent(bodyMime);

            // -- Set some other header information --
            msg.setHeader("X-Mailer", "Code Lutin Java Mailer");
            msg.setSentDate(new Date());

            // -- Send the message --
            Transport.send(msg);

        } catch (AddressException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        } catch (MessagingException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        } catch (FileNotFoundException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        } catch (IOException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }

    }

    // UI Part

    protected JPanel jPanel = null;

    protected JPanel jPanel1 = null;

    protected JButton resetButton = null;

    protected JButton sendByEmailButton = null;

    protected JTabbedPane jTabbedPane = null;

    protected JPanel jPanel2 = null;

    protected JPanel jPanel2bis = null;

    protected JPanel jPanel3 = null;

    protected JScrollPane jScrollPane = null;

    protected JScrollPane jScrollPanebis = null;

    protected JTextArea outputStreamTextArea = null;

    protected JTextArea allStreamsTextArea = null;

    protected JScrollPane jScrollPane1 = null;

    protected JTextArea errorStreamTextArea = null;

    protected StatusBar statusBar = null;

    protected JPanel jPanel4 = null;

    protected JScrollPane jScrollPane2 = null;

    protected JTextArea logStreamTextArea = null;

    protected JPanel jPanel5 = null;

    protected JPanel jPanel6 = null;

    /**
     * This method initializes UI
     */
    protected void initializeUI() {
        java.awt.GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
        java.awt.GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        java.awt.GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        this.setLayout(new GridBagLayout());
        this
                .setBorder(javax.swing.BorderFactory
                        .createTitledBorder(
                                javax.swing.BorderFactory
                                        .createEtchedBorder(javax.swing.border.EtchedBorder.RAISED),
                                _("nuitonwidgets.monitor.title"),
                                javax.swing.border.TitledBorder.DEFAULT_JUSTIFICATION,
                                javax.swing.border.TitledBorder.DEFAULT_POSITION,
                                new java.awt.Font("Dialog", java.awt.Font.BOLD,
                                        12), java.awt.Color.black));
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 0;
        gridBagConstraints1.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints1.weightx = 1.0D;
        gridBagConstraints1.weighty = 7.0D;
        gridBagConstraints1.insets = new java.awt.Insets(5, 5, 5, 5);
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 1;
        gridBagConstraints2.insets = new java.awt.Insets(5, 5, 5, 5);
        gridBagConstraints2.weightx = 1.0D;
        gridBagConstraints2.weighty = 1.0D;
        gridBagConstraints2.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints11.gridx = 0;
        gridBagConstraints11.gridy = 2;
        gridBagConstraints11.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints11.weightx = 1.0D;
        gridBagConstraints11.insets = new java.awt.Insets(2, 2, 2, 2);
        this.add(getJPanel(), gridBagConstraints1);
        this.add(getJPanel1(), gridBagConstraints2);
        this.add(getStatusBar(), gridBagConstraints11);
    }

    /**
     * This method initializes jPanel
     * 
     * @return javax.swing.JPanel
     */
    protected JPanel getJPanel() {
        if (jPanel == null) {
            java.awt.GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
            jPanel = new JPanel();
            jPanel.setLayout(new GridBagLayout());
            gridBagConstraints7.gridx = 0;
            gridBagConstraints7.gridy = 0;
            gridBagConstraints7.weightx = 1.0;
            gridBagConstraints7.weighty = 1.0;
            gridBagConstraints7.fill = java.awt.GridBagConstraints.BOTH;
            jPanel.add(getJTabbedPane(), gridBagConstraints7);
        }
        return jPanel;
    }

    /**
     * This method initializes jPanel1
     * 
     * @return javax.swing.JPanel
     */
    protected JPanel getJPanel1() {
        if (jPanel1 == null) {
            java.awt.GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            java.awt.GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            jPanel1 = new JPanel();
            jPanel1.setLayout(new GridBagLayout());
            gridBagConstraints4.gridx = 0;
            gridBagConstraints4.gridy = 0;
            gridBagConstraints4.insets = new java.awt.Insets(5, 15, 5, 15);
            gridBagConstraints5.gridx = 1;
            gridBagConstraints5.gridy = 0;
            gridBagConstraints5.insets = new java.awt.Insets(5, 15, 5, 15);
            jPanel1.add(getResetButton(), gridBagConstraints4);
            jPanel1.add(getSendByEmailButton(), gridBagConstraints5);
        }
        return jPanel1;
    }

    /**
     * This method initializes jButton
     * 
     * @return javax.swing.JButton
     */
    protected JButton getResetButton() {
        if (resetButton == null) {
            resetButton = new JButton();
            resetButton.setText(_("nuitonwidgets.monitor.button.reset"));
            resetButton.setIcon(IconFactory.getIcon(IconFactory.RESET));
            resetButton.addActionListener(new java.awt.event.ActionListener() {
                @Override
                public void actionPerformed(java.awt.event.ActionEvent e) {
                    resetConsoleContent();
                }
            });
        }
        return resetButton;
    }

    /**
     * This method initializes jButton1
     * 
     * @return javax.swing.JButton
     */
    protected JButton getSendByEmailButton() {
        if (sendByEmailButton == null) {
            sendByEmailButton = new JButton();
            sendByEmailButton.setText(_("nuitonwidgets.monitor.button.mail"));
            sendByEmailButton.setIcon(IconFactory.getIcon(IconFactory.MAIL));
            sendByEmailButton.addActionListener(new java.awt.event.ActionListener() {
                    @Override
                        public void actionPerformed(java.awt.event.ActionEvent e) {
                            sendConsoleContentByMail();
                        }
                    });
        }
        return sendByEmailButton;
    }

    /**
     * This method initializes jTabbedPane
     * 
     * @return javax.swing.JTabbedPane
     */
    protected JTabbedPane getJTabbedPane() {
        if (jTabbedPane == null) {
            jTabbedPane = new JTabbedPane();
            jTabbedPane.addTab(_("nuitonwidgets.monitor.stream.all"), null,
                    getJPanel2bis(), null);
            jTabbedPane.addTab(_("nuitonwidgets.monitor.stream.output"), null,
                    getJPanel2(), null);
            jTabbedPane.addTab(_("nuitonwidgets.monitor.stream.error"), null,
                    getJPanel3(), null);
            jTabbedPane.addTab(_("nuitonwidgets.monitor.stream.log"), null,
                    getJPanel4(), null);
            jTabbedPane.addTab(_("nuitonwidgets.monitor.information.system"),
                    null, getJPanel5(), null);
            jTabbedPane.addTab(
                    _("nuitonwidgets.monitor.information.application"), null,
                    getJPanel6(), null);
        }
        return jTabbedPane;
    }

    /**
     * This method initializes jPanel2bis
     * 
     * @return javax.swing.JPanel
     */
    protected JPanel getJPanel2bis() {
        if (jPanel2bis == null) {
            java.awt.GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
            jPanel2bis = new JPanel();
            jPanel2bis.setLayout(new GridBagLayout());
            gridBagConstraints8.gridx = 0;
            gridBagConstraints8.gridy = 0;
            gridBagConstraints8.weightx = 1.0;
            gridBagConstraints8.weighty = 1.0;
            gridBagConstraints8.fill = java.awt.GridBagConstraints.BOTH;
            jPanel2bis.add(getJScrollPanebis(), gridBagConstraints8);
        }
        return jPanel2bis;
    }

    /**
     * This method initializes jPanel2
     * 
     * @return javax.swing.JPanel
     */
    protected JPanel getJPanel2() {
        if (jPanel2 == null) {
            java.awt.GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
            jPanel2 = new JPanel();
            jPanel2.setLayout(new GridBagLayout());
            gridBagConstraints8.gridx = 0;
            gridBagConstraints8.gridy = 0;
            gridBagConstraints8.weightx = 1.0;
            gridBagConstraints8.weighty = 1.0;
            gridBagConstraints8.fill = java.awt.GridBagConstraints.BOTH;
            jPanel2.add(getJScrollPane(), gridBagConstraints8);
        }
        return jPanel2;
    }

    /**
     * This method initializes jPanel3
     * 
     * @return javax.swing.JPanel
     */
    protected JPanel getJPanel3() {
        if (jPanel3 == null) {
            java.awt.GridBagConstraints gridBagConstraints9 = new GridBagConstraints();
            jPanel3 = new JPanel();
            jPanel3.setLayout(new GridBagLayout());
            gridBagConstraints9.gridx = 0;
            gridBagConstraints9.gridy = 0;
            gridBagConstraints9.weightx = 1.0;
            gridBagConstraints9.weighty = 1.0;
            gridBagConstraints9.fill = java.awt.GridBagConstraints.BOTH;
            jPanel3.add(getJScrollPane1(), gridBagConstraints9);
        }
        return jPanel3;
    }

    /**
     * This method initializes jScrollPanebis
     * 
     * @return javax.swing.JScrollPane
     */
    protected JScrollPane getJScrollPanebis() {
        if (jScrollPanebis == null) {
            jScrollPanebis = new JScrollPane();
            jScrollPanebis.setViewportView(getAllStreamsTextArea());
        }
        return jScrollPanebis;
    }

    /**
     * This method initializes jScrollPane
     * 
     * @return javax.swing.JScrollPane
     */
    protected JScrollPane getJScrollPane() {
        if (jScrollPane == null) {
            jScrollPane = new JScrollPane();
            jScrollPane.setViewportView(getOutputStreamTextArea());
        }
        return jScrollPane;
    }

    /**
     * This method initializes allStreamsTextArea
     * 
     * @return javax.swing.JTextArea
     */
    protected JTextArea getAllStreamsTextArea() {
        if (allStreamsTextArea == null) {
            allStreamsTextArea = new JTextArea();
        }
        return allStreamsTextArea;
    }

    /**
     * This method initializes jTextArea
     * 
     * @return javax.swing.JTextArea
     */
    protected JTextArea getOutputStreamTextArea() {
        if (outputStreamTextArea == null) {
            outputStreamTextArea = new JTextArea();
        }
        return outputStreamTextArea;
    }

    /**
     * This method initializes jScrollPane1
     * 
     * @return javax.swing.JScrollPane
     */
    protected JScrollPane getJScrollPane1() {
        if (jScrollPane1 == null) {
            jScrollPane1 = new JScrollPane();
            jScrollPane1.setViewportView(getErrorStreamTextArea());
        }
        return jScrollPane1;
    }

    /**
     * This method initializes jTextArea1
     * 
     * @return javax.swing.JTextArea
     */
    protected JTextArea getErrorStreamTextArea() {
        if (errorStreamTextArea == null) {
            errorStreamTextArea = new JTextArea();
        }
        return errorStreamTextArea;
    }

    /**
     * This method initializes jPanel4
     * 
     * @return javax.swing.JPanel
     */
    protected JPanel getJPanel4() {
        if (jPanel4 == null) {
            java.awt.GridBagConstraints gridBagConstraints12 = new GridBagConstraints();
            jPanel4 = new JPanel();
            jPanel4.setLayout(new GridBagLayout());
            gridBagConstraints12.gridx = 0;
            gridBagConstraints12.gridy = 0;
            gridBagConstraints12.weightx = 1.0;
            gridBagConstraints12.weighty = 1.0;
            gridBagConstraints12.fill = java.awt.GridBagConstraints.BOTH;
            jPanel4.add(getJScrollPane2(), gridBagConstraints12);
        }
        return jPanel4;
    }

    /**
     * This method initializes jScrollPane2
     * 
     * @return javax.swing.JScrollPane
     */
    protected JScrollPane getJScrollPane2() {
        if (jScrollPane2 == null) {
            jScrollPane2 = new JScrollPane();
            jScrollPane2.setViewportView(getLogStreamTextArea());
        }
        return jScrollPane2;
    }

    /**
     * This method initializes jTextArea
     * 
     * @return javax.swing.JTextArea
     */
    protected JTextArea getLogStreamTextArea() {
        if (logStreamTextArea == null) {
            logStreamTextArea = new JTextArea();
        }
        return logStreamTextArea;
    }

    /**
     * This method initializes jPanel5
     * 
     * @return javax.swing.JPanel
     */
    protected JPanel getJPanel5() {
        if (jPanel5 == null) {
            jPanel5 = new JPanel();
        }
        return jPanel5;
    }

    /**
     * This method initializes jPanel6
     * 
     * @return javax.swing.JPanel
     */
    protected JPanel getJPanel6() {
        if (jPanel6 == null) {
            jPanel6 = new JPanel();
        }
        return jPanel6;
    }

    protected StatusBar getStatusBar() {
        if (statusBar == null) {
            statusBar = new StatusBar();
        }
        return statusBar;
    }

    /** ensure that the textarea does'nt have more than necessary line
     * @param target 
     */
    protected void ensureLine(JTextArea target) {
        int lineCount = target.getLineCount();
        if (DEFAULT_HEADER_LINE != -1 && DEFAULT_FOOTER_LINE != -1
                && lineCount > DEFAULT_HEADER_LINE + DEFAULT_FOOTER_LINE * 2) {
            // on supprime les lignes en trop le *2 est la pour pas le faire
            // trop souvent car cela peut-etre couteux
            try {
                int truncatedStart = target
                        .getLineEndOffset(DEFAULT_HEADER_LINE);
                int truncatedEnd = target.getLineStartOffset(lineCount
                        - DEFAULT_FOOTER_LINE);
                target.replaceRange("[...]\n", truncatedStart, truncatedEnd);
            } catch (Exception eee) {
                // on ne fait rien c juste le log qui n'est pas tronque
            }
        }
    }

    /**
     * A PrintStream for the text area output.
     * 
     * @author Sven Luzar
     */
    class JTextAreaOutputStream extends PrintStream {
        /**
         * the target for this printstream
         */
        protected JTextArea target = null;

        /**
         * the original PrintStream to forward this stream to the original
         * stream
         */
        protected PrintStream orig = null;

        /**
         * Flag is true if the stream should forward the output to the original
         * stream
         * 
         */
        protected boolean showOrig = false;

        /**
         * creates an instance
         * 
         */
        public JTextAreaOutputStream(JTextArea t, PrintStream orig,
                boolean showOrig) {
            super(new ByteArrayOutputStream());
            target = t;

            this.showOrig = showOrig;
            this.orig = orig;
        }

        /**
         * writes a boolean value to the target
         */
        @Override
        public void print(boolean b) {
            if (showOrig) {
                orig.print(b);
            }
            if (b) {
                target.append("true");
            }
            else {
                target.append("false");
            }
            ensureLine(target);
            target.setCaretPosition(target.getText().length());
        }

        /**
         * writes a boolean value to the target
         * 
         */
        @Override
        public void println(boolean b) {
            if (showOrig) {
                orig.println(b);
            }

            if (b) {
                target.append("true\n");
            }
            else {
                target.append("false\n");
            }
            ensureLine(target);
            target.setCaretPosition(target.getText().length());
        }

        /**
         * writes the value to the target
         * 
         */
        @Override
        public void print(char c) {
            if (showOrig) {
                orig.print(c);
            }

            char[] tmp = new char[1];
            tmp[0] = c;
            target.append(new String(tmp));
            ensureLine(target);
            target.setCaretPosition(target.getText().length());
        }

        /**
         * writes the value to the target
         * 
         */
        @Override
        public void println(char c) {
            if (showOrig) {
                orig.println(c);
            }

            char[] tmp = new char[2];
            tmp[0] = c;
            tmp[1] = '\n';
            target.append(new String(tmp));
            ensureLine(target);
            target.setCaretPosition(target.getText().length());
        }

        /**
         * writes the value to the target
         * 
         */
        @Override
        public void print(char[] s) {
            if (showOrig) {
                orig.print(s);
            }

            target.append(new String(s));
            ensureLine(target);
            target.setCaretPosition(target.getText().length());
        }

        /**
         * writes the value to the target
         * 
         */
        @Override
        public void println(char[] s) {
            if (showOrig) {
                orig.println(s);
            }

            target.append(new String(s) + "\n"/* #Frozen */);
            ensureLine(target);
            target.setCaretPosition(target.getText().length());
        }

        /**
         * writes the value to the target
         * 
         */
        @Override
        public void print(double d) {
            if (showOrig) {
                orig.print(d);
            }

            target.append(Double.toString(d));
            ensureLine(target);
            target.setCaretPosition(target.getText().length());
        }

        /**
         * writes the value to the target
         * 
         */
        @Override
        public void println(double d) {
            if (showOrig) {
                orig.println(d);
            }

            target.append(Double.toString(d) + "\n"/* #Frozen */);
            ensureLine(target);
            target.setCaretPosition(target.getText().length());
        }

        /**
         * writes the value to the target
         * 
         */
        @Override
        public void print(float f) {
            if (showOrig) {
                orig.print(f);
            }

            target.append(Float.toString(f));
            ensureLine(target);
            target.setCaretPosition(target.getText().length());
        }

        /**
         * writes the value to the target
         * 
         */
        @Override
        public void println(float f) {
            if (showOrig) {
                orig.println(f);
            }

            target.append(Float.toString(f) + "\n"/* #Frozen */);
            ensureLine(target);
            target.setCaretPosition(target.getText().length());
        }

        /**
         * writes the value to the target
         * 
         */
        @Override
        public void print(int i) {
            if (showOrig) {
                orig.print(i);
            }

            target.append(Integer.toString(i));
            ensureLine(target);
            target.setCaretPosition(target.getText().length());
        }

        /**
         * writes the value to the target
         * 
         */
        @Override
        public void println(int i) {
            if (showOrig) {
                orig.println(i);
            }

            target.append(Integer.toString(i) + "\n"/* #Frozen */);
            ensureLine(target);
            target.setCaretPosition(target.getText().length());
        }

        /**
         * writes the value to the target
         * 
         */
        @Override
        public void print(long l) {
            if (showOrig) {
                orig.print(l);
            }

            target.append(Long.toString(l));
            ensureLine(target);
            target.setCaretPosition(target.getText().length());
        }

        /**
         * writes the value to the target
         * 
         */
        @Override
        public void println(long l) {
            if (showOrig) {
                orig.println(l);
            }

            target.append(Long.toString(l) + "\n"/* #Frozen */);
            ensureLine(target);
            target.setCaretPosition(target.getText().length());
        }

        /**
         * writes the value to the target
         * 
         */
        @Override
        public void print(Object o) {
            if (showOrig) {
                orig.print(o);
            }

            target.append(o.toString());
            ensureLine(target);
            target.setCaretPosition(target.getText().length());
        }

        /**
         * writes the value to the target
         * 
         */
        @Override
        public void println(Object o) {
            if (showOrig) {
                orig.println(o);
            }

            target.append(o.toString() + "\n"/* #Frozen */);
            ensureLine(target);
            target.setCaretPosition(target.getText().length());
        }

        /**
         * writes the value to the target
         * 
         */
        @Override
        public void print(String s) {
            if (showOrig) {
                orig.print(s);
            }

            target.append(s);
            ensureLine(target);
            target.setCaretPosition(target.getText().length());
        }

        /**
         * writes the value to the target
         * 
         */
        @Override
        public void println(String s) {
            if (showOrig) {
                orig.println(s);
            }

            target.append(s + "\n"/* #Frozen */);
            ensureLine(target);
            target.setCaretPosition(target.getText().length());
        }

        /**
         * writes the value to the target
         * 
         */
        @Override
        public void println() {
            if (showOrig) {
                orig.println();
            }

            target.append(new String("\n"/* #Frozen */));
            ensureLine(target);
            target.setCaretPosition(target.getText().length());
        }

    }

    class LoggingHandler extends Handler {

        @Override
        public void close() throws SecurityException {
        }

        @Override
        public void flush() {
        }

        /**
         * LogRecords handler
         */
        @Override
        public void publish(LogRecord log) {
            StringBuffer trace = new StringBuffer();
            trace.append(DateFormat.getDateTimeInstance().format(
                    new Date(log.getMillis()))
                    + " - ");
            trace.append(log.getLevel() + " - ");
            trace.append(log.getMessage() + "\n");
            if (log.getThrown() != null) {
                trace.append(log.getThrown().getMessage() + "\n");
                StringWriter stack = new StringWriter();
                PrintWriter print = new PrintWriter(stack);
                log.getThrown().printStackTrace(print);
                print.close();
                trace.append(stack.getBuffer().toString());
            }
            getAllStreamsTextArea().append(trace.toString());
            ensureLine(getAllStreamsTextArea());
            getLogStreamTextArea().append(trace.toString());
            ensureLine(getLogStreamTextArea());
        }

    }

    protected class LogListener implements LutinLogListener {

        @Override
        public void logEvent(LutinLogEvent e) {
            StringBuffer trace = new StringBuffer();
            trace.append(DateFormat.getDateTimeInstance().format(
                    new Date(e.getTime()))
                    + " - ");
            trace.append(e.getLogType() + " - ");
            trace.append(e.getMsg() + "\n");
            if (e.getThrowable() != null) {
                trace.append(e.getThrowable().getMessage() + "\n");
                StringWriter stack = new StringWriter();
                PrintWriter print = new PrintWriter(stack);
                e.getThrowable().printStackTrace(print);
                print.close();
                trace.append(stack.getBuffer().toString());
            }
            getAllStreamsTextArea().append(trace.toString());
            ensureLine(getAllStreamsTextArea());
            getLogStreamTextArea().append(trace.toString());
            ensureLine(getLogStreamTextArea());
        }

        @Override
        public void progressEvent(LutinProgressEvent e) {
            // do nothing
        }

    }

    //

    public static void main(String[] args) {
        System.setProperty("org.apache.commons.logging.LogFactory",
                LutinLogFactory.class.getName());
        I18n.init("fr", "FR");
        // I18n.init("en", "EN");

        JFrame frame = new JFrame();
        ApplicationMonitor am = new ApplicationMonitor();
        frame.setSize(800, 500);
        frame.getContentPane().add(am);
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);

        System.out.println("Standard output test");
        System.err.println("Standard error test");

        Logger.getLogger(DEFAULT_LOGGING_SYSTEM).log(Level.INFO,
                "Infomation level logging");
        Logger.getLogger("TODO").log(Level.INFO, "Infomation level logging");

        Log log = LogFactory.getLog(ApplicationMonitor.class);
        System.out.println("Log type: " + log.getClass());
        log.info("Infomation level logging");
        log.info("Infomation level logging");

        LutinLog ll = LutinLogFactory.getLutinLog("Une caté");
        ll.user("coucou user");

        frame.setVisible(true);
    }

}
