/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.validator.bean;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.validator.NuitonValidatorFactory;
import org.nuiton.validator.NuitonValidatorProvider;
import org.nuiton.validator.NuitonValidatorScope;
import org.nuiton.validator.bean.BeanValidator;

public class BeanValidatorFactory {
    private static final Log log = LogFactory.getLog(BeanValidatorFactory.class);
    protected static BeanValidatorCreator creator;

    public static BeanValidatorCreator getCreator() {
        if (creator == null) {
            creator = new DefaultBeanValidatorCreator();
            if (log.isInfoEnabled()) {
                log.info((Object)("Will use default beanValidator creator : " + creator));
            }
        }
        return creator;
    }

    public static void setCreator(BeanValidatorCreator creator) {
        BeanValidatorFactory.creator = creator;
        if (log.isInfoEnabled()) {
            log.info((Object)("Will use injected beanValidator creator : " + creator));
        }
    }

    public static boolean isDefaultCreator() {
        return creator == null || creator.getClass().equals(DefaultBeanValidatorCreator.class);
    }

    public static <O> BeanValidator<O> newBeanValidator(Class<O> type, String context, NuitonValidatorScope ... scopes) throws NullPointerException {
        String providerName = NuitonValidatorFactory.getDefaultProviderName();
        BeanValidator<O> beanValidator = BeanValidatorFactory.newBeanValidator(providerName, type, context, scopes);
        return beanValidator;
    }

    public static <O> BeanValidator<O> newBeanValidator(String providerName, Class<O> type, String context, NuitonValidatorScope ... scopes) throws NullPointerException {
        if (type == null) {
            throw new NullPointerException("type parameter can not be null.");
        }
        NuitonValidatorProvider provider = NuitonValidatorFactory.getProvider(providerName);
        BeanValidatorCreator creator = BeanValidatorFactory.getCreator();
        BeanValidator<O> beanValidator = creator.newBeanValidator(provider, type, context, scopes);
        return beanValidator;
    }

    public static class DefaultBeanValidatorCreator
    implements BeanValidatorCreator {
        @Override
        public <O> BeanValidator<O> newBeanValidator(NuitonValidatorProvider provider, Class<O> type, String context, NuitonValidatorScope ... scopes) {
            BeanValidator<O> beanValidator = new BeanValidator<O>(provider, type, context, scopes);
            return beanValidator;
        }
    }

    public static interface BeanValidatorCreator {
        public <O> BeanValidator<O> newBeanValidator(NuitonValidatorProvider var1, Class<O> var2, String var3, NuitonValidatorScope ... var4);
    }
}

