package org.nuiton.math.matrix.gui;

import org.nuiton.math.matrix.gui.*;
import java.awt.*;
import java.awt.event.*;
import java.beans.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.swing.JAXXButtonGroup;
import jaxx.runtime.swing.HBox;
import jaxx.runtime.swing.VBox;
import jaxx.runtime.swing.Table;
import static org.nuiton.i18n.I18n._;
import static jaxx.runtime.Util.createImageIcon;
import jaxx.runtime.SwingUtil;
import static jaxx.runtime.Util.getStringValue;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import org.nuiton.i18n.I18n;
import org.nuiton.math.matrix.MatrixFactory;
import org.nuiton.math.matrix.MatrixND;
import org.nuiton.util.ListenerSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JAXXMatrixEditor extends org.nuiton.math.matrix.gui.MatrixEditor implements jaxx.runtime.JAXXObject {
    public static final Log log = LogFactory.getLog(org.nuiton.math.matrix.gui.JAXXMatrixEditor.class);
    private static java.lang.String $jaxxObjectDescriptor = "H4sIAAAAAAAAAK1UPW9TMRR1QpO2CekXpTBQ0UK3Si9QhJBoVegHFa0SQA1DRRacPJO4cmxj+7WvDAiJFaFODCzAzsiOECMTK/8BIf4B134veWkJtBJkcKJ7zz0+9/qevP+OMlqh6W0chp4KuKEt4m0sbW3drW2Tulkluq6oNEKh6JNKo3QV5f1OXBt0sVqy5cW4vLgiWlJwwruq50sop80eI7pJiDHodFRR17pY6YTnQxmoNltHTC+2tz9/pPf9Z+/SCIUSVOWhhamjqpIO+kooTX2DxuCmHVxkmDdAhqK8AToLNrbCsNZ3cIs8Rk9RfwllJVZAZtCF47fqOFx9KA0atnVlDLfAyQkzaFaohscDagT3Wtg07QFZrxFQ9wIR+JYPACWlY8oalDO4xkhZ+EdRROX3O+iEIs8oJ1jFHKO2X8/OwFsWghHME+REF7LSFLur5BEOmLHZ0QRV8GEUXFPBrdhDyVMzFTeYdU4NxYw+IeqSQefdY9VhepQR5f0G+Wv9ZZs6+1fI3CHIAAFlS4pgg87YfkNP78JzextQKRi7By9ikYOdgowbM6zIAbSbpkVMJu9RC4yJOgclB9DLLhPzKpu0PWvtJSuf7GSqijIqgLBBI9XEHZsQinwRRx2Bi755/nrn1YeP19smyMIdhQOQLs/CUkolJFGG2iuGo80PDGXFMpbzVTSoCQPDO0OPdwmoxGEQAfzRstgy7zbWTSjN9H/79Hni4dcTKL2Gckxgfw1b/DoaNE0FXQrmh/LGTafk5O4AnCNWk0FZhvcEjAgNLfjY4Kka5T7MbTGEZse7mu0o+LL/onzu5eS1dsOpSNAhWNJ05gHKUm5X2Pk9tnJPf+elJoEvEsv2MnHKfudkvFWz7iz26mwIB0ZsEg2baK1jcXNhYL+uONn211XHNn0MtvE6YSzqzlqM2x30/5GzoNt8/0FgnyEhPOPYQjTsKWzgnwdsQRZ7c84cg7N/h2oam+0P0izNL/yVEdK/BgAA";
    protected java.util.List<Object> $activeBindings = new ArrayList<Object>();
    protected java.util.Map<String,Object> $bindingSources = new HashMap<String,Object>();
    protected Map<String,Object> $objectMap = new HashMap<String,Object>();
    protected javax.swing.JButton buttonEdit;
    protected final jaxx.runtime.JAXXContext delegateContext = new jaxx.runtime.DefaultJAXXContext(this);;
    protected java.lang.Boolean dimensionEdit;
    protected javax.swing.JScrollPane editArea;
    protected org.nuiton.math.matrix.gui.JAXXMatrixEditor jaxxMatrixManel = this;
    protected java.lang.Boolean linearModel;
    protected java.lang.Boolean linearModelShowDefault;
    protected javax.swing.JTable table;
    protected org.nuiton.math.matrix.gui.MatrixTableModel tableModel;
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    java.util.Map $previousValues = new java.util.HashMap();
    private java.beans.PropertyChangeListener $DataSource7 = new jaxx.runtime.DataBindingListener(jaxxMatrixManel, "buttonEdit.visible");

    /* begin raw body code */
    private final static int DEFAULT_WIDTH = 150;
    private final static int DEFAULT_HEIGHT = 150;
    protected ListenerSet<MatrixPanelListener> listeners;
    protected MatrixPopupMenu popupMenu;
    protected MatrixND matrix;
    
    
    /**
     * @deprecated since 2.0.1 use MatrixPanelEditor
     */
    public  JAXXMatrixEditor(MatrixND m, boolean dimensionEdit) {
        this(dimensionEdit, DEFAULT_WIDTH, DEFAULT_HEIGHT);
    }
    
    /**
     * @deprecated since 2.0.1 use MatrixPanelEditor
     */
    public  JAXXMatrixEditor(boolean dimensionEdit, int width, int height) {
        this.dimensionEdit = dimensionEdit;
        setPreferredSize(new Dimension(width, height));
    $initialize();
    }
    
    /**
     * @deprecated since 2.0.1 use MatrixPanelEditor
     */
    public  JAXXMatrixEditor(boolean dimensionEdit) {
        this(dimensionEdit, DEFAULT_WIDTH, DEFAULT_HEIGHT);
    }
    
    public void setMatrix(MatrixND m){
        this.matrix = m;
        initObject();
    }
    
    public MatrixND getMatrix() {
        return matrix;
    }
    
    protected MatrixFactory getFactory() {
        return MatrixFactory.getInstance();
    }
    
    /**
     *
     * @param l listener to add
     * @deprecated  since 2.0.0 : this is not a valid listener adder
     */
    @Deprecated
    public void addMatrixListener(MatrixPanelListener l) {
        listeners.add(l);
    }
    
    public void addMatrixPanelListener(MatrixPanelListener l) {
        listeners.add(l);
    }
    
    public void removeMatrixPanelListener(MatrixPanelListener l) {
        listeners.remove(l);
    }
    
    
    public MatrixPanelListener[] getMatrixPanelListeners() {
        java.util.List<MatrixPanelListener> r = new java.util.ArrayList<MatrixPanelListener>();
        for (java.util.Iterator<MatrixPanelListener> itr = listeners.iterator(); itr.hasNext();) {
            r.add(itr.next());
        }
        return r.toArray(new MatrixPanelListener[r.size()]);
    }
    
    protected void initObject() {
        if (getMatrix() == null) {
            editArea.setViewportView(null);
        }
        else {
            jaxx.runtime.Util.assignment(popupMenu = new MatrixPopupMenu(this), "popupMenu", org.nuiton.math.matrix.gui.JAXXMatrixEditor.this);
            table = new JTable() {
                public void processMouseEvent(MouseEvent event) {
                    if (event.isPopupTrigger()) {
                        popupMenu.show(event.getComponent(), event.getX(), event.getY());
                    }
                    super.processMouseEvent(event);
                }
            };
    
            table.getInputMap().put(KeyStroke.getKeyStroke(KeyEvent.VK_C, Event.CTRL_MASK),"copy");
            table.getActionMap().put("copy",popupMenu.getSendToClipBoardSelectionCopyAction());
            table.getInputMap().put(KeyStroke.getKeyStroke(KeyEvent.VK_V, Event.CTRL_MASK),"paste");
            table.getActionMap().put("paste",popupMenu.getSendToClipBoardCurrentPasteAction());
            if (isLinearModel()) {
                setTableModel(new MatrixTableModelLinear(getMatrix(), isLinearModelShowDefault()));
            }
            else {
                setTableModel(new MatrixTableModelND(getMatrix()));
            }
    
            getTableModel().addTableModelListener(new TableModelListener() {
    
                @Override
                public void tableChanged(TableModelEvent e) {
                    fireEvent();
                }
            });
    
            table.setModel(getTableModel());
            table.setDefaultRenderer(String.class, tableModel.getMatrixCellRenderer());
            table.setAutoResizeMode(JTable.AUTO_RESIZE_OFF);
            table.setSelectionMode(ListSelectionModel.SINGLE_INTERVAL_SELECTION);
            editArea.setViewportView(table);
        }
        repaint();
    }
    
    protected void btnAction(){
        String dim;
        dim = JOptionPane.showInputDialog(null, I18n._("nuitonmatrix.create.matrix.message"), I18n._("nuitonmatrix.create.matrix.title"), JOptionPane.DEFAULT_OPTION);
    
        if (dim != null) {
            String[] sdim = dim.split(";");
            int[] idim = new int[sdim.length];
            for (int i = 0; i < idim.length; i++) {
                idim[i] = Integer.parseInt(sdim[i]);
            }
            setMatrix(getFactory().create(idim));
        }
    }
    
    protected void fireEvent() {
        MatrixPanelEvent e = new MatrixPanelEvent(this);
        for (Iterator i = listeners.iterator(); i.hasNext();) {
            MatrixPanelListener l = (MatrixPanelListener) i.next();
            l.matrixChanged(e);
        }
    }
    /* end raw body code */
    /*---------------------------------------------------------------------------------*/
    /*-- Statics methods --------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public static jaxx.runtime.JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return jaxx.runtime.Util.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*---------------------------------------------------------------------------------*/
    /*-- Constructors -----------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public JAXXMatrixEditor() {
        $initialize();
    }

    public JAXXMatrixEditor(jaxx.runtime.JAXXContext parentContext) {
        if (parentContext instanceof jaxx.runtime.JAXXInitialContext) {
            ((jaxx.runtime.JAXXInitialContext)parentContext).to(this);
        } else {
            setContextValue(parentContext);
        }
        $initialize();
    }

    /*---------------------------------------------------------------------------------*/
    /*-- JAXXObject implementation ----------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public void applyDataBinding(String $binding) {
        if ("buttonEdit.visible".equals($binding)) {
                addPropertyChangeListener("dimensionEdit", $DataSource7);
        
        }
        processDataBinding($binding);
    }

    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    public Map<String,Object> get$objectMap() {
        return $objectMap;
    }

    public java.lang.Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    public void processDataBinding(String dest) {
        processDataBinding(dest, false);
    }

    public void processDataBinding(String $dest, boolean $force) {
        if (!$force && $activeBindings.contains($dest)) { 
            return;
        }
        $activeBindings.add($dest);
        try {
            if ("buttonEdit.visible".equals($dest)) {
            buttonEdit.setVisible((isDimensionEdit()));
            }} finally {
            $activeBindings.remove($dest);
        }
    }

    public void removeDataBinding(String $binding) {
        if ("buttonEdit.visible".equals($binding)) {
                removePropertyChangeListener("dimensionEdit", $DataSource7);
        
        }
    }

    /*---------------------------------------------------------------------------------*/
    /*-- JAXXContext implementation ---------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    public jaxx.runtime.JAXXContext getDelegateContext() {
        return delegateContext;
    }

    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return delegateContext.getParentContainer(clazz);
    }

    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return delegateContext.getParentContainer(source, clazz);
    }

    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*---------------------------------------------------------------------------------*/
    /*-- Event methods ----------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public void doActionPerformed__on__buttonEdit(java.awt.event.ActionEvent event) {
        btnAction();
    }

    /*---------------------------------------------------------------------------------*/
    /*-- public acessor methods -------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public java.util.List<Object> get$activeBindings() {
        return $activeBindings;
    }

    public java.util.Map<String,Object> get$bindingSources() {
        return $bindingSources;
    }

    public javax.swing.JButton getButtonEdit() {
        return buttonEdit;
    }

    public java.lang.Boolean getDimensionEdit() {
        return dimensionEdit;
    }

    public javax.swing.JScrollPane getEditArea() {
        return editArea;
    }

    public org.nuiton.math.matrix.gui.JAXXMatrixEditor getJaxxMatrixManel() {
        return jaxxMatrixManel;
    }

    public java.lang.Boolean getLinearModel() {
        return linearModel;
    }

    public java.lang.Boolean getLinearModelShowDefault() {
        return linearModelShowDefault;
    }

    public javax.swing.JTable getTable() {
        return table;
    }

    public org.nuiton.math.matrix.gui.MatrixTableModel getTableModel() {
        return tableModel;
    }

    public java.lang.Boolean isDimensionEdit() {
        return dimensionEdit !=null && dimensionEdit;
    }

    public java.lang.Boolean isLinearModel() {
        return linearModel !=null && linearModel;
    }

    public java.lang.Boolean isLinearModelShowDefault() {
        return linearModelShowDefault !=null && linearModelShowDefault;
    }

    /*---------------------------------------------------------------------------------*/
    /*-- public mutator methods -------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public void setDimensionEdit(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.dimensionEdit;
        this.dimensionEdit = newValue;
        firePropertyChange("dimensionEdit", oldValue, newValue);
    }

    public void setLinearModel(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.linearModel;
        this.linearModel = newValue;
        firePropertyChange("linearModel", oldValue, newValue);
    }

    public void setLinearModelShowDefault(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.linearModelShowDefault;
        this.linearModelShowDefault = newValue;
        firePropertyChange("linearModelShowDefault", oldValue, newValue);
    }

    public void setTableModel(org.nuiton.math.matrix.gui.MatrixTableModel newValue) {
        org.nuiton.math.matrix.gui.MatrixTableModel oldValue = this.tableModel;
        this.tableModel = newValue;
        firePropertyChange("tableModel", oldValue, newValue);
    }

    /*---------------------------------------------------------------------------------*/
    /*-- protected acessors methods ---------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    protected java.lang.String get$jaxxObjectDescriptor() {
        return $jaxxObjectDescriptor;
    }

    protected java.util.Map get$previousValues() {
        return $previousValues;
    }

    protected boolean getAllComponentsCreated() {
        return allComponentsCreated;
    }

    protected boolean getContextInitialized() {
        return contextInitialized;
    }

    protected Log getLog() {
        return log;
    }

    /*---------------------------------------------------------------------------------*/
    /*-- ui creation methods ----------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        addChildrenToJaxxMatrixManel();
        
        
        
        addChildrenToEditArea();
        table.setAutoResizeMode((JTable.AUTO_RESIZE_OFF));
        table.setCellSelectionEnabled((true));
        table.setSelectionMode((ListSelectionModel.SINGLE_INTERVAL_SELECTION));
        applyDataBinding("buttonEdit.visible");
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("jaxxMatrixManel", this);
        createTableModel();
        createLinearModel();
        createLinearModelShowDefault();
        createDimensionEdit();
        
        listeners = new ListenerSet<MatrixPanelListener>();
        
        popupMenu = null;
        
        matrix = null;
        
        createEditArea();
        createTable();
        createButtonEdit();
        jaxxMatrixManel.setName("jaxxMatrixManel");
        jaxxMatrixManel.setLayout((new BorderLayout()));
        
        
        initObject();
        $completeSetup();
    }

    protected void addChildrenToEditArea() {
        if (!allComponentsCreated) {
            return;
        }
        editArea.getViewport().add(table);
    }

    protected void addChildrenToJaxxMatrixManel() {
        if (!allComponentsCreated) {
            return;
        }
        jaxxMatrixManel.add(editArea, BorderLayout.CENTER);
        jaxxMatrixManel.add(buttonEdit, BorderLayout.SOUTH);
    }

    protected void createButtonEdit() {
        buttonEdit = new javax.swing.JButton();
        $objectMap.put("buttonEdit", buttonEdit);
        buttonEdit.setName("buttonEdit");
        buttonEdit.setText(_("nuitonmatrix.create.matrix.button"));
        buttonEdit.addActionListener((java.awt.event.ActionListener) jaxx.runtime.Util.getEventListener(java.awt.event.ActionListener.class, "actionPerformed", jaxxMatrixManel, "doActionPerformed__on__buttonEdit"));
    }

    protected void createDimensionEdit() {
        dimensionEdit = false;
        $objectMap.put("dimensionEdit", dimensionEdit);
    }

    protected void createEditArea() {
        editArea = new javax.swing.JScrollPane();
        $objectMap.put("editArea", editArea);
        editArea.setName("editArea");
    }

    protected void createLinearModel() {
        linearModel = false;
        $objectMap.put("linearModel", linearModel);
    }

    protected void createLinearModelShowDefault() {
        linearModelShowDefault = false;
        $objectMap.put("linearModelShowDefault", linearModelShowDefault);
    }

    protected void createTable() {
        table = new javax.swing.JTable();
        $objectMap.put("table", table);
        table.setName("table");
    }

    protected void createTableModel() {
        tableModel = null;
        $objectMap.put("tableModel", tableModel);
    }

}
