/* *##% NuitonMatrix
 * Copyright (C) 2004 - 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>. ##%*/

package org.nuiton.math.matrix;

/**
 * Vector.
 *
 * Created: 6 octobre 2005 02:51:12 CEST
 *
 * @author Benjamin POUSSIN <poussin@codelutin.com>
 * @version $Revision: 168 $
 *
 * Last update: $Date: 2009-07-17 18:18:45 +0200 (ven., 17 juil. 2009) $
 * by : $Author: echatellier $
 */
public interface Vector { // Vector

    public double getMaxOccurence();

    public double getValue(int pos);

    public void setValue(int pos, double value);

    public int size();

    /**
     * Permet de savoir si paste est implanté par ce vector.
     * 
     * @param v vector to test
     * @return <tt>true</tt> if operation is supported
     */
    public boolean isImplementedPaste(Vector v);

    /**
     * Permet de savoir si add est implanté par ce vector.
     * 
     * @param v vector to test
     * @return <tt>true</tt> if operation is supported
     */
    public boolean isImplementedAdd(Vector v);

    /**
     * Permet de savoir si minus est implanté par ce vector.
     * 
     * @param v vector to test
     * @return <tt>true</tt> if operation is supported
     */
    public boolean isImplementedMinus(Vector v);

    /**
     * Permet de savoir si map est implanté par ce vector.

     * @return <tt>true</tt> if operation is supported
     */
    public boolean isImplementedMap();

    /**
     * Copie les valeurs du vector passé en argument dans ce vector.
     * 
     * @param v vector to paste
     */
    public void paste(Vector v);

    /**
     * Ajoute les valeurs du vector passé en argument a ce vector.
     * 
     * @param v vector to add
     */
    public void add(Vector v);

    /**
     * Soustrait les valeurs du vector passé en argument a ce vector.
     * 
     * @param v vector to minus
     */
    public void minus(Vector v);

    /**
     * applique a chaque valeur du vector la {@link MapFunction}.
     * 
     * @param f funtion to apply
     */
    public void map(MapFunction f);

} // Vector

