/* *##% NuitonMatrix
 * Copyright (C) 2004 - 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>. ##%*/

package org.nuiton.math.matrix;

import java.util.Arrays;

/**
 * DoubleBigVector.
 *
 * Created: 6 octobre 2005 02:54:36 CEST
 *
 * @author Benjamin POUSSIN <poussin@codelutin.com>
 * @version $Revision: 187 $
 *
 * Last update: $Date: 2009-10-16 19:17:29 +0200 (ven., 16 oct. 2009) $
 * by : $Author: tchemit $
 */
public class DoubleBigVector implements Vector { // DoubleBigVector

    protected double data[] = null;

    public DoubleBigVector(int capacity) {
        data = new double[capacity];
    }

    @Override
    public int size() {
        return data.length;
    }

    @Override
    public double getMaxOccurence() {
        return MatrixHelper.maxOccurence(data);
    }

    @Override
    public double getValue(int pos) {
        return data[pos];
    }

    @Override
    public void setValue(int pos, double value) {
        data[pos] = value;
    }

    @Override
    public boolean equals(Object o) {
        boolean result = false;
        if (o instanceof DoubleBigVector) {
            DoubleBigVector other = (DoubleBigVector) o;
            result = Arrays.equals(this.data, other.data);
        } else if (o instanceof Vector) {
            Vector other = (Vector) o;
            result = true;
            for (int i = 0; i < size() && result; i++) {
                result = getValue(i) == other.getValue(i);
            }
        }
        return result;
    }

    @Override
    public boolean isImplementedPaste(Vector v) {
        return v instanceof DoubleBigVector;
    }

    @Override
    public boolean isImplementedAdd(Vector v) {
        return v instanceof DoubleBigVector;
    }

    @Override
    public boolean isImplementedMinus(Vector v) {
        return v instanceof DoubleBigVector;
    }

    @Override
    public boolean isImplementedMap() {
        return true;
    }

    @Override
    public void paste(Vector v) {
        DoubleBigVector fbv = (DoubleBigVector) v;
        System.arraycopy(fbv.data, 0, this.data, 0, this.size());
    }

    @Override
    public void add(Vector v) {
        DoubleBigVector fbv = (DoubleBigVector) v;
        for (int i = 0; i < data.length; i++) {
            data[i] += fbv.data[i];
        }
    }

    @Override
    public void minus(Vector v) {
        DoubleBigVector fbv = (DoubleBigVector) v;
        for (int i = 0; i < data.length; i++) {
            data[i] -= fbv.data[i];
        }
    }

    @Override
    public void map(MapFunction f) {
        for (int i = 0; i < data.length; i++) {
            data[i] = f.apply(data[i]);
        }
    }

} // DoubleBigVector

