/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.j2r;

import java.io.File;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.j2r.REngine;
import org.nuiton.j2r.RException;
import org.nuiton.j2r.jni.RJniEngine;
import org.nuiton.j2r.net.RNetEngine;

public class RProxy
implements REngine {
    private Log log = LogFactory.getLog(RProxy.class);
    private REngine engine;

    public RProxy() throws RException {
        Boolean init = this.init();
        if (!init.booleanValue()) {
            throw new RException("R initialisation failed, please check your installation");
        }
    }

    private boolean init(String rType) {
        boolean initSucceded = false;
        if (rType == null) {
            rType = "net";
        }
        if (rType.startsWith("net")) {
            initSucceded = this.initOnNet();
            if (!initSucceded) {
                if (this.log.isErrorEnabled()) {
                    this.log.error((Object)"Initialization of R with Network failed, trying JNI");
                }
                initSucceded = this.initOnJNI();
            }
        } else if ("jni".equalsIgnoreCase(rType)) {
            initSucceded = this.initOnJNI();
            if (!initSucceded) {
                if (this.log.isErrorEnabled()) {
                    this.log.error((Object)"Initialization of R over JNI failed, trying with Network");
                }
                initSucceded = this.initOnNet();
            }
        } else if (this.log.isErrorEnabled()) {
            this.log.error((Object)("Invalid type specified : " + rType));
        }
        return initSucceded;
    }

    private boolean initOnJNI() {
        RJniEngine newEngine;
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)"Trying to initialize the R Proxy over JNI");
        }
        if ((newEngine = new RJniEngine()).init()) {
            this.engine = newEngine;
            return true;
        }
        return false;
    }

    private boolean initOnNet() {
        RNetEngine newEngine;
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)"Trying to initialize the R Proxy with Network");
        }
        if ((newEngine = new RNetEngine()).init()) {
            this.engine = newEngine;
            return true;
        }
        return false;
    }

    @Override
    public Object eval(String expr) throws RException {
        if (this.engine == null) {
            this.log.fatal((Object)"The R Proxy is not initialized. An error probably occured during the initialization.");
            return null;
        }
        return this.engine.eval(expr);
    }

    @Override
    public Object evalScript(String expr) throws RException {
        if (this.engine == null) {
            this.log.fatal((Object)"The R Proxy is not initialized. An error probably occured during the initialization.");
            return null;
        }
        return this.engine.evalScript(expr);
    }

    @Override
    public boolean init() {
        String rType = System.getProperty("R.type");
        if (rType == null || "".equals(rType)) {
            this.log.warn((Object)"No R type specified.\nusage:\n\tjava -DR.type=net ...\nor\n\tjava -DR.type=jni ...\n\nConsidering network type");
            rType = "net";
        }
        if (!this.init(rType)) {
            if (this.log.isFatalEnabled()) {
                this.log.fatal((Object)"The initializing of R failed.");
            }
            return false;
        }
        return true;
    }

    @Override
    public void terminate() throws RException {
        if (this.engine == null) {
            this.log.fatal((Object)"The R Proxy is not initialized. An error probably occured during the initialization.");
        } else {
            this.engine.terminate();
        }
    }

    @Override
    public void voidEval(String expr) throws RException {
        if (this.engine == null) {
            this.log.fatal((Object)"The R Proxy is not initialized. An error probably occured during the initialization.");
            return;
        }
        this.engine.voidEval(expr);
    }

    @Override
    public void loadRData(File directory) throws RException {
        if (this.engine == null) {
            this.log.fatal((Object)"The R Proxy is not initialized. An error probably occured during the initialization.");
            return;
        }
        this.engine.setwd(directory);
        this.engine.voidEval("load(\".RData\")");
    }

    @Override
    public void saveRData(File directory) throws RException {
        if (this.engine == null) {
            this.log.fatal((Object)"The R Proxy is not initialized. An error probably occured during the initialization.");
            return;
        }
        this.engine.setwd(directory);
        this.engine.voidEval("save.image()");
    }

    @Override
    public void setwd(File directory) throws RException {
        if (this.engine == null) {
            this.log.fatal((Object)"The R Proxy is not initialized. An error probably occured during the initialization.");
            return;
        }
        this.engine.setwd(directory);
    }

    @Override
    public File getwd() throws RException {
        if (this.engine == null) {
            this.log.fatal((Object)"The R Proxy is not initialized. An error probably occured during the initialization.");
            return null;
        }
        return this.engine.getwd();
    }

    @Override
    public void dput(String rObject, String outputFileName) throws RException {
        if (this.engine == null) {
            this.log.fatal((Object)"The R Proxy is not initialized. An error probably occured during the initialization.");
            return;
        }
        String rInstruction = "dput(%s,file=\"%s\")";
        this.engine.voidEval(String.format(rInstruction, rObject, outputFileName));
    }

    @Override
    public void dget(String rObject, String inputFileName) throws RException {
        if (this.engine == null) {
            this.log.fatal((Object)"The R Proxy is not initialized. An error probably occured during the initialization.");
            return;
        }
        String rInstruction = "%s <- dget(\"%s\")";
        this.engine.voidEval(String.format(rInstruction, rObject, inputFileName));
    }

    @Override
    public void dput(String rObject, File outputFile) throws RException {
        if (this.engine == null) {
            this.log.fatal((Object)"The R Proxy is not initialized. An error probably occured during the initialization.");
            return;
        }
        File workingdir = this.getwd();
        this.engine.setwd(outputFile.getParentFile());
        String rInstruction = "dput(%s,file=\"%s\")";
        this.engine.voidEval(String.format(rInstruction, rObject, outputFile.getName()));
        this.setwd(workingdir);
    }

    @Override
    public void dget(String rObject, File inputFile) throws RException {
        if (this.engine == null) {
            this.log.fatal((Object)"The R Proxy is not initialized. An error probably occured during the initialization.");
            return;
        }
        File workingdir = this.getwd();
        this.engine.setwd(inputFile.getParentFile());
        String rInstruction = "%s <- dget(\"%s\")";
        this.engine.voidEval(String.format(rInstruction, rObject, inputFile.getName()));
        this.setwd(workingdir);
    }

    @Override
    public void remove(String rObject) throws RException {
        if (this.engine == null) {
            this.log.fatal((Object)"The R Proxy is not initialized. An error probably occured during the initialization.");
            return;
        }
        this.engine.remove(rObject);
    }

    @Override
    public void mv(String source, String destination) throws RException {
        if (this.engine == null) {
            this.log.fatal((Object)"The R Proxy is not initialized. An error probably occured during the initialization.");
            return;
        }
        this.engine.mv(source, destination);
    }

    @Override
    public void cp(String inputObject, String outputObject) throws RException {
        if (this.engine == null) {
            this.log.fatal((Object)"The R Proxy is not initialized. An error probably occured during the initialization.");
            return;
        }
        this.engine.cp(inputObject, outputObject);
    }

    @Override
    public String[] ls() throws RException {
        if (this.engine == null) {
            this.log.fatal((Object)"The R Proxy is not initialized. An error probably occured during the initialization.");
            return null;
        }
        return this.engine.ls();
    }

    @Override
    public void clearSession() throws RException {
        if (this.engine == null) {
            this.log.fatal((Object)"The R Proxy is not initialized. An error probably occured during the initialization.");
            return;
        }
        this.engine.clearSession();
    }

    @Override
    public void commit() throws RException {
        if (this.engine == null) {
            this.log.fatal((Object)"The R Proxy is not initialized. An error probably occured during the initialization.");
            return;
        }
        this.engine.commit();
    }

    @Override
    public void setAutoCommit(Boolean autocommit) throws RException {
        if (this.engine == null) {
            this.log.fatal((Object)"The R Proxy is not initialized. An error probably occured during the initialization.");
            return;
        }
        this.engine.setAutoCommit(autocommit);
    }

    @Override
    public Boolean isAutoCommit() {
        if (this.engine == null) {
            this.log.fatal((Object)"The R Proxy is not initialized. An error probably occured during the initialization.");
            return null;
        }
        return this.engine.isAutoCommit();
    }

    @Override
    public void saveRData(File directory, String fileName) throws RException {
        if (this.engine == null) {
            this.log.fatal((Object)"The R Proxy is not initialized. An error probably occured during the initialization.");
        }
        this.engine.saveRData(directory, fileName);
    }

    @Override
    public void loadRData(File directory, String fileName) throws RException {
        if (this.engine == null) {
            this.log.fatal((Object)"The R Proxy is not initialized. An error probably occured during the initialization.");
        }
        this.engine.loadRData(directory, fileName);
    }

    @Override
    public void saveRData(String filename) throws RException {
        if (this.engine == null) {
            this.log.fatal((Object)"The R Proxy is not initialized. An error probably occured during the initialization.");
        }
        this.engine.saveRData(filename);
    }

    @Override
    public void loadRData(String filename) throws RException {
        if (this.engine == null) {
            this.log.fatal((Object)"The R Proxy is not initialized. An error probably occured during the initialization.");
        }
        this.engine.loadRData(filename);
    }

    @Override
    public void plot(String filename, String x, String y, String type, String main, String sub, String xlab, String ylab, String asp) throws RException {
        if (this.engine == null) {
            this.log.fatal((Object)"The R Proxy is not initialized. An error probably occured during the initialization.");
        }
        this.engine.plot(filename, x, y, type, main, sub, xlab, ylab, asp);
    }

    public boolean isNet() {
        if (this.engine != null) {
            return this.engine instanceof RNetEngine;
        }
        return false;
    }

    public boolean isJni() {
        if (this.engine != null) {
            return this.engine instanceof RJniEngine;
        }
        return false;
    }
}

