/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.config.plugin.templates;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableSet;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.plexus.util.StringUtils;
import org.nuiton.config.ApplicationConfig;
import org.nuiton.config.ApplicationConfigInit;
import org.nuiton.config.ApplicationConfigProvider;
import org.nuiton.config.ConfigActionDef;
import org.nuiton.config.ConfigOptionDef;
import org.nuiton.config.plugin.model.ActionModel;
import org.nuiton.config.plugin.model.ConfigModel;
import org.nuiton.config.plugin.model.OptionModel;
import org.nuiton.config.plugin.templates.ApplicationConfigTransformerConfig;
import org.nuiton.eugene.GeneratorUtil;
import org.nuiton.eugene.java.JavaGeneratorUtil;
import org.nuiton.eugene.java.ObjectModelTransformerToJava;
import org.nuiton.eugene.models.object.ObjectModel;
import org.nuiton.eugene.models.object.ObjectModelClass;
import org.nuiton.eugene.models.object.ObjectModelClassifier;
import org.nuiton.eugene.models.object.ObjectModelElement;
import org.nuiton.eugene.models.object.ObjectModelEnumeration;
import org.nuiton.eugene.models.object.ObjectModelJavaModifier;
import org.nuiton.eugene.models.object.ObjectModelModifier;
import org.nuiton.eugene.models.object.ObjectModelOperation;
import org.nuiton.i18n.I18n;

public class ApplicationConfigTransformer
extends ObjectModelTransformerToJava {
    private static final Log log = LogFactory.getLog(ApplicationConfigTransformer.class);
    public static final String PROP_CONFIG = "config";
    private ApplicationConfigTransformerConfig config;
    private static final Set<String> KNOWN_TYPES = ImmutableSet.of((Object)"File", (Object)"Color", (Object)"KeyStroke", (Object)"URL", (Object)"Class", (Object)"Date", (Object[])new String[]{"Time", "Timestamp", "Locale", "Version", "String", "int", "Integer", "long", "Long", "float", "Float", "boolean", "Boolean", "byte", "Byte", "char", "Character", "double", "Double"});

    public void transformFromModel(ObjectModel model) {
        super.transformFromModel(model);
        this.config = (ApplicationConfigTransformerConfig)this.getConfiguration().getProperty(PROP_CONFIG, ApplicationConfigTransformerConfig.class);
        ConfigModel configModel = this.config.getConfigModel();
        boolean useNuitonI18n = this.config.isUseNuitonI18n();
        String packageName = this.config.getPackageName();
        String configClassName = this.config.getConfigClassName();
        String configProviderClassName = this.config.getConfigProviderClassName();
        String optionsClassName = this.config.getOptionsClassName();
        LinkedList<OptionModel> options = configModel.getOptions();
        String actionsClassName = this.config.getActionsClassName();
        LinkedList<ActionModel> actions = configModel.getActions();
        boolean withActions = CollectionUtils.isNotEmpty(actions);
        String abstractClassName = "Generated" + configClassName;
        this.generateConfigAbstractClass(packageName, abstractClassName, optionsClassName, actionsClassName, options, withActions);
        if (this.canGenerate(packageName + "." + configClassName)) {
            this.generateConfigClass(packageName, configClassName, abstractClassName);
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("Skip generation for " + configClassName));
        }
        if (this.config.isGenerateProvider()) {
            String abstractProviderClassName = "Generated" + configProviderClassName;
            this.generateProviderAbstractClass(packageName, abstractProviderClassName, configClassName, optionsClassName, actionsClassName, useNuitonI18n, configModel.getDescription(), withActions);
            if (this.canGenerate(packageName + "." + configProviderClassName)) {
                this.generateProviderClass(packageName, abstractProviderClassName, configProviderClassName);
            }
        }
        if (this.canGenerate(packageName + "." + optionsClassName)) {
            this.generateOptionsClass(packageName, useNuitonI18n, optionsClassName, options);
        }
        if (withActions && this.canGenerate(packageName + "." + actionsClassName)) {
            this.generateActionsClass(packageName, actionsClassName, actions, useNuitonI18n);
        }
    }

    private void generateOptionsClass(String packageName, boolean useNuitonI18n, String optionsClassName, List<OptionModel> options) {
        ObjectModelEnumeration output = this.createEnumeration(optionsClassName, packageName);
        this.addInterface((ObjectModelClassifier)output, ConfigOptionDef.class);
        if (useNuitonI18n) {
            this.addImport((ObjectModelClassifier)output, I18n.class);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Generate " + output.getQualifiedName()));
        }
        for (OptionModel option : options) {
            String literalName = GeneratorUtil.convertVariableNameToConstantName((String)option.getName());
            String defaultValue = option.getDefaultValue();
            if (defaultValue != null) {
                defaultValue = "\"" + defaultValue + "\"";
            }
            String description = "\"" + option.getDescription() + "\"";
            if (useNuitonI18n) {
                description = "I18n.n(" + description + ")";
            }
            String literal = "\n    " + literalName + "(\n        " + option.getType() + ".class,\n        \"" + option.getKey() + "\",\n        " + description + ",\n        " + defaultValue + ",\n        " + option.isTransient() + ",\n        " + option.isFinal() + ")";
            this.addLiteral(output, literal);
        }
        this.addAttribute((ObjectModelClassifier)output, "type", Class.class, null, new ObjectModelModifier[]{ObjectModelJavaModifier.PRIVATE, ObjectModelJavaModifier.FINAL});
        this.addAttribute((ObjectModelClassifier)output, "key", String.class, null, new ObjectModelModifier[]{ObjectModelJavaModifier.PRIVATE, ObjectModelJavaModifier.FINAL});
        this.addAttribute((ObjectModelClassifier)output, "description", String.class, null, new ObjectModelModifier[]{ObjectModelJavaModifier.PRIVATE, ObjectModelJavaModifier.FINAL});
        this.addAttribute((ObjectModelClassifier)output, "defaultValue", String.class, null, new ObjectModelModifier[]{ObjectModelJavaModifier.PRIVATE});
        this.addAttribute((ObjectModelClassifier)output, "_transient", Boolean.TYPE, null, new ObjectModelModifier[]{ObjectModelJavaModifier.PRIVATE});
        this.addAttribute((ObjectModelClassifier)output, "_final", Boolean.TYPE, null, new ObjectModelModifier[]{ObjectModelJavaModifier.PRIVATE});
        ObjectModelOperation constructor = this.addConstructor(output, (ObjectModelModifier)ObjectModelJavaModifier.PACKAGE);
        this.addParameter(constructor, Class.class, "type");
        this.addParameter(constructor, String.class, "key");
        this.addParameter(constructor, String.class, "description");
        this.addParameter(constructor, String.class, "defaultValue");
        this.addParameter(constructor, Boolean.TYPE, "_transient");
        this.addParameter(constructor, Boolean.TYPE, "_final");
        this.setOperationBody(constructor, "\n        this.type = type;\n        this.key = key;\n        this.description = description;\n        this.defaultValue = defaultValue;\n        this._final = _final;\n        this._transient = _transient;\n    ");
        ObjectModelOperation getKey = this.addOperation((ObjectModelClassifier)output, "getKey", String.class, new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
        this.addAnnotation((ObjectModelClassifier)output, (ObjectModelElement)getKey, Override.class);
        this.setOperationBody(getKey, "\n        return key;\n    ");
        ObjectModelOperation getType = this.addOperation((ObjectModelClassifier)output, "getType", Class.class, new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
        this.addAnnotation((ObjectModelClassifier)output, (ObjectModelElement)getType, Override.class);
        this.setOperationBody(getType, "\n        return type;\n    ");
        ObjectModelOperation getDescription = this.addOperation((ObjectModelClassifier)output, "getDescription", String.class, new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
        this.addAnnotation((ObjectModelClassifier)output, (ObjectModelElement)getDescription, Override.class);
        String descriptionValue = "description";
        if (useNuitonI18n) {
            descriptionValue = "I18n.t(" + descriptionValue + ")";
        }
        this.setOperationBody(getDescription, "\n        return " + descriptionValue + ";\n    ");
        ObjectModelOperation getDefaultValue = this.addOperation((ObjectModelClassifier)output, "getDefaultValue", String.class, new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
        this.addAnnotation((ObjectModelClassifier)output, (ObjectModelElement)getDefaultValue, Override.class);
        this.setOperationBody(getDefaultValue, "\n        return defaultValue;\n    ");
        ObjectModelOperation setDefaultValue = this.addOperation((ObjectModelClassifier)output, "setDefaultValue", Void.TYPE, new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
        this.addParameter(setDefaultValue, String.class, "defaultValue");
        this.addAnnotation((ObjectModelClassifier)output, (ObjectModelElement)setDefaultValue, Override.class);
        this.setOperationBody(setDefaultValue, "\n        this.defaultValue = defaultValue;\n    ");
        ObjectModelOperation isTransient = this.addOperation((ObjectModelClassifier)output, "isTransient", Boolean.TYPE, new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
        this.addAnnotation((ObjectModelClassifier)output, (ObjectModelElement)isTransient, Override.class);
        this.setOperationBody(isTransient, "\n        return _transient;\n    ");
        ObjectModelOperation setTransient = this.addOperation((ObjectModelClassifier)output, "setTransient", Void.TYPE, new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
        this.addParameter(setTransient, Boolean.TYPE, "_transient");
        this.addAnnotation((ObjectModelClassifier)output, (ObjectModelElement)setTransient, Override.class);
        this.setOperationBody(setTransient, "\n        this._transient = _transient;\n    ");
        ObjectModelOperation isFinal = this.addOperation((ObjectModelClassifier)output, "isFinal", Boolean.TYPE, new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
        this.addAnnotation((ObjectModelClassifier)output, (ObjectModelElement)isFinal, Override.class);
        this.setOperationBody(isFinal, "\n        return _final;\n    ");
        ObjectModelOperation setFinal = this.addOperation((ObjectModelClassifier)output, "setFinal", Void.TYPE, new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
        this.addParameter(setFinal, Boolean.TYPE, "_final");
        this.addAnnotation((ObjectModelClassifier)output, (ObjectModelElement)setFinal, Override.class);
        this.setOperationBody(setFinal, "\n        this._final = _final;\n    ");
    }

    private void generateActionsClass(String packageName, String actionsClassName, List<ActionModel> actions, boolean useNuitonI18n) {
        ObjectModelEnumeration output = this.createEnumeration(actionsClassName, packageName);
        this.addInterface((ObjectModelClassifier)output, ConfigActionDef.class);
        if (log.isInfoEnabled()) {
            log.info((Object)("Generate " + output.getQualifiedName()));
        }
        if (useNuitonI18n) {
            this.addImport((ObjectModelClassifier)output, I18n.class);
        }
        for (ActionModel action : actions) {
            String literalName = GeneratorUtil.convertVariableNameToConstantName((String)action.getName());
            String aliases = "";
            if (action.getAliases().length > 0) {
                aliases = ", \"" + Joiner.on((String)"\", \"").join((Object[])action.getAliases()) + "\"";
            }
            String description = "\"" + action.getDescription() + "\"";
            if (useNuitonI18n) {
                description = "I18n.n(" + description + ")";
            }
            String literal = "\n    " + literalName + " ( \"" + action.getAction() + "\", " + description + "" + aliases + "  )";
            this.addLiteral(output, literal);
        }
        this.addAttribute((ObjectModelClassifier)output, "action", String.class, null, new ObjectModelModifier[]{ObjectModelJavaModifier.PRIVATE, ObjectModelJavaModifier.FINAL});
        this.addAttribute((ObjectModelClassifier)output, "description", String.class, null, new ObjectModelModifier[]{ObjectModelJavaModifier.PRIVATE, ObjectModelJavaModifier.FINAL});
        this.addAttribute((ObjectModelClassifier)output, "aliases", "String[]", null, new ObjectModelModifier[]{ObjectModelJavaModifier.PRIVATE, ObjectModelJavaModifier.FINAL});
        ObjectModelOperation constructor = this.addConstructor(output, (ObjectModelModifier)ObjectModelJavaModifier.PACKAGE);
        this.addParameter(constructor, String.class, "action");
        this.addParameter(constructor, String.class, "description");
        this.addParameter(constructor, "String...", "aliases");
        this.setOperationBody(constructor, "\n        this.action = action;\n        this.description = description;\n        this.aliases = aliases;\n    ");
        ObjectModelOperation getAction = this.addOperation((ObjectModelClassifier)output, "getAction", String.class, new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
        this.addAnnotation((ObjectModelClassifier)output, (ObjectModelElement)getAction, Override.class);
        this.setOperationBody(getAction, "\n        return action;\n    ");
        ObjectModelOperation getAliases = this.addOperation((ObjectModelClassifier)output, "getAliases", "String[]", new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
        this.addAnnotation((ObjectModelClassifier)output, (ObjectModelElement)getAliases, Override.class);
        this.setOperationBody(getAliases, "\n        return aliases;\n    ");
        ObjectModelOperation getDescription = this.addOperation((ObjectModelClassifier)output, "getDescription", String.class, new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
        this.addAnnotation((ObjectModelClassifier)output, (ObjectModelElement)getDescription, Override.class);
        String descriptionValue = "description";
        if (useNuitonI18n) {
            descriptionValue = "I18n.t(" + descriptionValue + ")";
        }
        this.setOperationBody(getDescription, "\n        return " + descriptionValue + ";\n    ");
    }

    private void generateProviderAbstractClass(String packageName, String providerClassName, String className, String optionClassName, String actionClassName, boolean useNuitonI18n, String description, boolean withActions) {
        ObjectModelClass output = this.createAbstractClass(providerClassName, packageName);
        this.addInterface((ObjectModelClassifier)output, ApplicationConfigProvider.class);
        if (log.isInfoEnabled()) {
            log.info((Object)("Generate " + output.getQualifiedName()));
        }
        ObjectModelOperation getName = this.addOperation((ObjectModelClassifier)output, "getName", String.class, new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
        this.addAnnotation((ObjectModelClassifier)output, (ObjectModelElement)getName, Override.class);
        this.setOperationBody(getName, "\n        return \"" + className + "\";\n    ");
        if (useNuitonI18n) {
            this.addImport((ObjectModelClassifier)output, I18n.class);
        }
        String optionClassSimpleName = GeneratorUtil.getSimpleName((String)optionClassName);
        ObjectModelOperation getOptions = this.addOperation((ObjectModelClassifier)output, "getOptions", optionClassName + "[]", new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
        this.addAnnotation((ObjectModelClassifier)output, (ObjectModelElement)getOptions, Override.class);
        this.setOperationBody(getOptions, "\n        return " + optionClassSimpleName + ".values();\n    ");
        if (withActions) {
            String actionClassSimpleName = GeneratorUtil.getSimpleName((String)actionClassName);
            ObjectModelOperation getActions = this.addOperation((ObjectModelClassifier)output, "getActions", actionClassName + "[]", new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
            this.addAnnotation((ObjectModelClassifier)output, (ObjectModelElement)getActions, Override.class);
            this.setOperationBody(getActions, "\n        return " + actionClassSimpleName + ".values();\n    ");
        } else {
            this.addImport((ObjectModelClassifier)output, ConfigActionDef.class);
            ObjectModelOperation getActions = this.addOperation((ObjectModelClassifier)output, "getActions", "ConfigActionDef[]", new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
            this.addAnnotation((ObjectModelClassifier)output, (ObjectModelElement)getActions, Override.class);
            this.setOperationBody(getActions, "\n        return new ConfigActionDef[0];\n    ");
        }
        String descriptionValue = "\"" + description + "\"";
        if (useNuitonI18n) {
            descriptionValue = "I18n.l(locale, " + descriptionValue + ")";
        }
        ObjectModelOperation getDescription = this.addOperation((ObjectModelClassifier)output, "getDescription", String.class, new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
        this.addParameter(getDescription, Locale.class, "locale");
        this.addAnnotation((ObjectModelClassifier)output, (ObjectModelElement)getDescription, Override.class);
        this.setOperationBody(getDescription, "\n        return " + descriptionValue + ";\n    ");
    }

    private void generateProviderClass(String packageName, String abstractProviderClassName, String providerClassName) {
        ObjectModelClass output = this.createClass(providerClassName, packageName);
        this.setSuperClass(output, abstractProviderClassName);
        this.addImport((ObjectModelClassifier)output, I18n.class);
        if (log.isInfoEnabled()) {
            log.info((Object)("Generate " + output.getQualifiedName()));
        }
    }

    private void generateConfigAbstractClass(String packageName, String abstractClassName, String optionClassName, String actionClassName, List<OptionModel> options, boolean withActions) {
        String optionClassSimpleName = GeneratorUtil.getSimpleName((String)optionClassName);
        ObjectModelClass output = this.createAbstractClass(abstractClassName, packageName);
        this.addInterface((ObjectModelClassifier)output, "java.util.function.Supplier<ApplicationConfig>");
        this.addImport((ObjectModelClassifier)output, "java.util.function.Supplier");
        this.addImport((ObjectModelClassifier)output, optionClassName);
        if (log.isInfoEnabled()) {
            log.info((Object)("Generate " + output.getQualifiedName()));
        }
        this.addAttribute((ObjectModelClassifier)output, "applicationConfig", ApplicationConfig.class, "", new ObjectModelModifier[]{ObjectModelJavaModifier.PRIVATE});
        ObjectModelOperation publicConstructor = this.addConstructor(output, (ObjectModelModifier)ObjectModelJavaModifier.PROTECTED);
        this.setOperationBody(publicConstructor, "\n        this(ApplicationConfigInit.forAllScopes());\n    ");
        ObjectModelOperation constructor = this.addConstructor(output, (ObjectModelModifier)ObjectModelJavaModifier.PROTECTED);
        this.addParameter(constructor, ApplicationConfigInit.class, "init");
        StringBuilder builder = new StringBuilder();
        builder.append("\n        this.applicationConfig = new ApplicationConfig(init);\n        this.applicationConfig.loadDefaultOptions(" + optionClassSimpleName + ".values());\n    ");
        if (withActions) {
            this.addImport((ObjectModelClassifier)output, actionClassName);
            String actionClassSimpleName = GeneratorUtil.getSimpleName((String)actionClassName);
            builder.append("    this.applicationConfig.loadActions(" + actionClassSimpleName + ".class);\n    ");
        }
        this.setOperationBody(constructor, builder.toString());
        ObjectModelOperation getApplicationConfig = this.addOperation((ObjectModelClassifier)output, "get", ApplicationConfig.class, new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
        this.addAnnotation((ObjectModelClassifier)output, (ObjectModelElement)getApplicationConfig, Override.class);
        this.setOperationBody(getApplicationConfig, "\n        return applicationConfig;\n    ");
        ObjectModelOperation setOption = this.addOperation((ObjectModelClassifier)output, "setOption", "void", new ObjectModelModifier[]{ObjectModelJavaModifier.PROTECTED});
        this.addParameter(setOption, String.class, "key");
        this.addParameter(setOption, Object.class, "attrName");
        this.setOperationBody(setOption, "\n        applicationConfig.setOption(key, String.valueOf(attrName));\n    ");
        boolean generatePropertyChangeSupport = this.config.isGeneratePropertyChangeSupport();
        for (OptionModel option : options) {
            String attrName = option.getName();
            String attrType = option.getType();
            String simpleType = JavaGeneratorUtil.getSimpleName((String)attrType);
            String constantName = JavaGeneratorUtil.getSimpleName((String)optionClassName) + "." + JavaGeneratorUtil.convertVariableNameToConstantName((String)attrName);
            this.addImport((ObjectModelClassifier)output, attrType);
            this.createGetMethod(output, attrName, simpleType, constantName);
            this.createSetMethod(output, attrName, simpleType, constantName, generatePropertyChangeSupport);
        }
        ObjectModelOperation getConfigurationDescription = this.addOperation((ObjectModelClassifier)output, "getConfigurationDescription", String.class, new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
        this.setOperationBody(getConfigurationDescription, "\n        StringBuilder builder = new StringBuilder();\n        builder.append(\"\\n=====================================================================================================================\");\n        builder.append(\"\\n=== Configuration ===================================================================================================\");\n        builder.append(\"\\n=====================================================================================================================\");\n        builder.append(String.format(\"\\n=== %1$-40s = %2$s\", \"Filename\", get().getConfigFileName()));\n        for (" + optionClassSimpleName + " option : orderedByKey()) {\n            builder.append(String.format(\"\\n=== %1$-40s = %2$s\", option.getKey(), get().getOption(option)));\n        }\n        builder.append(\"\\n=====================================================================================================================\");\n        return builder.toString();\n    ");
        if (generatePropertyChangeSupport) {
            this.addAttribute((ObjectModelClassifier)output, "pcs", PropertyChangeSupport.class, "new PropertyChangeSupport(this);", new ObjectModelModifier[]{ObjectModelJavaModifier.PROTECTED, ObjectModelJavaModifier.FINAL});
            ObjectModelOperation addPropertyChangeListener = this.addOperation((ObjectModelClassifier)output, "addPropertyChangeListener", "void", new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
            this.addParameter(addPropertyChangeListener, PropertyChangeListener.class, "listener");
            this.setOperationBody(addPropertyChangeListener, "\n        pcs.addPropertyChangeListener(listener);\n    ");
            ObjectModelOperation addPropertyChangeListener2 = this.addOperation((ObjectModelClassifier)output, "addPropertyChangeListener", "void", new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
            this.addParameter(addPropertyChangeListener2, String.class, "propertyName");
            this.addParameter(addPropertyChangeListener2, PropertyChangeListener.class, "listener");
            this.setOperationBody(addPropertyChangeListener2, "\n        pcs.addPropertyChangeListener(propertyName, listener);\n    ");
            ObjectModelOperation removePropertyChangeListener = this.addOperation((ObjectModelClassifier)output, "removePropertyChangeListener", "void", new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
            this.addParameter(removePropertyChangeListener, PropertyChangeListener.class, "listener");
            this.setOperationBody(removePropertyChangeListener, "\n        pcs.removePropertyChangeListener(listener);\n    ");
            ObjectModelOperation removePropertyChangeListener2 = this.addOperation((ObjectModelClassifier)output, "removePropertyChangeListener", "void", new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
            this.addParameter(removePropertyChangeListener2, String.class, "propertyName");
            this.addParameter(removePropertyChangeListener2, PropertyChangeListener.class, "listener");
            this.setOperationBody(removePropertyChangeListener2, "\n        pcs.removePropertyChangeListener(propertyName, listener);\n    ");
            ObjectModelOperation firePropertyChange = this.addOperation((ObjectModelClassifier)output, "firePropertyChange", "void", new ObjectModelModifier[]{ObjectModelJavaModifier.PROTECTED});
            this.addParameter(firePropertyChange, String.class, "propertyName");
            this.addParameter(firePropertyChange, Object.class, "oldValue");
            this.addParameter(firePropertyChange, Object.class, "newValue");
            this.setOperationBody(firePropertyChange, "\n        pcs.firePropertyChange(propertyName, oldValue, newValue);\n    ");
            ObjectModelOperation firePropertyChange2 = this.addOperation((ObjectModelClassifier)output, "firePropertyChange", "void", new ObjectModelModifier[]{ObjectModelJavaModifier.PROTECTED});
            this.addParameter(firePropertyChange2, String.class, "propertyName");
            this.addParameter(firePropertyChange2, Object.class, "newValue");
            this.setOperationBody(firePropertyChange2, "\n        pcs.firePropertyChange(propertyName, null, newValue);\n    ");
        }
        ObjectModelOperation orderedByKey = this.addOperation((ObjectModelClassifier)output, "orderedByKey", "List<" + optionClassSimpleName + ">", new ObjectModelModifier[]{ObjectModelJavaModifier.PROTECTED});
        this.addImport((ObjectModelClassifier)output, List.class);
        this.addImport((ObjectModelClassifier)output, Arrays.class);
        this.addImport((ObjectModelClassifier)output, Collections.class);
        this.addImport((ObjectModelClassifier)output, Comparator.class);
        this.setOperationBody(orderedByKey, "\n        List<" + optionClassSimpleName + "> values = Arrays.asList(" + optionClassSimpleName + ".values());\n        Collections.sort(values, new Comparator<" + optionClassSimpleName + ">() {\n            @Override\n            public int compare(" + optionClassSimpleName + " o1, " + optionClassSimpleName + " o2) {\n                return o1.getKey().compareTo(o2.getKey());\n            }\n        });\n        return Collections.unmodifiableList(values);\n    ");
    }

    private void generateConfigClass(String packageName, String className, String abstractClassName) {
        ObjectModelClass output = this.createClass(className, packageName);
        if (log.isInfoEnabled()) {
            log.info((Object)("Generate " + output.getQualifiedName()));
        }
        this.setSuperClass(output, abstractClassName);
        ObjectModelOperation publicConstructor = this.addConstructor(output, (ObjectModelModifier)ObjectModelJavaModifier.PUBLIC);
        this.setOperationBody(publicConstructor, "\n        super();\n    ");
        ObjectModelOperation constructor = this.addConstructor(output, (ObjectModelModifier)ObjectModelJavaModifier.PUBLIC);
        this.addParameter(constructor, ApplicationConfigInit.class, "init");
        this.setOperationBody(constructor, "\n        super(init);\n    ");
    }

    private boolean canGenerate(String input) {
        return !this.getResourcesHelper().isJavaFileInClassPath(input);
    }

    private void createGetMethod(ObjectModelClass output, String attrName, String simpleType, String constantName) {
        boolean booleanProperty = GeneratorUtil.isBooleanPrimitive((String)simpleType);
        String methodPrefix = booleanProperty ? "is" : "get";
        String methodName = "getOptionAs" + StringUtils.capitalise((String)simpleType);
        if (simpleType.equals("String")) {
            methodName = "getOption";
        } else if (simpleType.equals("Integer")) {
            methodName = "getOptionAsInt";
        }
        ObjectModelOperation operation = this.addOperation((ObjectModelClassifier)output, this.getJavaBeanMethodName(methodPrefix, attrName), simpleType, new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
        if (!KNOWN_TYPES.contains(simpleType)) {
            methodName = "getOptionAsObject";
            this.setOperationBody(operation, "\n        return (" + simpleType + ") applicationConfig." + methodName + "(" + simpleType + ".class, " + constantName + ".getKey());\n    ");
        } else {
            this.setOperationBody(operation, "\n        return applicationConfig." + methodName + "(" + constantName + ".getKey());\n    ");
            if ("Boolean".equals(simpleType)) {
                operation = this.addOperation((ObjectModelClassifier)output, this.getJavaBeanMethodName("is", attrName), "boolean", new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
                this.setOperationBody(operation, "\n        return applicationConfig." + methodName + "(" + constantName + ".getKey());\n    ");
            }
        }
    }

    private void createSetMethod(ObjectModelClass output, String attrName, String simpleType, String constantName, boolean generatePropertyChangeSupport) {
        boolean booleanProperty = GeneratorUtil.isBooleanPrimitive((String)simpleType);
        ObjectModelOperation operation = this.addOperation((ObjectModelClassifier)output, this.getJavaBeanMethodName("set", attrName), "void", new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
        this.addParameter(operation, simpleType, attrName);
        String methodPrefix = booleanProperty ? "is" : "get";
        String methodName = this.getJavaBeanMethodName(methodPrefix, attrName);
        StringBuilder bodyContent = new StringBuilder();
        if (generatePropertyChangeSupport) {
            bodyContent.append("\n        Object oldValue = " + methodName + "();\n    ");
        }
        bodyContent.append("    setOption(" + constantName + ".getKey(), " + attrName + ");\n    ");
        if (generatePropertyChangeSupport) {
            bodyContent.append("    firePropertyChange(\"" + attrName + "\", oldValue, " + attrName + ");\n    ");
        }
        this.setOperationBody(operation, bodyContent.toString());
        if ("Boolean".equals(simpleType)) {
            operation = this.addOperation((ObjectModelClassifier)output, this.getJavaBeanMethodName("set", attrName), "void", new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
            this.addParameter(operation, "boolean", attrName);
            this.setOperationBody(operation, "\n        setOption(" + constantName + ".getKey(), " + attrName + ");\n    ");
        }
    }
}

