/*
 * *##% 
 * Maven License Plugin
 * Copyright (C) 2008 - 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * ##%*
 */
package org.nuiton.license.plugin;

import java.util.Iterator;
import java.util.Map;
import java.util.Map.Entry;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.nuiton.license.plugin.header.generator.HeaderGenerator;

/**
 * The goal display all the knwon generators.
 *
 * @author chemit
 * 
 * @requiresProject false
 * @requiresDirectInvocation
 * @goal generator-list
 * 
 * @since 1.0.1
 *
 */
public class GeneratorListPlugin extends AbstractMojo {

    /**
     * Un drapeau pour afficher aussi le contenu des license.
     *
     * @parameter expression="${detail}"
     * @since 1.0.1
     */
    protected boolean detail;
    /**
     * All available generators
     *
     * @component role="org.nuiton.license.header.generator.HeaderGenerator"
     */
    protected Map<String, HeaderGenerator> _generators;

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {

        // display it
        StringBuilder buffer = new StringBuilder('\n');
        buffer.append("\n\n-------------------------------------------------------------------------------\n");
        buffer.append("                           maven-license-plugin\n");
        buffer.append("-------------------------------------------------------------------------------\n\n");
        if (_generators == null || _generators.isEmpty()) {
            buffer.append("No generator found.\n\n");
        } else {
            buffer.append("List of available generators :\n\n");
            Iterator<Entry<String, HeaderGenerator>> itr = _generators.entrySet().iterator();
            while (itr.hasNext()) {
                Entry<String, HeaderGenerator> e = itr.next();
                HeaderGenerator generator = e.getValue();
                buffer.append("  - ").append(e.getKey()).append(" : ").append(generator.getDescription());
                buffer.append("\n");
                if (detail) {
                    buffer.append("\n   example : \n").append(generator.getHeader("content ")).append('\n');
                }
            }
        }
        getLog().info(buffer.toString());
    }
}
