package org.nuiton.helper.plugin;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

/**
 * Display help information on maven-helper-plugin.<br/> Call <pre>  mvn helper:help -Ddetail=true -Dgoal=&lt;goal-name&gt;</pre> to display parameter details.
 *
 * @version generated on Thu Feb 03 15:51:31 CET 2011
 * @author org.apache.maven.tools.plugin.generator.PluginHelpGenerator (version 2.5.1)
 * @goal help
 * @requiresProject false
 */
public class HelpMojo
    extends AbstractMojo
{
    /**
     * If <code>true</code>, display all settable properties for each goal.
     * 
     * @parameter expression="${detail}" default-value="false"
     */
    private boolean detail;

    /**
     * The name of the goal for which to show help. If unspecified, all goals will be displayed.
     * 
     * @parameter expression="${goal}"
     */
    private java.lang.String goal;

    /**
     * The maximum length of a display line, should be positive.
     * 
     * @parameter expression="${lineLength}" default-value="80"
     */
    private int lineLength;

    /**
     * The number of spaces per indentation level, should be positive.
     * 
     * @parameter expression="${indentSize}" default-value="2"
     */
    private int indentSize;


    /** {@inheritDoc} */
    public void execute()
        throws MojoExecutionException
    {
        if ( lineLength <= 0 )
        {
            getLog().warn( "The parameter 'lineLength' should be positive, using '80' as default." );
            lineLength = 80;
        }
        if ( indentSize <= 0 )
        {
            getLog().warn( "The parameter 'indentSize' should be positive, using '2' as default." );
            indentSize = 2;
        }

        StringBuffer sb = new StringBuffer();

        append( sb, "org.nuiton:maven-helper-plugin:1.2.11", 0 );
        append( sb, "", 0 );

        append( sb, "Maven helper plugin", 0 );
        append( sb, "Plugin d\'aide pour les projets nuiton", 1 );
        append( sb, "", 0 );

        if ( goal == null || goal.length() <= 0 )
        {
            append( sb, "This plugin has 5 goals:", 0 );
            append( sb, "", 0 );
        }

        if ( goal == null || goal.length() <= 0 || "check-auto-container".equals( goal ) )
        {
            append( sb, "helper:check-auto-container", 0 );
            append( sb, "Check all dependencies are auto contained in the given repositories.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "addMavenCentral (Default: false)", 2 );
                append( sb, "A flag to add the maven central repository http://repo1.maven.org/maven2 to repositories.", 3 );
                append( sb, "", 0 );

                append( sb, "failIfNotSafe (Default: false)", 2 );
                append( sb, "A flag to fail if project is not auto container.", 3 );
                append( sb, "", 0 );

                append( sb, "repositories", 2 );
                append( sb, "Map of repositories to use.\nKeys are repository id and Values are repository url.\n", 3 );
                append( sb, "", 0 );

                append( sb, "runOnce (Default: true)", 2 );
                append( sb, "A flag to execute only once the mojo.\nNote: By default, value is true since it is not necessary to check twice for a same artifact.\n", 3 );
                append( sb, "", 0 );

                append( sb, "verbose (Default: ${maven.verbose})", 2 );
                append( sb, "A flag to activate verbose mode.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "collect-files".equals( goal ) )
        {
            append( sb, "helper:collect-files", 0 );
            append( sb, "Collect files some files from a project and copy them into a directory.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "copyFiles (Default: true)", 2 );
                append( sb, "Un flag pour recopier les fichiers collect\u00e9s.", 3 );
                append( sb, "", 0 );

                append( sb, "descriptionFile", 2 );
                append( sb, "File with all files collected (one file by line in absolute path).\nNote : If not Set, will not generate the description file.\n", 3 );
                append( sb, "", 0 );

                append( sb, "dryRun (Default: false)", 2 );
                append( sb, "Un flag pour activer le mode verbeux.", 3 );
                append( sb, "", 0 );

                append( sb, "encoding (Default: ${project.build.sourceEncoding})", 2 );
                append( sb, "Encoding a utiliser pour lire et ecrire les fichiers.", 3 );
                append( sb, "", 0 );

                append( sb, "excludes", 2 );
                append( sb, "File name pattern of selected files to publish.\nIf no Set - no exclude filter\n", 3 );
                append( sb, "", 0 );

                append( sb, "extraFiles", 2 );
                append( sb, "User extra files to collect.\nMulti values can be used, separated by comma.\n", 3 );
                append( sb, "", 0 );

                append( sb, "includeAttached (Default: true)", 2 );
                append( sb, "Un flag pour collecter aussi les fichiers attaches au projet.", 3 );
                append( sb, "", 0 );

                append( sb, "includes", 2 );
                append( sb, "File name pattern of selected files to publish.\nIf no Set - no include filter\n", 3 );
                append( sb, "", 0 );

                append( sb, "includeSiteAttached (Default: false)", 2 );
                append( sb, "Un flag pour collecter aussi les fichiers des sites attaches au projet.", 3 );
                append( sb, "", 0 );

                append( sb, "outputDirectory (Default: target/collect)", 2 );
                append( sb, "Directory where to store collected files.\nNote : In a multi-module context, will always use the value of the property of the root module, because we need to push collected files to only one place.\n", 3 );
                append( sb, "", 0 );

                append( sb, "skip (Default: false)", 2 );
                append( sb, "A flag to skip the goal.", 3 );
                append( sb, "", 0 );

                append( sb, "verbose (Default: ${maven.verbose})", 2 );
                append( sb, "Un flag pour activer le mode verbeux.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "help".equals( goal ) )
        {
            append( sb, "helper:help", 0 );
            append( sb, "Display help information on maven-helper-plugin.\nCall\n\u00a0\u00a0mvn\u00a0helper:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "detail (Default: false)", 2 );
                append( sb, "If true, display all settable properties for each goal.", 3 );
                append( sb, "", 0 );

                append( sb, "goal", 2 );
                append( sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3 );
                append( sb, "", 0 );

                append( sb, "indentSize (Default: 2)", 2 );
                append( sb, "The number of spaces per indentation level, should be positive.", 3 );
                append( sb, "", 0 );

                append( sb, "lineLength (Default: 80)", 2 );
                append( sb, "The maximum length of a display line, should be positive.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "send-email".equals( goal ) )
        {
            append( sb, "helper:send-email", 0 );
            append( sb, "Send a email.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "dryRun (Default: false)", 2 );
                append( sb, "A flag to test plugin but send nothing to redmine.", 3 );
                append( sb, "", 0 );

                append( sb, "emailContentFile", 2 );
                append( sb, "The Velocity template used to format the email announcement.", 3 );
                append( sb, "", 0 );

                append( sb, "emailTitle", 2 );
                append( sb, "The title of the email to send.", 3 );
                append( sb, "", 0 );

                append( sb, "encoding (Default: ${project.build.sourceEncoding})", 2 );
                append( sb, "The encoding used to read and write files.", 3 );
                append( sb, "", 0 );

                append( sb, "fromDeveloperId", 2 );
                append( sb, "The id of the developer sending the announcement mail. Only used if the mailSender attribute is not set. In this case, this should match the id of one of the developers in the pom. If a matching developer is not found, then the first developer in the pom will be used.", 3 );
                append( sb, "", 0 );

                append( sb, "mailContentType (Default: text/plain)", 2 );
                append( sb, "Mail content type to use.", 3 );
                append( sb, "", 0 );

                append( sb, "mailSender", 2 );
                append( sb, "Defines the sender of the announcement if the list of developer is empty or if the sender is not a member of the development team.", 3 );
                append( sb, "", 0 );

                append( sb, "password", 2 );
                append( sb, "The password used to send the email.", 3 );
                append( sb, "", 0 );

                append( sb, "runOnce (Default: true)", 2 );
                append( sb, "A flag to restirct only one run in a build (for multi-module context).", 3 );
                append( sb, "", 0 );

                append( sb, "skipSendEmail (Default: false)", 2 );
                append( sb, "A flag to skip the goal.", 3 );
                append( sb, "", 0 );

                append( sb, "smtpHost", 2 );
                append( sb, "Smtp Server.", 3 );
                append( sb, "", 0 );

                append( sb, "smtpPort (Default: 25)", 2 );
                append( sb, "Port.", 3 );
                append( sb, "", 0 );

                append( sb, "sslMode (Default: false)", 2 );
                append( sb, "If the email should be sent in SSL mode.", 3 );
                append( sb, "", 0 );

                append( sb, "toAddresses", 2 );
                append( sb, "Recipient email address.", 3 );
                append( sb, "", 0 );

                append( sb, "username", 2 );
                append( sb, "The username used to send the email.", 3 );
                append( sb, "", 0 );

                append( sb, "verbose (Default: ${maven.verbose})", 2 );
                append( sb, "Un flag pour activer le mode verbeux.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "share-server-secret".equals( goal ) )
        {
            append( sb, "helper:share-server-secret", 0 );
            append( sb, "Obtain a server authentication and share it in the maven project properties.\nTo select data to export from the server with the given serverId, fill the properties :\n\n\u00a0\u00a0usernameOut\n\u00a0\u00a0passwordOut\n\u00a0\u00a0privateKeyOut\n\u00a0\u00a0passphraseOut\n", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "passphraseOut", 2 );
                append( sb, "The name of the property where to export the passphrase of the server.\nNote: If not set - then no export of the passphrase of the server.\n\nNote: If the passphrase is crypted (since maven 2.1.0) then decrypt it.\n", 3 );
                append( sb, "", 0 );

                append( sb, "passwordOut", 2 );
                append( sb, "The name of the property where to export the password of the server.\nNote: If not set - then no export of the password of the server.\n\nNote: If the password is crypted (since maven 2.1.0) then decrypt it.\n", 3 );
                append( sb, "", 0 );

                append( sb, "privateKeyOut", 2 );
                append( sb, "The name of the property where to export the private key of the server.\nNote: If not set - then no export of the private key of the server.\n", 3 );
                append( sb, "", 0 );

                append( sb, "runOnce (Default: true)", 2 );
                append( sb, "A flag to execute only once the mojo.\nNote: By default, value is true since it is not necessary to inject twice secrets in session.\n", 3 );
                append( sb, "", 0 );

                append( sb, "serverId", 2 );
                append( sb, "Server id to use for authentication (must be defined in your setting and use the maven >= 2.1.0 password encryption mecanism).\n", 3 );
                append( sb, "", 0 );

                append( sb, "usernameOut", 2 );
                append( sb, "The name of the property where to export the username of the server.\nNote: If not set - then no export of the username of the server.\n", 3 );
                append( sb, "", 0 );

                append( sb, "verbose (Default: ${maven.verbose})", 2 );
                append( sb, "A flag to activate verbose mode.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( getLog().isInfoEnabled() )
        {
            getLog().info( sb.toString() );
        }
    }

    /**
     * <p>Repeat a String <code>n</code> times to form a new string.</p>
     *
     * @param str String to repeat
     * @param repeat number of times to repeat str
     * @return String with repeated String
     * @throws NegativeArraySizeException if <code>repeat < 0</code>
     * @throws NullPointerException if str is <code>null</code>
     */
    private static String repeat( String str, int repeat )
    {
        StringBuffer buffer = new StringBuffer( repeat * str.length() );

        for ( int i = 0; i < repeat; i++ )
        {
            buffer.append( str );
        }

        return buffer.toString();
    }

    /** 
     * Append a description to the buffer by respecting the indentSize and lineLength parameters.
     * <b>Note</b>: The last character is always a new line.
     * 
     * @param sb The buffer to append the description, not <code>null</code>.
     * @param description The description, not <code>null</code>.
     * @param indent The base indentation level of each line, must not be negative.
     */
    private void append( StringBuffer sb, String description, int indent )
    {
        for ( Iterator it = toLines( description, indent, indentSize, lineLength ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( '\n' );
        }
    }

    /** 
     * Splits the specified text into lines of convenient display length.
     * 
     * @param text The text to split into lines, must not be <code>null</code>.
     * @param indent The base indentation level of each line, must not be negative.
     * @param indentSize The size of each indentation, must not be negative.
     * @param lineLength The length of the line, must not be negative.
     * @return The sequence of display lines, never <code>null</code>.
     * @throws NegativeArraySizeException if <code>indent < 0</code>
     */
    private static List toLines( String text, int indent, int indentSize, int lineLength )
    {
        List lines = new ArrayList();

        String ind = repeat( "\t", indent );
        String[] plainLines = text.split( "(\r\n)|(\r)|(\n)" );
        for ( int i = 0; i < plainLines.length; i++ )
        {
            toLines( lines, ind + plainLines[i], indentSize, lineLength );
        }

        return lines;
    }

    /** 
     * Adds the specified line to the output sequence, performing line wrapping if necessary.
     * 
     * @param lines The sequence of display lines, must not be <code>null</code>.
     * @param line The line to add, must not be <code>null</code>.
     * @param indentSize The size of each indentation, must not be negative.
     * @param lineLength The length of the line, must not be negative.
     */
    private static void toLines( List lines, String line, int indentSize, int lineLength )
    {
        int lineIndent = getIndentLevel( line );
        StringBuffer buf = new StringBuffer( 256 );
        String[] tokens = line.split( " +" );
        for ( int i = 0; i < tokens.length; i++ )
        {
            String token = tokens[i];
            if ( i > 0 )
            {
                if ( buf.length() + token.length() >= lineLength )
                {
                    lines.add( buf.toString() );
                    buf.setLength( 0 );
                    buf.append( repeat( " ", lineIndent * indentSize ) );
                }
                else
                {
                    buf.append( ' ' );
                }
            }
            for ( int j = 0; j < token.length(); j++ )
            {
                char c = token.charAt( j );
                if ( c == '\t' )
                {
                    buf.append( repeat( " ", indentSize - buf.length() % indentSize ) );
                }
                else if ( c == '\u00A0' )
                {
                    buf.append( ' ' );
                }
                else
                {
                    buf.append( c );
                }
            }
        }
        lines.add( buf.toString() );
    }

    /** 
     * Gets the indentation level of the specified line.
     * 
     * @param line The line whose indentation level should be retrieved, must not be <code>null</code>.
     * @return The indentation level of the line.
     */
    private static int getIndentLevel( String line )
    {
        int level = 0;
        for ( int i = 0; i < line.length() && line.charAt( i ) == '\t'; i++ )
        {
            level++;
        }
        for ( int i = level + 1; i <= level + 4 && i < line.length(); i++ )
        {
            if ( line.charAt( i ) == '\t' )
            {
                level++;
                break;
            }
        }
        return level;
    }
}
