/*
 * *##% 
 * Maven helper plugin
 * Copyright (C) 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * ##%*
 */
package org.nuiton.plugin;

import org.apache.maven.plugin.Mojo;
import org.apache.maven.plugin.testing.AbstractMojoTestCase;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.PlexusTestCase;
import java.io.File;
import org.junit.Assert;

/**
 *
 * @author chemit
 * @since 1.0.3
 */
public abstract class TestHelper extends PluginHelper {

    protected static boolean verbose;
    protected static File basedir;
    protected static DelegateMojoTestCase delegateMojoTest;

    /**
     *
     * @return the basedir for all tests
     * @see PlexusTestCase#getBasedir()
     */
    public static File getBasedir() {
        if (basedir == null) {
            String path = PlexusTestCase.getBasedir();
            basedir = new File(path);
            if (verbose) {
                System.out.println("basedir = " + basedir.getAbsolutePath());
            }
        }
        return basedir;
    }

    public static void setBasedir(File basedir) {
        TestHelper.basedir = basedir;
    }

    public static boolean isVerbose() {
        return verbose;
    }

    public static void setVerbose(boolean verbose) {
        TestHelper.verbose = verbose;
    }

    public static File getTestDir(Class<?> type, String prefix) {
        String rep = type.getName();
        rep = rep.replaceAll("\\.", File.separator);

        File f = new File(getBasedir(), prefix);
        File testDir = new File(f, rep);
        return testDir;
    }

    public static Mojo lookupMojo(String goalName, File pomFile) throws Exception {
        Mojo lookupMojo = getDelegateMojoTest().lookupMojo(goalName, pomFile);
        Assert.assertNotNull(lookupMojo);
        return lookupMojo;

    }

    public static DelegateMojoTestCase getDelegateMojoTest() throws Exception {
        if (TestHelper.delegateMojoTest == null) {
            TestHelper.delegateMojoTest = new DelegateMojoTestCase();
            TestHelper.delegateMojoTest.setUp();
        }
        return TestHelper.delegateMojoTest;
    }

    public static void setDelegateMojoTest(DelegateMojoTestCase delegateMojoTest) {
        TestHelper.delegateMojoTest = delegateMojoTest;
    }

    public static class DelegateMojoTestCase extends AbstractMojoTestCase {

        @Override
        public Mojo lookupMojo(String goal, File pom) throws Exception {
            return super.lookupMojo(goal, pom);
        }

        @Override
        public void setUp() throws Exception {
            super.setUp();
        }

        @Override
        public void tearDown() throws Exception {
            super.tearDown();
        }

        @Override
        public PlexusContainer getContainer() {
            return super.getContainer();
        }
    }
}
