/*
 * *##% 
 * Maven helper plugin
 * Copyright (C) 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * ##%*
 */
package org.nuiton.license.plugin;

import static org.junit.Assert.*;
import org.junit.Test;

import java.io.File;
import java.io.IOException;
import org.nuiton.plugin.AbstractMojoTest;
/**
 *
 * @author chemit
 * @deprecated since 1.0.3, move all license stuff in maven-license-plugin
 */
@Deprecated
public class LicensePluginTest extends AbstractMojoTest<LicensePlugin> {

    @Override
    protected String getGoalName(String methodName) {
        return "add-license";
    }

    @Override
    protected void setUpMojo(LicensePlugin mojo, File pomFile) throws Exception {
        super.setUpMojo(mojo, pomFile);
        // license is where the pom is
        File outputDirectory = pomFile.getParentFile();
        mojo.setOutputDirectory(outputDirectory);
        if (!outputDirectory.exists()) {
            if (!outputDirectory.mkdirs()) {
                throw new IOException("could not create directory : " + outputDirectory);
            }
        }
        mojo.setLicenseFile(new File(pomFile.getParentFile(), mojo.getLicenseFile().toString()));
        log.info("pom             : " + getRelativePathFromBasedir(mojo.getProject().getFile()));
        log.info("outputDirectory : " + getRelativePathFromBasedir(mojo.getOutputDirectory()));
        log.info("licenseFile     : " + getRelativePathFromBasedir(mojo.getLicenseFile()));
    }

    @Test
    public void testOne() throws Exception {

        LicensePlugin mojo = getMojo();

        long t0 = mojo.getLicenseFile().lastModified();

        // always assume pom is older than any file
        // since we can not ensure order of copy test resources
        mojo.getProject().getFile().setLastModified(0);

        // then executing the mojo, will do NOT change the licence file
        mojo.execute();

        long t1 = mojo.getLicenseFile().lastModified();

        assertEquals(t0, t1);

        // force to override the license file
        mojo.setForce(true);

        mojo.execute();
        t1 = mojo.getLicenseFile().lastModified();

        assertTrue(t1 > t0);
    }

    @Test
    public void testTwo() throws Exception {

        LicensePlugin mojo = getMojo();

        long t0 = mojo.getLicenseFile().lastModified();

        // always assume pom is older than any file
        // since we can not ensure order of copy test resources
        mojo.getProject().getFile().setLastModified(0);

        // then executing the mojo, will do NOT change the licence file
        mojo.execute();

        long t1 = mojo.getLicenseFile().lastModified();

        assertEquals(t0, t1);

        // force to override the license file
        mojo.setForce(true);

        mojo.execute();
        t1 = mojo.getLicenseFile().lastModified();

        assertTrue(t1 > t0);
    }
}
