/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.channels.FileChannel;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.Vector;
import org.apache.maven.model.Resource;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.io.InputStreamFacade;
import org.codehaus.plexus.util.io.RawInputStreamFacade;

public class PluginHelper {
    protected static final double[] timeFactors = new double[]{1000000.0, 1000.0, 60.0, 60.0, 24.0};
    protected static final String[] timeUnites = new String[]{"ns", "ms", "s", "m", "h", "d"};

    public static <O> List<O> toGenericList(List<?> list, Class<O> type) throws IllegalArgumentException {
        if (list.isEmpty()) {
            return list;
        }
        for (Object o : list) {
            if (type.isAssignableFrom(o.getClass())) continue;
            throw new IllegalArgumentException("can not cast List with object of type " + o.getClass() + " to " + type + " type!");
        }
        return list;
    }

    public static String convertTime(long value) {
        return PluginHelper.convert(value, timeFactors, timeUnites);
    }

    public static String convertTime(long value, long value2) {
        return PluginHelper.convertTime(value2 - value);
    }

    public static String convert(long value, double[] factors, String[] unites) {
        long sign = value == 0L ? 1L : value / Math.abs(value);
        int i = 0;
        for (double tmp = (double)Math.abs(value); i < factors.length && i < unites.length && tmp > factors[i]; tmp /= factors[i++]) {
        }
        String result = MessageFormat.format("{0,number,0.###}{1}", tmp *= (double)sign, unites[i]);
        return result;
    }

    public static SortedSet<String> getEmptyKeys(Map<?, ?> map) {
        TreeSet<String> result = new TreeSet<String>();
        for (Map.Entry<?, ?> e : map.entrySet()) {
            if (e.getValue() != null && !e.getValue().toString().isEmpty()) continue;
            result.add(e.getKey().toString());
        }
        return result;
    }

    public static boolean addResourceDir(String newresourceDir, MavenProject project) {
        List resources = project.getResources();
        boolean added = PluginHelper.addResourceDir(newresourceDir, project, resources);
        return added;
    }

    public static boolean addTestResourceDir(String newresourceDir, MavenProject project) {
        List resources = project.getTestResources();
        boolean added = PluginHelper.addResourceDir(newresourceDir, project, resources);
        return added;
    }

    public static boolean addResourceDir(String newresourceDir, MavenProject project, List<?> resources) {
        boolean shouldAdd = true;
        for (Object o : resources) {
            Resource r = (Resource)o;
            if (!r.getDirectory().equals(newresourceDir)) continue;
            r.addInclude("**/*.properties");
            r.addInclude("**/*.txt");
            shouldAdd = false;
            break;
        }
        if (shouldAdd) {
            Resource r = new Resource();
            r.setDirectory(newresourceDir);
            r.addInclude("**/*.properties");
            r.addInclude("**/*.txt");
            project.addResource(r);
        }
        return shouldAdd;
    }

    public static void copy(File source, File target) throws IOException {
        target.getParentFile().mkdirs();
        FileChannel sourceChannel = new FileInputStream(source).getChannel();
        FileChannel targetChannel = new FileOutputStream(target).getChannel();
        sourceChannel.transferTo(0L, sourceChannel.size(), targetChannel);
        sourceChannel.close();
        targetChannel.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readAsString(File file, String encoding) throws IOException {
        FileInputStream inf = new FileInputStream(file);
        BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)inf, encoding));
        try {
            String string = IOUtil.toString((Reader)in);
            return string;
        }
        finally {
            in.close();
        }
    }

    public static String readAsString(Reader file) throws IOException {
        StringBuffer result = new StringBuffer();
        char[] cbuf = new char[2000];
        BufferedReader in = new BufferedReader(file);
        int nb = in.read(cbuf);
        while (nb != -1) {
            result.append(cbuf, 0, nb);
            nb = in.read(cbuf);
        }
        in.close();
        return result.toString();
    }

    public static void writeString(File file, String content, String encoding) throws IOException {
        file.getParentFile().mkdirs();
        BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), encoding));
        out.write(content);
        out.close();
    }

    public static void write(File destFile, String content, String encoding) throws IOException {
        ByteArrayInputStream in = new ByteArrayInputStream(content.getBytes(encoding));
        RawInputStreamFacade facade = new RawInputStreamFacade((InputStream)in);
        FileUtils.copyStreamToFile((InputStreamFacade)facade, (File)destFile);
    }

    public static class PropertiesDateRemoveFilterStream
    extends FilterOutputStream {
        private boolean firstLineOver = false;
        char endChar;

        public PropertiesDateRemoveFilterStream(OutputStream out) {
            super(out);
            String lineSeparator = System.getProperty("line.separator");
            this.endChar = lineSeparator.charAt(lineSeparator.length() - 1);
        }

        @Override
        public void write(int b) throws IOException {
            if (!this.firstLineOver) {
                char c = (char)b;
                if (c == this.endChar) {
                    this.firstLineOver = true;
                }
            } else {
                this.out.write(b);
            }
        }
    }

    public static class SortedProperties
    extends Properties {
        private static final long serialVersionUID = -1147150444452577558L;
        protected String encoding;
        protected boolean removeHeader;

        public SortedProperties(String encoding) {
            this(encoding, true);
        }

        public SortedProperties(String encoding, boolean removeHeader) {
            this.encoding = encoding;
            this.removeHeader = removeHeader;
        }

        public SortedProperties(Properties defaults) {
            super(defaults);
        }

        @Override
        public synchronized Enumeration<Object> keys() {
            Vector<Object> result;
            ArrayList<Object> objects = Collections.list(super.keys());
            try {
                List<String> list = PluginHelper.toGenericList(objects, String.class);
                Collections.sort(list);
                result = new Vector<String>(list);
            }
            catch (IllegalArgumentException e) {
                result = new Vector<Object>(objects);
            }
            return result.elements();
        }

        public SortedProperties load(File src) throws IOException {
            super.load(new InputStreamReader((InputStream)new FileInputStream(src), this.encoding));
            return this;
        }

        public void store(File dst) throws IOException {
            if (this.removeHeader) {
                super.store(new OutputStreamWriter((OutputStream)new PropertiesDateRemoveFilterStream(new FileOutputStream(dst)), this.encoding), null);
            } else {
                super.store(new FileOutputStream(dst), null);
            }
        }

        public void store(OutputStream dst) throws IOException {
            if (this.removeHeader) {
                super.store(new PropertiesDateRemoveFilterStream(dst), null);
            } else {
                super.store(dst, null);
            }
        }
    }
}

