/*
 * #%L
 * 
 * 
 * $Id: GraphRendererComboBoxModel.java 299 2010-12-08 15:38:02Z echatellier $
 * $HeadURL: http://svn.nuiton.org/svn/nuiton-matrix/tags/nuiton-matrix-2.3.2/nuiton-matrix-gui/src/main/java/org/nuiton/math/matrix/viewer/renderer/jfreechart/GraphRendererComboBoxModel.java $
 * %%
 * Copyright (C) 2010 Codelutin, Chatellier Eric
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

package org.nuiton.math.matrix.viewer.renderer.jfreechart;

import java.util.ArrayList;
import java.util.List;

import javax.swing.DefaultComboBoxModel;

import org.jfree.chart.labels.StandardCategoryToolTipGenerator;
import org.jfree.chart.renderer.category.AreaRenderer;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.chart.renderer.category.BarRenderer3D;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.renderer.category.LineAndShapeRenderer;
import org.jfree.chart.renderer.category.LineRenderer3D;
import org.jfree.chart.renderer.category.MinMaxCategoryRenderer;
import org.jfree.chart.renderer.category.StackedAreaRenderer;
import org.jfree.chart.renderer.category.StackedBarRenderer;

/**
 * JfreeChart renderer combo box model.
 * 
 * @author chatellier
 * @version $Revision: 299 $
 * 
 * Last update : $Date: 2010-12-08 16:38:02 +0100 (Wed, 08 Dec 2010) $
 * By : $Author: echatellier $
 */
public class GraphRendererComboBoxModel extends DefaultComboBoxModel {

    /** serialVersionUID. */
    private static final long serialVersionUID = 5084118137199817098L;

    protected List<CategoryItemRenderer> rendererList;

    public GraphRendererComboBoxModel() {
        rendererList = new ArrayList<CategoryItemRenderer>();
        loadRenderers();
    }

    protected void loadRenderers() {

        // rendu : vertical bar
        BarRenderer barRenderer = new BarRenderer();
        barRenderer.setBaseToolTipGenerator(new StandardCategoryToolTipGenerator());
        rendererList.add(barRenderer);
    
        // rendu : vertical bar 3d
        BarRenderer3D barRenderer3D = new BarRenderer3D();
        barRenderer3D.setBaseToolTipGenerator(new StandardCategoryToolTipGenerator());
        rendererList.add(barRenderer3D);
    
        // rendu stacked bar
        StackedBarRenderer stackedBarRenderer = new StackedBarRenderer();
        stackedBarRenderer.setBaseToolTipGenerator(new StandardCategoryToolTipGenerator());
        rendererList.add(stackedBarRenderer);
        
        // rendu aire
        AreaRenderer areaRenderer = new AreaRenderer();
        areaRenderer.setBaseToolTipGenerator(new StandardCategoryToolTipGenerator());
        rendererList.add(areaRenderer);
        
        // rendu aire empilée
        StackedAreaRenderer stackedAreaRenderer = new StackedAreaRenderer();
        stackedAreaRenderer.setBaseToolTipGenerator(new StandardCategoryToolTipGenerator());
        rendererList.add(stackedAreaRenderer);
        
        // rendu line aire
        LineAndShapeRenderer lineAndShapeRenderer = new LineAndShapeRenderer();
        lineAndShapeRenderer.setBaseToolTipGenerator(new StandardCategoryToolTipGenerator());
        rendererList.add(lineAndShapeRenderer);
        
        // rendu ligne 3d
        LineRenderer3D lineRenderer3D = new LineRenderer3D();
        lineRenderer3D.setBaseToolTipGenerator(new StandardCategoryToolTipGenerator());
        rendererList.add(lineRenderer3D);
        
        // rendu mix/max
        MinMaxCategoryRenderer minMaxCategoryRenderer = new MinMaxCategoryRenderer();
        minMaxCategoryRenderer.setBaseToolTipGenerator(new StandardCategoryToolTipGenerator());
        rendererList.add(minMaxCategoryRenderer);
        
        // auto select first
        setSelectedItem(barRenderer);
    }

    @Override
    public int getSize() {
        return rendererList.size();
    }

    @Override
    public Object getElementAt(int index) {
        return rendererList.get(index);
    }
}
