/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jredmine.plugin;

import java.text.ParseException;
import java.util.Arrays;
import java.util.Date;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.plexus.util.StringUtils;
import org.nuiton.jredmine.model.ModelHelper;
import org.nuiton.jredmine.model.Version;
import org.nuiton.jredmine.model.VersionStatusEnum;
import org.nuiton.jredmine.plugin.AbstractRedmineMojo;
import org.nuiton.plugin.PluginHelper;

public class UpdateVersionMojo
extends AbstractRedmineMojo {
    protected boolean anonymous;
    protected String versionDescription;
    protected boolean closeVersion;
    protected String effectiveDate;
    protected String versionStatus;
    protected boolean skipUpdateVersion;
    protected boolean dryRun;
    protected boolean runOnce;
    private Date date;
    private VersionStatusEnum newVersionStatus;

    public UpdateVersionMojo() {
        super(true, false, true);
    }

    public boolean isAnonymous() {
        return this.anonymous;
    }

    public void setAnonymous(boolean anonymous) {
        this.anonymous = anonymous;
    }

    @Override
    protected boolean isGoalSkip() {
        return this.skipUpdateVersion;
    }

    @Override
    protected boolean isRunOnce() {
        return this.runOnce;
    }

    @Override
    protected boolean checkRunOnceDone() {
        return this.isRunOnce() && !this.isExecutionRoot();
    }

    @Override
    protected void init() throws Exception {
        if (this.versionId == null || this.versionId.trim().isEmpty()) {
            throw new MojoExecutionException("required a versionId parameter");
        }
        this.versionId = PluginHelper.removeSnapshotSuffix((String)this.versionId);
        this.runOnceDone = false;
        if (this.isRunOnce()) {
            this.runOnceDone = this.checkRunOnceDone();
            if (this.runOnceDone) {
                return;
            }
        }
        if (this.effectiveDate != null && !this.effectiveDate.trim().isEmpty()) {
            try {
                this.date = this.dateFormat.parse(this.effectiveDate);
            }
            catch (ParseException e) {
                throw new MojoExecutionException("could not parse effectivate date " + this.effectiveDate + " for reason " + e.getMessage(), (Exception)e);
            }
        } else if (this.closeVersion) {
            this.date = new Date();
        }
        if (this.closeVersion) {
            this.newVersionStatus = VersionStatusEnum.closed;
        }
        if (StringUtils.isNotEmpty((String)this.versionStatus)) {
            try {
                this.newVersionStatus = VersionStatusEnum.valueOf((String)this.versionStatus);
            }
            catch (IllegalArgumentException e) {
                throw new MojoExecutionException("could not parse status " + this.versionStatus + " for reason " + e.getMessage() + ", should be one of values : " + Arrays.toString(VersionStatusEnum.values()), (Exception)e);
            }
            if (this.closeVersion && this.getLog().isWarnEnabled()) {
                this.getLog().warn((CharSequence)("While using the closeVersion flag, you should not set also the version status : [" + this.versionStatus + "]"));
            }
        }
        super.init();
    }

    @Override
    protected void doAction() throws Exception {
        boolean needCreateVersion;
        Version[] versions;
        Version v;
        if (this.dryRun) {
            this.getLog().info((CharSequence)"\n  dryRun flag is on, no data will be send!\n");
        }
        if ((v = ModelHelper.byVersionName((String)this.versionId, (Version[])(versions = this.service.getVersions(this.projectId)))) == null) {
            needCreateVersion = true;
            v = new Version();
            v.setName(this.versionId);
        } else {
            needCreateVersion = false;
        }
        if (this.versionDescription != null && !this.versionDescription.trim().isEmpty()) {
            v.setDescription(this.versionDescription.trim());
        }
        if (this.date != null) {
            v.setEffectiveDate(this.date);
        }
        if (this.newVersionStatus != null) {
            if (this.isVerbose()) {
                this.getLog().info((CharSequence)("Will set status " + this.newVersionStatus));
            }
            v.setStatus(this.newVersionStatus.name());
        }
        this.releaseVersion = v;
        if (needCreateVersion) {
            this.getLog().info((CharSequence)("create version " + this.releaseVersion.getName()));
            if (!this.dryRun) {
                this.service.addVersion(this.projectId, this.releaseVersion);
            }
        } else {
            this.getLog().info((CharSequence)("udpate version " + this.releaseVersion.getName()));
            if (!this.dryRun) {
                this.service.updateVersion(this.projectId, this.releaseVersion);
            }
        }
    }
}

