/*
 * *##% 
 * JRedmine :: Maven plugin
 * Copyright (C) 2009 - 2010 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * ##%*
 */
package org.nuiton.jredmine.plugin.report;

import java.util.Map;

/**
 * Generates a report for issues from Redmine's server group by assignee.
 *
 * @author tchemit
 * @goal issues-report-by-assignee
 * @since 1.0.0
 */
public class IssuesReportByAssignee extends AbstractIssuesReport {

    /**
     * Maximum number of entries to be fetched from redmine.
     * <p/>
     * <b>Note:</b> use value 0 to have no limits
     *
     * @parameter expression="${redmine.maxEntries}" default-value="100"
     * @since 1.0.0
     */
    protected int maxEntriesByAssignee;
    /**
     * If you only want to show issues for the current version in the report.
     * The current version being used is <code>${project.version}</code> minus
     * any "-SNAPSHOT" suffix.
     *
     * @parameter expression="${redmine.onlyCurrentVersion}" default-value="false"
     * @since 1.0.0
     */
    protected boolean onlyCurrentVersionByAssignee;
    /**
     * Sets some filters on issues to include.
     * the possible keys are :
     * <ul>
     * <li><b>version</b> : to restrict on version fixed </li>
     * <li><b>status</b> : to restrict on some status</li>
     * <li><b>priority</b> : to restrict on some priorties</li>
     * <li><b>category</b> : to restrict on some categories</li>
     * <li><b>tracker</b> : to restrict on some tracker (says type of issues)</li>
     * </ul>
     * <p/>
     * Values are Redmine's internal ids (except for the version entry
     * which use Redmine's version names).
     * <p/>
     * Multiple values can be separated by commas.
     * <p/>
     * <p/>
     * <b>Note :</b> If a value is set to empty - that means to not filter on
     * that property.
     * <p/>
     * <p/>
     * To see the internal ids, use the command :
     * <pre>
     * mvn redmine:display-ids -Dtype=&lt;entry key&gt;
     * </pre>
     *
     * @parameter
     * @since 1.0.0
     */
    protected Map<String, String> filtersByAssignee;
    /**
     * Sets the column names that you want to show in the report. The columns
     * will appear in the report in the same order as you specify them here.
     * Multiple values can be separated by commas.
     * <p>
     * Valid columns are: <code>Key</code>, <code>Summary</code>,
     * <code>Status</code>, <code>Assignee</code>,
     * <code>Reporter</code>, <code>Tracker</code>, <code>Priority</code>,
     * <code>Version</code>, <code>Category</code>, <code>Created</code> and
     * <code>Updated</code>.
     * </p>
     *
     * @parameter expression="${redmine.columnNames}" default-value="Tracker,Category,Key,Summary,Status,Assignee,Version"
     * @since 2.0
     */
    protected String columnNamesByAssignee;

    /**
     * A flag to skip the report.
     *
     * This can be usefull since there is no way to skip a report from an
     * inherited reportSet configuration.
     *
     * @parameter expression="${redmine.skipIssueReportByAssignee}" default-value="false"
     * @since 1.0.0
     */
    protected boolean skipIssueReportByAssignee;

    @Override
    protected boolean skipReport() {
        return skipIssueReportByAssignee;
    }

    public IssuesReportByAssignee() {
        super("assignee");
    }

    ///////////////////////////////////////////////////////////////////////////
    /// IssueCollectionConfiguration
    ///////////////////////////////////////////////////////////////////////////
    @Override
    public boolean isOnlyCurrentVersion() {
        return onlyCurrentVersionByAssignee;
    }

    @Override
    public int getMaxEntries() {
        return maxEntriesByAssignee;
    }

    ///////////////////////////////////////////////////////////////////////////
    /// AbstractIssuesReport
    ///////////////////////////////////////////////////////////////////////////
    @Override
    protected String getColumnNames() {
        return columnNamesByAssignee;
    }

    @Override
    protected Map<String, String> getFilters() {
        return filtersByAssignee;
    }
}
