/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jredmine.plugin;

import java.net.URL;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.IssueManagement;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.nuiton.io.rest.RestClientConfiguration;
import org.nuiton.jredmine.RedmineService;
import org.nuiton.jredmine.RedmineServiceException;
import org.nuiton.jredmine.RedmineServiceImplementor;
import org.nuiton.jredmine.model.ModelHelper;
import org.nuiton.jredmine.model.Project;
import org.nuiton.jredmine.model.User;
import org.nuiton.jredmine.model.Version;
import org.nuiton.plugin.AbstractPlugin;

public abstract class AbstractRedmineMojo
extends AbstractPlugin
implements RestClientConfiguration {
    public static final String REDMINE_SYSTEM = "redmine";
    protected MavenProject project;
    protected URL url;
    protected String username;
    protected String password;
    protected String encoding;
    protected String projectId;
    protected String versionId;
    protected boolean verbose;
    protected boolean safe;
    protected MavenSession session;
    protected RedmineService service;
    private final boolean requireProject;
    private final boolean requireVersion;
    private final boolean requireUser;
    protected Project releaseProject;
    protected Version releaseVersion;
    protected User releaseUser;
    protected User[] users;
    protected DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
    protected boolean runOnceDone;
    protected boolean serviceInit;
    protected boolean initOk = true;
    private boolean anonymous;

    public AbstractRedmineMojo(boolean requireProject, boolean requireVersion, boolean requireUser) {
        this.requireProject = requireProject;
        this.requireVersion = requireVersion;
        this.requireUser = requireUser;
        this.anonymous = false;
    }

    protected void init() throws Exception {
        boolean r;
        IssueManagement issueManagement = this.project.getIssueManagement();
        if (issueManagement == null) {
            throw new MojoExecutionException("No Issue Management set.");
        }
        if (issueManagement.getUrl() == null || issueManagement.getUrl().trim().equals("")) {
            throw new MojoExecutionException("No URL set in Issue Management.");
        }
        if (issueManagement.getSystem() != null && !issueManagement.getSystem().equalsIgnoreCase(REDMINE_SYSTEM)) {
            throw new MojoExecutionException("Redmine's Plugin only supports 'redmine' Issue Management system.");
        }
        URL url = this.getRestUrl();
        if (url == null || url.toString().isEmpty()) {
            url = new URL(issueManagement.getUrl());
            if (this.verbose) {
                this.getLog().info((CharSequence)("use the url from issue management : " + url));
            }
        }
        this.setRestUrl(url);
        if (this.verbose) {
            this.getLog().info((CharSequence)("Redmine configuration :\n>> host     : " + this.getRestUrl() + "\n>> username : " + this.getRestUsername()));
        }
        try {
            ((RedmineServiceImplementor)this.service).init((RestClientConfiguration)this);
            this.serviceInit = true;
        }
        catch (Exception e) {
            if (this.safe) {
                throw e;
            }
            this.serviceInit = false;
            this.initOk = false;
            this.getLog().error((CharSequence)("could not init Redmine service [" + this.getRestUrl() + "] with user '" + this.getRestUsername() + "'"), (Throwable)e);
        }
        if (this.requireProject && !(r = this.initReleaseProject())) {
            if (this.safe) {
                throw new MojoExecutionException("the project '" + this.projectId + "' could not be retrieve from redmine server.");
            }
            this.initOk = false;
            return;
        }
        if (this.requireUser && !(r = this.initReleaseUser())) {
            if (this.safe) {
                throw new MojoExecutionException("the user '" + this.username + "' could not be retrieve from redmine server.");
            }
            this.initOk = false;
            return;
        }
        if (this.requireVersion && !(r = this.initReleaseVersion())) {
            if (this.safe) {
                throw new MojoExecutionException("the version '" + this.versionId + "' could not be retrieve from redmine server.");
            }
            this.initOk = false;
        }
    }

    protected boolean checkSkip() {
        if (this.isGoalSkip()) {
            this.getLog().warn((CharSequence)"The goal is skip due to the skipGoal flag on");
            return false;
        }
        if (this.isRunOnce() && this.isRunOnceDone()) {
            this.getLog().info((CharSequence)"skip goal, runOnce flag is on, and was already executed.");
            return false;
        }
        if (!this.serviceInit) {
            this.getLog().error((CharSequence)("could not init Redmine service [" + this.getRestUrl() + "] with user '" + this.getRestUsername() + "'"));
            return false;
        }
        if (this.requireProject && this.releaseProject == null) {
            this.getLog().error((CharSequence)("the project '" + this.projectId + "' could not be retrieve from redmine server, goal is skip"));
            return false;
        }
        if (this.requireUser && this.releaseUser == null) {
            this.getLog().error((CharSequence)("the user '" + this.username + "' could not be retrieve from redmine server, goal is skip"));
            return false;
        }
        if (this.requireVersion && this.releaseVersion == null) {
            this.getLog().error((CharSequence)("the version '" + this.versionId + "' could not be retrieve from redmine server, goal is skip"));
            return false;
        }
        return true;
    }

    protected void afterExecute() {
        this.closeService();
    }

    protected abstract void doAction() throws Exception;

    protected abstract boolean isGoalSkip();

    protected abstract boolean isRunOnce();

    protected abstract boolean checkRunOnceDone();

    public MavenProject getProject() {
        return this.project;
    }

    public void setProject(MavenProject project) {
        this.project = project;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public String getRestPassword() {
        return this.password;
    }

    public URL getRestUrl() {
        return this.url;
    }

    public String getRestUsername() {
        return this.username;
    }

    public void setRestPassword(String restPassword) {
        this.password = restPassword;
    }

    public void setRestUrl(URL restUrl) {
        this.url = restUrl;
    }

    public void setRestUsername(String restUsername) {
        this.username = restUsername;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public boolean isAnonymous() {
        return this.anonymous;
    }

    public void setAnonymous(boolean anonymous) {
        this.anonymous = true;
    }

    protected boolean initReleaseProject() throws MojoExecutionException {
        if (this.projectId == null || this.projectId.trim().isEmpty()) {
            throw new MojoExecutionException("required a projectId parameter");
        }
        try {
            Project p = this.service.getProject(this.projectId);
            if (p == null) {
                return false;
            }
            this.releaseProject = p;
            return true;
        }
        catch (RedmineServiceException e) {
            if (this.verbose) {
                this.getLog().error((Throwable)e);
            }
            return false;
        }
    }

    protected boolean initReleaseVersion() throws MojoExecutionException {
        if (this.versionId == null || this.versionId.trim().isEmpty()) {
            throw new MojoExecutionException("required a versionId parameter");
        }
        try {
            Version v = this.service.getVersion(this.projectId, this.versionId);
            if (v == null) {
                return false;
            }
            this.releaseVersion = v;
            return true;
        }
        catch (RedmineServiceException e) {
            if (this.verbose) {
                this.getLog().error((Throwable)e);
            }
            return false;
        }
    }

    protected boolean initReleaseUser() {
        try {
            this.users = this.service.getProjectMembers(this.projectId);
            User user = ModelHelper.byLogin((String)this.username, (User[])this.users);
            if (user == null) {
                return false;
            }
            this.releaseUser = user;
            return true;
        }
        catch (RedmineServiceException e) {
            if (this.verbose) {
                this.getLog().error((Throwable)e);
            }
            return false;
        }
    }

    protected void closeService() {
        RedmineServiceImplementor i;
        if (this.service != null && (i = (RedmineServiceImplementor)this.service).isInit()) {
            try {
                if (this.verbose) {
                    this.getLog().info((CharSequence)"<<< Close redmine rest client...");
                }
                i.destroy();
            }
            catch (Exception ex) {
                this.getLog().error((CharSequence)("could not close redmine client for reason " + ex.getMessage()), (Throwable)ex);
            }
        }
    }

    public boolean isRunOnceDone() {
        return this.runOnceDone;
    }

    public boolean isSafe() {
        return this.safe;
    }

    public void setSafe(boolean safe) {
        this.safe = safe;
    }

    public String getProjectId() {
        return this.projectId;
    }

    public String getVersionId() {
        return this.versionId;
    }
}

