/*
 * #%L
 * JRedmine :: Maven plugin
 * 
 * $Id: GenerateEmailAnnouncementMojo.java 186 2011-05-20 12:32:08Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/jredmine/tags/jredmine-1.3/jredmine-maven-plugin/src/main/java/org/nuiton/jredmine/plugin/announcement/GenerateEmailAnnouncementMojo.java $
 * %%
 * Copyright (C) 2009 - 2010 Tony Chemit, CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package org.nuiton.jredmine.plugin.announcement;

/**
 * Generate the content of the release email announcement.
 *
 * @author tchemit
 * @goal generate-email-announcement
 * @since 1.0.0
 */
public class GenerateEmailAnnouncementMojo extends AbstractAnnouncementMojo {

    /**
     * The Velocity template used to format the release email announcement.
     *
     * @parameter expression="${redmine.emailAnnouncementTemplate}" default-value="release-email-announcement.vm"
     * @required
     * @since 1.0.0
     */
    protected String emailAnnouncementTemplate;

    /**
     * A flag to enable or disable the goal.
     *
     * @parameter expression="${changes.skipGenerateEmailAnnouncement}" default-value="false"
     * @since 1.0.0
     */
    protected boolean skipGenerateEmailAnnouncement;

    @Override
    protected String getAnnouncementTemplate() {
        return emailAnnouncementTemplate;
    }

    @Override
    protected boolean isGoalSkip() {
        return skipGenerateEmailAnnouncement;
    }
}
