/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jredmine.client;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class RedmineRequest<T> {
    protected final Method method;
    protected final Class<T> type;
    protected final List<String> path;
    protected final Map<String, String> params;
    protected final Map<String, File> attachments;

    public static <T> RedmineRequest<T> get(Class<T> type, String ... path) {
        return RedmineRequest.on(Method.GET, type, path);
    }

    public static <T> RedmineRequest<T> put(Class<T> type, String ... path) {
        return RedmineRequest.on(Method.PUT, type, path);
    }

    public static <T> RedmineRequest<T> delete(Class<T> type, String ... path) {
        return RedmineRequest.on(Method.DELETE, type, path);
    }

    public static <T> RedmineRequest<T> post(Class<T> type, String ... path) {
        return RedmineRequest.on(Method.POST, type, path);
    }

    public static <T> RedmineRequest<T> head(Class<T> type, String ... path) {
        return RedmineRequest.on(Method.HEAD, type, path);
    }

    public static <T> RedmineRequest<T> option(Class<T> type, String ... path) {
        return RedmineRequest.on(Method.OPTION, type, path);
    }

    public static <T> RedmineRequest<T> on(Method method, Class<T> type, String ... path) {
        RedmineRequest<T> result = new RedmineRequest<T>(method, type);
        result.path(path);
        return result;
    }

    public RedmineRequest(Method method, Class<T> type) {
        this.method = method;
        this.type = type;
        this.params = Maps.newHashMap();
        this.attachments = Maps.newHashMap();
        this.path = Lists.newArrayList();
    }

    public RedmineRequest<T> path(String ... path) {
        Collections.addAll(this.path, path);
        return this;
    }

    public RedmineRequest<T> parameter(String name, String value) {
        this.params.put(name, value);
        return this;
    }

    public RedmineRequest<T> attachment(String name, File value) {
        this.attachments.put(name, value);
        return this;
    }

    public String[] getPath() {
        return this.path.toArray(new String[this.path.size()]);
    }

    public Method getMethod() {
        return this.method;
    }

    public Map<String, String> getParams() {
        return this.params;
    }

    public Map<String, File> getAttachments() {
        return this.attachments;
    }

    public Class<T> getType() {
        return this.type;
    }

    public String toPath(String uri) {
        String result = uri + "/" + Joiner.on((char)'/').join((Object[])this.getPath());
        return result;
    }

    public static enum Method {
        GET,
        PUT,
        POST,
        DELETE,
        HEAD,
        OPTION;

    }
}

