/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jredmine.service;

import com.google.common.base.Strings;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.jredmine.client.RedmineRequest;
import org.nuiton.jredmine.client.RedmineRequestHelper;
import org.nuiton.jredmine.model.Attachment;
import org.nuiton.jredmine.model.Issue;
import org.nuiton.jredmine.model.IssueCategory;
import org.nuiton.jredmine.model.IssuePriority;
import org.nuiton.jredmine.model.IssueStatus;
import org.nuiton.jredmine.model.News;
import org.nuiton.jredmine.model.Project;
import org.nuiton.jredmine.model.TimeEntry;
import org.nuiton.jredmine.model.Tracker;
import org.nuiton.jredmine.model.User;
import org.nuiton.jredmine.model.Version;
import org.nuiton.jredmine.model.VersionStatusEnum;
import org.nuiton.jredmine.service.AbstractRedmineService;
import org.nuiton.jredmine.service.DefaultRedmineAnonymousService;
import org.nuiton.jredmine.service.RedmineAnonymousService;
import org.nuiton.jredmine.service.RedmineConfigurationUtil;
import org.nuiton.jredmine.service.RedmineService;
import org.nuiton.jredmine.service.RedmineServiceConfiguration;
import org.nuiton.jredmine.service.RedmineServiceException;

public class DefaultRedmineService
extends AbstractRedmineService
implements RedmineService {
    private static final Log log = LogFactory.getLog(DefaultRedmineService.class);
    protected final RedmineAnonymousService anonymousService;
    protected final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");

    public DefaultRedmineService() {
        this.anonymousService = new DefaultRedmineAnonymousService();
    }

    @Override
    public void init(RedmineServiceConfiguration configuration) throws RedmineServiceException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("init service with configuration: " + configuration));
        }
        if (!this.isInit()) {
            RedmineServiceConfiguration serviceConfiguration = RedmineConfigurationUtil.cloneConfiguration(configuration);
            super.init(serviceConfiguration);
            this.anonymousService.init(configuration);
        }
    }

    @Override
    public IssueStatus[] getIssueStatuses() throws RedmineServiceException {
        IssueStatus[] result = this.anonymousService.getIssueStatuses();
        return result;
    }

    @Override
    public IssuePriority[] getIssuePriorities() throws RedmineServiceException {
        IssuePriority[] result = this.anonymousService.getIssuePriorities();
        return result;
    }

    @Override
    public Project[] getProjects() throws RedmineServiceException {
        Project[] result = this.anonymousService.getProjects();
        return result;
    }

    @Override
    public IssueCategory[] getIssueCategories(String projectName) throws RedmineServiceException {
        IssueCategory[] result = this.anonymousService.getIssueCategories(projectName);
        return result;
    }

    @Override
    public Project getProject(String projectName) throws RedmineServiceException {
        Project result = this.anonymousService.getProject(projectName);
        return result;
    }

    @Override
    public Tracker[] getTrackers(String projectName) throws RedmineServiceException {
        Tracker[] result = this.anonymousService.getTrackers(projectName);
        return result;
    }

    @Override
    public News[] getNews(String projectName) throws RedmineServiceException {
        News[] result = this.anonymousService.getNews(projectName);
        return result;
    }

    @Override
    public User[] getProjectMembers(String projectName) throws RedmineServiceException {
        User[] result = this.anonymousService.getProjectMembers(projectName);
        return result;
    }

    @Override
    public Version[] getVersions(String projectName) throws RedmineServiceException {
        Version[] result = this.anonymousService.getVersions(projectName);
        return result;
    }

    @Override
    public Version getVersion(String projectName, String versionName) throws RedmineServiceException {
        Version result = this.anonymousService.getVersion(projectName, versionName);
        return result;
    }

    @Override
    public Attachment[] getAttachments(String projectName, String versionName) throws RedmineServiceException {
        Attachment[] result = this.anonymousService.getAttachments(projectName, versionName);
        return result;
    }

    @Override
    public Issue[] getIssues(String projectName, String versionName) throws RedmineServiceException {
        Issue[] result = this.anonymousService.getIssues(projectName, versionName);
        return result;
    }

    @Override
    public TimeEntry[] getIssueTimeEntries(String projectName, String issueId) throws RedmineServiceException {
        TimeEntry[] result = this.anonymousService.getIssueTimeEntries(projectName, issueId);
        return result;
    }

    @Override
    public Issue[] getIssues(String projectName) throws RedmineServiceException {
        Issue[] result = this.anonymousService.getIssues(projectName);
        return result;
    }

    @Override
    public Issue[] getOpenedIssues(String projectName) throws RedmineServiceException {
        Issue[] result = this.anonymousService.getOpenedIssues(projectName);
        return result;
    }

    @Override
    public Issue[] getClosedIssues(String projectName) throws RedmineServiceException {
        Issue[] result = this.anonymousService.getClosedIssues(projectName);
        return result;
    }

    @Override
    public Project[] getUserProjects() throws RedmineServiceException {
        this.checkLoggued();
        RedmineRequest<Project> request = RedmineRequestHelper.action("get_user_projects.xml", Project.class);
        Project[] result = this.executeRequestAndReturnDatas(request);
        return result;
    }

    @Override
    public Version addVersion(String projectName, Version version) throws RedmineServiceException {
        this.checkLoggued();
        RedmineRequest<Version> request = RedmineRequestHelper.postWithProject("add_version.xml", Version.class, projectName);
        String date = this.getVersionEffectiveDate(version);
        String status = this.getVersionStatus(version);
        request.parameter("version[name]", version.getName());
        request.parameter("version[description]", version.getDescription());
        request.parameter("version[effective_date]", date);
        request.parameter("version[status]", status);
        Version result = this.executeRequestAndReturnData(request);
        return result;
    }

    @Override
    public Version updateVersion(String projectName, Version version) throws RedmineServiceException {
        this.checkLoggued();
        RedmineRequest<Version> request = RedmineRequestHelper.postWithProject("update_version.xml", Version.class, projectName);
        String date = this.getVersionEffectiveDate(version);
        String status = this.getVersionStatus(version);
        request.parameter("version[name]", version.getName());
        request.parameter("version[description]", version.getDescription());
        request.parameter("version[effective_date]", date);
        request.parameter("version[status]", status);
        Version result = this.executeRequestAndReturnData(request);
        return result;
    }

    @Override
    public Version nextVersion(String projectName, String oldVersionName, Version version) throws RedmineServiceException {
        this.checkLoggued();
        RedmineRequest<Version> request = RedmineRequestHelper.postWithProject("next_version.xml", Version.class, projectName);
        String date = this.getVersionEffectiveDate(version);
        String status = this.getVersionStatus(version);
        request.parameter("oldVersionName", oldVersionName);
        request.parameter("version[name]", version.getName());
        request.parameter("version[description]", version.getDescription());
        request.parameter("version[effective_date]", date);
        request.parameter("version[status]", status);
        Version result = this.executeRequestAndReturnData(request);
        return result;
    }

    @Override
    public Attachment addAttachment(String projectName, String versionName, Attachment attachment) throws RedmineServiceException {
        this.checkLoggued();
        RedmineRequest<Attachment> request = RedmineRequestHelper.postWithProjectAndVersion("add_version_attachment.xml", Attachment.class, projectName, versionName);
        request.parameter("attachment[description]", attachment.getDescription());
        request.attachment("attachment[file]", attachment.getToUpload());
        Attachment result = this.executeRequestAndReturnData(request);
        return result;
    }

    @Override
    public News addNews(String projectName, News news) throws RedmineServiceException {
        this.checkLoggued();
        RedmineRequest<News> request = RedmineRequestHelper.postWithProject("add_news.xml", News.class, projectName);
        request.parameter("news[title]", news.getTitle());
        request.parameter("news[summary]", news.getSummary());
        request.parameter("news[description]", news.getDescription());
        News result = this.executeRequestAndReturnData(request);
        return result;
    }

    @Override
    public TimeEntry addIssueTimeEntry(String projectName, String issueId, TimeEntry timeEntry) throws RedmineServiceException {
        this.checkLoggued();
        RedmineRequest<TimeEntry> request = RedmineRequestHelper.postWithProjectAndIssue("add_issue_time.xml", TimeEntry.class, projectName, issueId);
        Date d = timeEntry.getSpentOn();
        if (d == null) {
            d = new Date();
        }
        String date = this.DATE_FORMAT.format(d);
        request.parameter("time_entry[activity_id]", timeEntry.getActivityId() + "");
        request.parameter("time_entry[spent_on]", date);
        request.parameter("time_entry[hours]", timeEntry.getHours() + "");
        request.parameter("time_entry[comments]", timeEntry.getComments() == null ? "" : timeEntry.getComments());
        TimeEntry result = this.executeRequestAndReturnData(request);
        return result;
    }

    protected String getVersionStatus(Version version) {
        String status = version.getStatus();
        if (Strings.isNullOrEmpty((String)status)) {
            status = VersionStatusEnum.open.name();
        }
        return status;
    }

    protected String getVersionEffectiveDate(Version version) {
        return version.getEffectiveDate() == null ? "" : this.DATE_FORMAT.format(version.getEffectiveDate());
    }
}

