/*
 * #%L
 * JRedmine :: Client
 * 
 * $Id: AbstractRedmineServiceTest.java 211 2011-06-04 17:01:31Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/jredmine/tags/jredmine-1.2.2/jredmine-client/src/test/java/org/nuiton/jredmine/AbstractRedmineServiceTest.java $
 * %%
 * Copyright (C) 2009 - 2010 Tony Chemit, CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package org.nuiton.jredmine;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.nuiton.io.rest.RestClientConfiguration;
import org.nuiton.jredmine.model.Attachment;
import org.nuiton.jredmine.model.Issue;
import org.nuiton.jredmine.model.IssueCategory;
import org.nuiton.jredmine.model.IssuePriority;
import org.nuiton.jredmine.model.IssueStatus;
import org.nuiton.jredmine.model.News;
import org.nuiton.jredmine.model.Project;
import org.nuiton.jredmine.model.TimeEntry;
import org.nuiton.jredmine.model.Tracker;
import org.nuiton.jredmine.model.User;
import org.nuiton.jredmine.model.Version;
import org.nuiton.jredmine.rest.RedmineRestClient;

import static org.nuiton.jredmine.TestHelper.getTestConfiguration;

/**
 * Created: 2 janv. 2010
 *
 * @author tchemit <chemit@codelutin.com>
 */
public abstract class AbstractRedmineServiceTest<S extends RedmineAnonymousService> implements RedmineTestContract {

    /** Logger. */
    private static final Log log = LogFactory.getLog(AbstractRedmineServiceTest.class);

    /** shared rest client (open only one session for all the test). */
    static RedmineRestClient client;

    /** service to test. */
    private S service;

    protected Project[] projects;

    protected Project project;

    protected Version[] versions;

    protected Version version;

    protected User[] users;

    protected Issue[] issues;

    protected IssuePriority[] issuePriorities;

    protected IssueStatus[] issueStatuses;

    protected IssueCategory[] issueCategories;

    protected Tracker[] trackers;

    protected News newz;

    protected News[] news;

    protected Attachment attachment;

    protected Attachment[] attachments;

    protected TimeEntry timeEntry;

    protected TimeEntry[] timeEntries;

    private final Class<S> serviceType;

    public AbstractRedmineServiceTest(Class<S> serviceType) {
        this.serviceType = serviceType;
    }

    protected S getService() {
        return service;
    }

    @BeforeClass
    public static void setUpClass() throws Exception {
        // make sure client is null before starting the test

        client = null;
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
        if (client != null) {
            client.close();
            client = null;
        }
    }

    protected final S newService() throws Exception {
        return serviceType.newInstance();
    }

    protected RedmineRestClient newClient(RestClientConfiguration configuration) {
        RedmineRestClient client;
        try {
            client = new RedmineRestClient(configuration);

            client.open();
        } catch (Exception e) {

            // could not log
            if (log.isErrorEnabled()) {
                log.error("can not connect to server " + configuration.getRestUrl() + ", will skip test " + DefaultRedmineServiceTest.class.getName());
            }
//            System.out.println("can not connect to server " + configuration.getRestUrl() + ", will skip test " + DefaultRedmineServiceTest.class.getName());
            client = null;
        }
        return client;
    }

    @Before
    public void setUp() throws Exception {

        if (client == null) {

            RestClientConfiguration configuration = getTestConfiguration();
            try {
                client = newClient(configuration);
            } finally {
                Assume.assumeTrue(client != null && client.isOpen());
            }
        }

        service = newService();

        ((RedmineServiceImplementor) service).init(client);
    }

    @After
    public void tearDown() throws Exception {
        service = null;
        project = null;
        projects = null;
        version = null;
        versions = null;
        users = null;
        issues = null;
        issueCategories = null;
        issuePriorities = null;
        issueStatuses = null;
        trackers = null;
        newz = null;
        news = null;
        attachment = null;
        attachments = null;
        timeEntry = null;
        timeEntries = null;
    }


    @Test
    public void isInit() throws Exception {

        Assert.assertFalse(((RedmineServiceImplementor) newService()).isInit());
    }

    @Test
    @Override
    public void getProjects() throws Exception {
        projects = getService().getProjects();
    }

    @Test
    @Override
    public void getIssuePriorities() throws Exception {
        issuePriorities = getService().getIssuePriorities();
    }

    @Test
    @Override
    public void getIssueStatuses() throws Exception {
        issueStatuses = getService().getIssueStatuses();
    }

    @Test
    @Override
    public void getProject() throws Exception {
        project = getService().getProject(PROJECT_NAME);
    }

    @Test
    @Override
    public void getIssueCategories() throws Exception {
        issueCategories = getService().getIssueCategories(PROJECT_NAME);
    }

    @Test
    @Override
    public void getTrackers() throws Exception {
        trackers = getService().getTrackers(PROJECT_NAME);
    }

    @Test
    @Override
    public void getNews() throws Exception {
        news = getService().getNews(PROJECT_NAME);
    }

    @Test
    @Override
    public void getProjectMembers() throws Exception {
        users = getService().getProjectMembers(PROJECT_NAME);
    }

    @Test
    @Override
    public void getProjectIssues() throws Exception {
        issues = getService().getIssues(PROJECT_NAME);
    }

    @Test
    @Override
    public void getVersions() throws Exception {
        versions = getService().getVersions(PROJECT_NAME);
    }

    @Test
    @Override
    public void getVersion() throws Exception {
        version = getService().getVersion(PROJECT_NAME, VERSION_NAME);
    }

    @Test
    @Override
    public void getVersionIssues() throws Exception {
        issues = getService().getIssues(PROJECT_NAME, VERSION_NAME);
    }

    @Test
    @Override
    public void getOpenedIssues() throws Exception {
        issues = getService().getOpenedIssues(PROJECT_NAME);
    }

    @Test
    @Override
    public void getClosedIssues() throws Exception {
        issues = getService().getClosedIssues(PROJECT_NAME);
    }

    @Test
    @Override
    public void getIssueTimeEntries() throws Exception {
        timeEntries = getService().getIssueTimeEntries(PROJECT_NAME, ISSUE_ID);
    }

    @Test
    @Override
    public void getAttachments() throws Exception {
        attachments = getService().getAttachments(PROJECT_NAME, VERSION_NAME);
    }
}
