/*
 * #%L
 * JRedmine :: Client
 * 
 * $Id: DefaultRequestBuilder.java 211 2011-06-04 17:01:31Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/jredmine/tags/jredmine-1.2.2/jredmine-client/src/main/java/org/nuiton/jredmine/rest/DefaultRequestBuilder.java $
 * %%
 * Copyright (C) 2009 - 2010 Tony Chemit, CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package org.nuiton.jredmine.rest;

import org.nuiton.io.rest.RestRequest;
import org.nuiton.io.rest.RestRequestBuilder;

import java.io.File;
import java.util.Map;

/**
 * Default {@link RestRequestBuilder} to be used in {@link RedmineRestClient}.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.0.0
 */
public class DefaultRequestBuilder implements RestRequestBuilder {

    public static final String CONTEXT_PATH = "jredmine";

    public static final String[] EMPTY_STRING_ARRAY = new String[0];

    protected String name;

    protected String action;

    public DefaultRequestBuilder(String name, String action) {
        this.name = name;
        this.action = action;
    }

    @Override
    public String getName() {
        return name;
    }

    /**
     * @param args the args of the request
     * @return TODO
     */
    public String[] getParameters(Object... args) {
        // by default, no parameter
        return EMPTY_STRING_ARRAY;
    }

    public String[] getPath(Object... args) {
        // by default, path is contextPath / action
        return new String[]{CONTEXT_PATH, action};
    }

    public Map<String, File> getAttachments(Object... args) {
        // by default, no attachments
        return null;
    }

    @Override
    public RestRequest create(final Object... args) {

        return new RestRequest() {

            @Override
            public String[] getPath() {
                return DefaultRequestBuilder.this.getPath(args);
            }

            @Override
            public String[] getParameters() {
                return DefaultRequestBuilder.this.getParameters(args);
            }

            @Override
            public Map<String, File> getAttachments() {
                return DefaultRequestBuilder.this.getAttachments(args);
            }
        };
    }
}
