/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jpa.templates;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.eugene.AbstractMetaTransformer;
import org.nuiton.eugene.models.object.ObjectModel;
import org.nuiton.eugene.models.object.ObjectModelClass;
import org.nuiton.eugene.models.object.validator.AttributeNamesValidator;
import org.nuiton.eugene.models.object.validator.ClassNamesValidator;
import org.nuiton.eugene.models.object.validator.ObjectModelValidator;
import org.nuiton.jpa.templates.JpaDaoTransformer;
import org.nuiton.jpa.templates.JpaEntityTransformer;
import org.nuiton.jpa.templates.JpaModelValidator;
import org.nuiton.jpa.templates.JpaPersistenceContextTransformer;
import org.nuiton.jpa.templates.JpaTemplatesGeneratorUtil;

public class JpaMetaTransformer
extends AbstractMetaTransformer<ObjectModel> {
    private static final Log log = LogFactory.getLog(JpaMetaTransformer.class);

    public JpaMetaTransformer() {
        this.setTemplateTypes(new Class[]{JpaEntityTransformer.class, JpaDaoTransformer.class, JpaPersistenceContextTransformer.class});
    }

    protected boolean validateModel(ObjectModel model) {
        ArrayList<Object> validators = new ArrayList<Object>();
        AttributeNamesValidator attrValidator = new AttributeNamesValidator(model);
        attrValidator.addNameAndReason("next", "Le nom d'attribut \"next\" est incompatible avec HSQL");
        attrValidator.addNameAndReason("value", "Le nom d'attribut \"value\" est incompatible avec certains SGBD");
        attrValidator.addNameAndReason("values", "Le nom d'attribut \"values\" est incompatible avec certains SGBD");
        attrValidator.addNameAndReason("begin", "Le nom d'attribut \"begin\" est incompatible avec certains SGBD");
        attrValidator.addNameAndReason("end", "Le nom d'attribut \"end\" est incompatible avec certains SGBD");
        attrValidator.addNameAndReason("authorization", "Le nom d'attribut \"authorization\" est incompatible avec certains SGBD");
        attrValidator.addNameAndReason("order", "Le nom d'attribut \"order\" est incompatible avec certains SGBD");
        validators.add(attrValidator);
        ClassNamesValidator classValidator = new ClassNamesValidator(model);
        classValidator.addNameAndReason("constraint", "Nom de classe incompatible avec certains SGBD");
        classValidator.addNameAndReason("user", "Nom de classe incompatible avec certains SGBD");
        validators.add(classValidator);
        validators.add((Object)new JpaModelValidator(model));
        for (ObjectModelValidator objectModelValidator : validators) {
            if (objectModelValidator.validate()) continue;
            for (String error : objectModelValidator.getErrors()) {
                if (!log.isWarnEnabled()) continue;
                log.warn((Object)("[VALIDATION] " + error));
            }
        }
        List<ObjectModelClass> classes = JpaTemplatesGeneratorUtil.getEntityClasses(model, true);
        if (classes.isEmpty()) {
            if (log.isWarnEnabled()) {
                log.warn((Object)("No entity to generate, " + ((Object)((Object)this)).getClass().getName() + " is skipped"));
            }
            return false;
        }
        return true;
    }
}

