/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jpa.templates;

import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.eugene.GeneratorUtil;
import org.nuiton.eugene.models.object.ObjectModel;
import org.nuiton.eugene.models.object.ObjectModelAttribute;
import org.nuiton.eugene.models.object.ObjectModelClass;
import org.nuiton.eugene.models.object.ObjectModelClassifier;
import org.nuiton.eugene.models.object.ObjectModelElement;
import org.nuiton.eugene.models.object.ObjectModelJavaModifier;
import org.nuiton.eugene.models.object.ObjectModelModifier;
import org.nuiton.eugene.models.object.ObjectModelOperation;
import org.nuiton.jpa.api.AbstractJpaDao;
import org.nuiton.jpa.templates.AbstractJpaTransformer;
import org.nuiton.jpa.templates.JpaTemplatesGeneratorUtil;

public class JpaDaoTransformer
extends AbstractJpaTransformer {
    private static final Log log = LogFactory.getLog(JpaDaoTransformer.class);

    public void transformFromClass(ObjectModelClass input) {
        boolean generateConcrete;
        String packageName = JpaTemplatesGeneratorUtil.getDaoPackage(this, (ObjectModel)this.model, (ObjectModelClassifier)input);
        String abstractDaoName = JpaTemplatesGeneratorUtil.getDaoAbstractName(input);
        String concreteDaoName = JpaTemplatesGeneratorUtil.getDaoConcreteName(input);
        String concreteEntityQualifiedName = JpaTemplatesGeneratorUtil.getConcreteEntityQualifiedName(this, (ObjectModel)this.model, input);
        boolean generateAbstract = !this.isInClassPath(packageName, abstractDaoName);
        boolean bl = generateConcrete = !this.isInClassPath(packageName, concreteDaoName);
        if (generateAbstract) {
            this.generateAbstract(input, packageName, abstractDaoName, concreteEntityQualifiedName);
        }
        if (generateConcrete) {
            this.generateImpl(input, packageName, abstractDaoName, concreteDaoName, concreteEntityQualifiedName);
        }
    }

    protected ObjectModelClass generateAbstract(ObjectModelClass input, String packageName, String abstractDaoName, String concreteEntityQualifiedName) {
        String superClass;
        String prefix = this.getConstantPrefix((ObjectModelClassifier)input, "PROPERTY_");
        this.setConstantPrefix(prefix);
        String entityName = input.getName();
        ObjectModelClass output = this.createAbstractClass(abstractDaoName, packageName);
        this.addImport((ObjectModelClassifier)output, concreteEntityQualifiedName);
        boolean superClassIsEntity = this.isSuperClassEntity(input);
        if (superClassIsEntity) {
            ObjectModelClass superClassModel = (ObjectModelClass)input.getSuperclasses().iterator().next();
            superClass = JpaTemplatesGeneratorUtil.getDaoPackage(this, (ObjectModel)this.model, (ObjectModelClassifier)superClassModel) + "." + JpaTemplatesGeneratorUtil.getDaoConcreteName(superClassModel);
        } else {
            superClass = JpaTemplatesGeneratorUtil.getDaoSuperClassTagValue((ObjectModel)this.model, (ObjectModelClassifier)input);
            if (superClass == null) {
                superClass = AbstractJpaDao.class.getName() + "<" + entityName + ">";
                this.addImport((ObjectModelClassifier)output, superClass);
            }
        }
        this.setSuperClass(output, superClass);
        this.addConstructorWithEntityManager(output);
        String daoContractName = packageName + "." + entityName + "Dao";
        boolean addUserDaoContract = this.isInClassPath(daoContractName);
        if (addUserDaoContract) {
            this.addInterface((ObjectModelClassifier)output, daoContractName);
        }
        ObjectModelOperation operation = this.addOperation((ObjectModelClassifier)output, "getEntityClass", "Class<" + entityName + ">", new ObjectModelModifier[]{ObjectModelJavaModifier.PROTECTED});
        this.addAnnotation((ObjectModelClassifier)output, (ObjectModelElement)operation, Override.class);
        this.setOperationBody(operation, "\n        return " + entityName + ".class;\n" + "    ");
        Collection attributes = input.getAttributes();
        if (CollectionUtils.isNotEmpty((Collection)attributes)) {
            this.addImport((ObjectModelClassifier)output, List.class);
        }
        for (ObjectModelAttribute attr : attributes) {
            if (!attr.isNavigable()) continue;
            if (!GeneratorUtil.isNMultiplicity((ObjectModelAttribute)attr)) {
                this.generateNoNMultiplicity(entityName, output, attr, false);
                continue;
            }
            this.generateNMultiplicity(entityName, output, attr);
        }
        if (this.isVerbose()) {
            log.info((Object)("will generate " + output.getQualifiedName()));
        }
        return output;
    }

    protected ObjectModelClass generateImpl(ObjectModelClass input, String packageName, String abstractDaoName, String concreteDaoName, String concreteEntityQualifiedName) {
        ObjectModelClass output = this.createClass(concreteDaoName, packageName);
        this.setSuperClass(output, packageName + '.' + abstractDaoName);
        this.addConstructorWithEntityManager(output);
        if (this.isVerbose()) {
            log.info((Object)("will generate " + output.getQualifiedName()));
        }
        return output;
    }

    protected void generateNoNMultiplicity(String clazzName, ObjectModelClass result, ObjectModelAttribute attr, boolean isAssoc) {
        String attrName = attr.getName();
        String attrType = attr.getType();
        String propertyName = clazzName + "." + this.getConstantName(attrName);
        if (!isAssoc && attr.hasAssociationClass()) {
            String assocClassName = attr.getAssociationClass().getName();
            String assocAttrName = JpaTemplatesGeneratorUtil.getAssocAttrName((ObjectModelAttribute)attr);
            propertyName = clazzName + '.' + this.getConstantName(assocAttrName) + " + '.' + " + assocClassName + '.' + this.getConstantName(attrName);
        }
        ObjectModelOperation op = this.addOperation((ObjectModelClassifier)result, this.getJavaBeanMethodName("findBy", attrName), clazzName, new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
        this.addParameter(op, attrType, "v");
        this.setOperationBody(op, "\n        " + clazzName + " result = findByProperty(" + propertyName + ", v);\n" + "        return result;\n" + "    ");
        op = this.addOperation((ObjectModelClassifier)result, this.getJavaBeanMethodName("findAllBy", attrName), "List<" + clazzName + ">", new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
        this.addParameter(op, attrType, "v");
        this.setOperationBody(op, "\n        List<" + clazzName + "> result = findAllByProperty(" + propertyName + ", v);\n" + "        return result;\n" + "    ");
        if (!isAssoc && attr.hasAssociationClass()) {
            String assocClassName = attr.getAssociationClass().getName();
            String assocClassFQN = attr.getAssociationClass().getQualifiedName();
            String assocAttrName = GeneratorUtil.getAssocAttrName((ObjectModelAttribute)attr);
            String assocPropertyConstantName = this.getConstantName(assocAttrName);
            op = this.addOperation((ObjectModelClassifier)result, this.getJavaBeanMethodName("findBy", assocClassName), clazzName, new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
            this.addParameter(op, assocClassFQN, "value");
            this.setOperationBody(op, "\n        " + clazzName + " result = findByProperty(" + clazzName + "." + assocPropertyConstantName + ", value);\n" + "        return result;\n" + "    ");
            op = this.addOperation((ObjectModelClassifier)result, this.getJavaBeanMethodName("findAllBy", assocClassName), "List<" + clazzName + ">", new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
            this.addParameter(op, assocClassFQN, "value");
            this.setOperationBody(op, "\n        List<" + clazzName + "> result = findAllByProperty(" + clazzName + "." + assocPropertyConstantName + ", value);\n" + "        return result;\n" + "    ");
        }
    }

    protected void generateNMultiplicity(String clazzName, ObjectModelClass result, ObjectModelAttribute attr) {
        String attrName = attr.getName();
        String attrType = attr.getType();
        if (attr.hasAssociationClass()) {
            return;
        }
        ObjectModelOperation op = this.addOperation((ObjectModelClassifier)result, this.getJavaBeanMethodName("findContains", attrName), clazzName, new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
        this.addParameter(op, attrType, "v");
        this.setOperationBody(op, "\n        " + clazzName + " result = findContains(" + clazzName + "." + this.getConstantName(attrName) + ", v);\n" + "        return result;\n" + "    ");
        op = this.addOperation((ObjectModelClassifier)result, this.getJavaBeanMethodName("findAllContains", attrName), "List<" + clazzName + ">", new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
        this.addParameter(op, attrType, "v");
        this.setOperationBody(op, "\n        List<" + clazzName + "> result = findAllContains(" + clazzName + "." + this.getConstantName(attrName) + ", v);\n" + "        return result;\n" + "    ");
    }
}

