/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.widgets.select;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import javax.swing.ListModel;
import org.jdesktop.beans.AbstractSerializableBean;
import org.nuiton.jaxx.runtime.swing.model.JaxxDefaultListModel;
import org.nuiton.jaxx.runtime.swing.model.JaxxFilterableListModel;

public class BeanDoubleListModel<O>
extends AbstractSerializableBean {
    public static final String PROPERTY_ADD_ENABLED = "addEnabled";
    public static final String PROPERTY_REMOVE_ENABLED = "removeEnabled";
    public static final String PROPERTY_SELECTED_UP_ENABLED = "selectedUpEnabled";
    public static final String PROPERTY_SELECTED_DOWN_ENABLED = "selectedDownEnabled";
    public static final String PROPERTY_USE_MULTI_SELECT = "useMultiSelect";
    private static final long serialVersionUID = 1L;
    protected List<O> universe = new ArrayList<O>();
    protected final JaxxFilterableListModel<O> universeModel = new JaxxFilterableListModel();
    protected final List<O> selected = new ArrayList<O>();
    protected final JaxxDefaultListModel<O> selectedModel = new JaxxDefaultListModel();
    protected boolean addEnabled;
    protected boolean removeEnabled;
    protected boolean selectedUpEnabled;
    protected boolean selectedDownEnabled;
    protected boolean useMultiSelect;
    protected final Collection<Predicate<List<O>>> canRemoveItemsPredicates = new ArrayList<Predicate<List<O>>>();

    public List<O> getSelected() {
        return this.selected;
    }

    public void setSelected(List<O> selected) {
        this.resetUniverse();
        if (selected == null) {
            selected = Lists.newArrayList();
        }
        this.selected.clear();
        this.selectedModel.clear();
        this.addToSelected(selected);
    }

    public List<O> getUniverse() {
        return this.universe;
    }

    public void setUniverse(List<O> universe) {
        this.universe = universe == null ? Lists.newArrayList() : Lists.newArrayList(universe);
        this.resetUniverse();
    }

    protected void resetUniverse() {
        this.universeModel.setAllElements(this.universe);
    }

    public ListModel<O> getSelectedModel() {
        return this.selectedModel;
    }

    public JaxxFilterableListModel<O> getUniverseModel() {
        return this.universeModel;
    }

    public void addToSelected(O item) {
        this.selected.add(item);
        this.selectedModel.addElement(item);
        if (!this.useMultiSelect) {
            this.universeModel.removeElement(item);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToSelected(List<O> items) {
        this.selected.addAll(items);
        for (O item : items) {
            this.selectedModel.setValueIsAdjusting(true);
            this.universeModel.setValueIsAdjusting(true);
            try {
                this.selectedModel.addElement(item);
                if (this.useMultiSelect) continue;
                this.universeModel.removeElement(item);
            }
            finally {
                this.selectedModel.setValueIsAdjusting(false);
                this.universeModel.setValueIsAdjusting(false);
            }
        }
        this.selectedModel.refresh();
        this.universeModel.refresh();
    }

    public void removeFromSelected(O item) {
        this.selected.remove(item);
        this.selectedModel.removeElement(item);
        if (!this.useMultiSelect) {
            this.addToUniverseList(item);
        }
    }

    public void removeFromSelected(List<O> items) {
        this.selected.removeAll(items);
        for (O item : items) {
            this.selectedModel.removeElement(item);
            if (this.useMultiSelect) continue;
            this.addToUniverseList(item);
        }
    }

    public void moveUpSelected(O item) {
        int i = this.selected.indexOf(item);
        this.selected.remove(item);
        this.selectedModel.removeElement(item);
        this.selected.add(i - 1, item);
        this.selectedModel.insertElementAt(item, i - 1);
    }

    public void moveDownSelected(O item) {
        int i = this.selected.indexOf(item);
        this.selected.remove(item);
        this.selectedModel.removeElement(item);
        this.selected.add(i + 1, item);
        this.selectedModel.insertElementAt(item, i + 1);
    }

    public boolean isAddEnabled() {
        return this.addEnabled;
    }

    public void setAddEnabled(boolean addEnabled) {
        boolean oldValue = this.isAddEnabled();
        this.addEnabled = addEnabled;
        this.firePropertyChange(PROPERTY_ADD_ENABLED, oldValue, addEnabled);
    }

    public boolean isRemoveEnabled() {
        return this.removeEnabled;
    }

    public void setRemoveEnabled(boolean removeEnabled) {
        boolean oldValue = this.isRemoveEnabled();
        this.removeEnabled = removeEnabled;
        this.firePropertyChange(PROPERTY_REMOVE_ENABLED, oldValue, removeEnabled);
    }

    public boolean isSelectedUpEnabled() {
        return this.selectedUpEnabled;
    }

    public void setSelectedUpEnabled(boolean selectedUpEnabled) {
        boolean oldValue = this.isSelectedUpEnabled();
        this.selectedUpEnabled = selectedUpEnabled;
        this.firePropertyChange(PROPERTY_SELECTED_UP_ENABLED, oldValue, selectedUpEnabled);
    }

    public boolean isSelectedDownEnabled() {
        return this.selectedDownEnabled;
    }

    public void setSelectedDownEnabled(boolean selectedDownEnabled) {
        boolean oldValue = this.isSelectedDownEnabled();
        this.selectedDownEnabled = selectedDownEnabled;
        this.firePropertyChange(PROPERTY_SELECTED_DOWN_ENABLED, oldValue, selectedDownEnabled);
    }

    public boolean isUseMultiSelect() {
        return this.useMultiSelect;
    }

    public void setUseMultiSelect(boolean useMultiSelect) {
        boolean oldValue = this.isUseMultiSelect();
        this.useMultiSelect = useMultiSelect;
        this.firePropertyChange(PROPERTY_USE_MULTI_SELECT, oldValue, useMultiSelect);
    }

    protected void addToUniverseList(O item) {
        int index = this.universe.indexOf(item);
        if (index != -1) {
            int insertionIndex = Math.min(index, this.universeModel.getSize());
            while (insertionIndex > 0) {
                Object o;
                int oIndex;
                if ((oIndex = this.universe.indexOf(o = this.universeModel.get(--insertionIndex))) >= index) continue;
                ++insertionIndex;
                break;
            }
            this.universeModel.add(insertionIndex, item);
        }
    }

    public int getSelectedListSize() {
        return this.selected.size();
    }

    public void addCanRemoveItemsPredicate(Predicate<List<O>> canRemoveItemsPredicate) {
        this.canRemoveItemsPredicates.add(canRemoveItemsPredicate);
    }

    public void removeCanRemoveItemsPredicate(Predicate<List<O>> canRemoveItemsPredicate) {
        this.canRemoveItemsPredicates.remove(canRemoveItemsPredicate);
    }

    public boolean computeRemoveEnabled(List<O> toRemoveItems) {
        boolean result = true;
        Iterator<Predicate<List<O>>> iterator = this.canRemoveItemsPredicates.iterator();
        while (result && iterator.hasNext()) {
            result = iterator.next().test(toRemoveItems);
        }
        this.setRemoveEnabled(result);
        return result;
    }
}

