/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.swing.extra.tabbedpane;

import java.awt.Component;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.swing.JTabbedPane;

public abstract class TabbedPaneIterator<O>
implements Iterator<O> {
    final JTabbedPane tabs;
    boolean reverse;
    int index;
    int increment;

    protected abstract O get(int var1, Component var2);

    public TabbedPaneIterator(boolean reverse, JTabbedPane tabs) {
        this.tabs = tabs;
        this.setReverse(reverse);
    }

    public void reset() {
        this.setReverse(this.reverse);
    }

    public int size() {
        return this.tabs.getTabCount();
    }

    public TabbedPaneIterator<O> reverse() {
        this.setReverse(!this.reverse);
        return this;
    }

    @Override
    public boolean hasNext() {
        return this.reverse ? this.index > 0 : this.index < this.tabs.getTabCount();
    }

    public int getIndex() {
        return this.index;
    }

    @Override
    public O next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        Component next = this.tabs.getComponentAt(this.index);
        O result = this.get(this.index, next);
        this.index += this.increment;
        return result;
    }

    @Override
    public void remove() {
        throw new IllegalStateException("not implemented for " + this);
    }

    public String toString() {
        return super.toString() + "< reverse:" + this.reverse + ", index:" + this.index + ", size:" + this.tabs.getTabCount() + " >";
    }

    protected void setReverse(boolean reverse) {
        if (reverse) {
            this.index = this.tabs.getTabCount() - 1;
            this.increment = -1;
        } else {
            this.index = 0;
            this.increment = 1;
        }
        this.reverse = reverse;
    }
}

