/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.swing.extra.list;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.NoSuchElementException;
import javax.swing.AbstractListModel;
import org.apache.commons.collections4.CollectionUtils;

public class JaxxDefaultListModel<E>
extends AbstractListModel {
    private static final long serialVersionUID = 1L;
    protected ArrayList<E> delegate = new ArrayList();
    protected boolean valueIsAdjusting;

    public boolean isValueIsAdjusting() {
        return this.valueIsAdjusting;
    }

    public void setValueIsAdjusting(boolean valueIsAdjusting) {
        this.valueIsAdjusting = valueIsAdjusting;
    }

    public ArrayList<E> toList() {
        return Lists.newArrayList(this.delegate);
    }

    @Override
    public int getSize() {
        return this.delegate.size();
    }

    @Override
    public E getElementAt(int index) {
        return this.delegate.get(index);
    }

    public void trimToSize() {
        this.delegate.trimToSize();
    }

    public void ensureCapacity(int minCapacity) {
        this.delegate.ensureCapacity(minCapacity);
    }

    public void setSize(int newSize) {
        int oldSize = this.delegate.size();
        this.delegate.ensureCapacity(newSize);
        if (oldSize > newSize) {
            this.fireIntervalRemoved(this, newSize, oldSize - 1);
        } else if (oldSize < newSize) {
            this.fireIntervalAdded(this, oldSize, newSize - 1);
        }
    }

    public int capacity() {
        return this.delegate.size();
    }

    public int size() {
        return this.delegate.size();
    }

    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    public boolean contains(E elem) {
        return this.delegate.contains(elem);
    }

    public int indexOf(E elem) {
        return this.delegate.indexOf(elem);
    }

    public int indexOf(E elem, int index) {
        return this.delegate.indexOf(elem);
    }

    public int lastIndexOf(E elem) {
        return this.delegate.lastIndexOf(elem);
    }

    public int lastIndexOf(E elem, int index) {
        return this.delegate.lastIndexOf(elem);
    }

    public E elementAt(int index) {
        return this.delegate.get(index);
    }

    public E firstElement() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.delegate.get(0);
    }

    public E lastElement() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.delegate.get(this.delegate.size() - 1);
    }

    public void setElementAt(E element, int index) {
        this.delegate.set(index, element);
        if (!this.isValueIsAdjusting()) {
            this.fireContentsChanged(this, index, index);
        }
    }

    public void removeElementAt(int index) {
        this.delegate.remove(index);
        if (!this.isValueIsAdjusting()) {
            this.fireIntervalRemoved(this, index, index);
        }
    }

    public void insertElementAt(E element, int index) {
        this.delegate.add(index, element);
        if (!this.isValueIsAdjusting()) {
            this.fireIntervalAdded(this, index, index);
        }
    }

    public void addElement(E element) {
        int index = this.delegate.size();
        this.delegate.add(element);
        if (!this.isValueIsAdjusting()) {
            this.fireIntervalAdded(this, index, index);
        }
    }

    public boolean removeElement(E obj) {
        int index = this.indexOf(obj);
        boolean rv = this.delegate.remove(obj);
        if (index >= 0 && !this.isValueIsAdjusting()) {
            this.fireIntervalRemoved(this, index, index);
        }
        return rv;
    }

    public void removeAllElements() {
        int index1 = this.delegate.size() - 1;
        this.delegate.clear();
        if (index1 >= 0 && !this.isValueIsAdjusting()) {
            this.fireIntervalRemoved(this, 0, index1);
        }
    }

    public String toString() {
        return this.delegate.toString();
    }

    public Object[] toArray() {
        Object[] rv = this.delegate.toArray();
        return rv;
    }

    public E get(int index) {
        return this.delegate.get(index);
    }

    public E set(int index, E element) {
        E rv = this.delegate.set(index, element);
        if (!this.isValueIsAdjusting()) {
            this.fireContentsChanged(this, index, index);
        }
        return rv;
    }

    public void add(int index, E element) {
        this.delegate.add(index, element);
        if (!this.isValueIsAdjusting()) {
            this.fireIntervalAdded(this, index, index);
        }
    }

    public void setAllElements(Collection<E> objects) {
        this.removeAllElements();
        this.addAllElements(objects);
    }

    public void addAllElements(Collection<E> elements) {
        if (CollectionUtils.isNotEmpty(elements)) {
            int firstIndex = this.delegate.size();
            this.delegate.addAll(elements);
            int lastIndex = this.delegate.size() - 1;
            if (lastIndex > -1 && !this.isValueIsAdjusting()) {
                this.fireIntervalAdded(this, firstIndex, lastIndex);
            }
        }
    }

    public void removeAllElements(Collection<E> elements) {
        if (CollectionUtils.isNotEmpty(elements)) {
            int firstIndex = 0;
            int lastIndex = this.delegate.size();
            this.delegate.removeAll(elements);
            if (lastIndex > -1 && !this.isValueIsAdjusting()) {
                this.fireContentsChanged(this, firstIndex, lastIndex);
            }
        }
    }

    public E remove(int index) {
        E rv = this.delegate.remove(index);
        if (!this.isValueIsAdjusting()) {
            this.fireIntervalRemoved(this, index, index);
        }
        return rv;
    }

    public void clear() {
        int index1 = this.delegate.size() - 1;
        this.delegate.clear();
        if (index1 >= 0 && !this.isValueIsAdjusting()) {
            this.fireIntervalRemoved(this, 0, index1);
        }
    }

    public void removeRange(int fromIndex, int toIndex) {
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException("fromIndex must be <= toIndex");
        }
        for (int i = toIndex; i >= fromIndex; --i) {
            this.delegate.remove(i);
        }
        if (!this.isValueIsAdjusting()) {
            this.fireIntervalRemoved(this, fromIndex, toIndex);
        }
    }

    public void refresh() {
        if (!this.isEmpty() && !this.isValueIsAdjusting()) {
            this.fireContentsChanged(this, 0, this.getSize() - 1);
        }
    }

    public void refresh(int size) {
        if (!this.isValueIsAdjusting()) {
            this.fireContentsChanged(this, 0, size);
        }
    }
}

