/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.runtime.swing.list;

import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collections;
import javax.swing.JList;
import javax.swing.SwingUtilities;
import org.nuiton.jaxx.runtime.swing.list.CheckListModel;

final class CheckListEditor
extends MouseAdapter {
    CheckListEditor() {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (!SwingUtilities.isLeftMouseButton(e)) {
            return;
        }
        JList list = (JList)e.getSource();
        if (!list.isEnabled() || !(list.getModel() instanceof CheckListModel)) {
            return;
        }
        int index = list.locationToIndex(e.getPoint());
        if (index < 0) {
            return;
        }
        Rectangle bounds = list.getCellBounds(index, index);
        if (bounds.contains(e.getPoint())) {
            CheckListModel model = (CheckListModel)list.getModel();
            if (e.getClickCount() > 1) {
                model.setCheckedItems(Collections.singletonList(model.getElementAt(index)));
            } else {
                model.setCheckedIndex(index, !model.isCheckedIndex(index));
            }
            e.consume();
        }
    }
}

