/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.runtime.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;

public class HBoxLayout
implements LayoutManager {
    private int spacing = 6;
    private int horizontalAlignment = 2;
    private int verticalAlignment = 1;

    public int getSpacing() {
        return this.spacing;
    }

    public void setSpacing(int spacing) {
        this.spacing = spacing;
    }

    public int getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public void setHorizontalAlignment(int horizontalAlignment) {
        this.horizontalAlignment = horizontalAlignment;
    }

    public int getVerticalAlignment() {
        return this.verticalAlignment;
    }

    public void setVerticalAlignment(int verticalAlignment) {
        this.verticalAlignment = verticalAlignment;
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
    }

    @Override
    public void layoutContainer(Container parent) {
        int x;
        Insets insets = parent.getInsets();
        int parentHeight = parent.getSize().height - insets.top - insets.bottom;
        int count = parent.getComponentCount();
        Dimension preferredSize = parent.getPreferredSize();
        switch (this.horizontalAlignment) {
            case 2: {
                x = insets.left;
                break;
            }
            case 0: {
                x = insets.left + (parent.getWidth() - preferredSize.width) / 2;
                break;
            }
            case 4: {
                x = insets.left + (parent.getWidth() - preferredSize.width);
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid horizontal alignment: " + this.horizontalAlignment);
            }
        }
        for (int i = 0; i < count; ++i) {
            int y;
            Component component = parent.getComponent(i);
            Dimension childPreferredSize = component.getPreferredSize();
            int height = Math.min(childPreferredSize.height, parentHeight);
            switch (this.verticalAlignment) {
                case 1: {
                    y = insets.top;
                    break;
                }
                case 0: {
                    y = insets.top + (parentHeight - childPreferredSize.height) / 2;
                    break;
                }
                case 3: {
                    y = insets.top + (parentHeight - childPreferredSize.height);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("invalid vertical alignment: " + this.verticalAlignment);
                }
            }
            component.setBounds(x, y, childPreferredSize.width, height);
            x += childPreferredSize.width + this.spacing;
        }
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        int width = (parent.getComponentCount() - 1) * this.spacing;
        int height = 0;
        for (int i = parent.getComponentCount() - 1; i >= 0; --i) {
            Dimension minimumSize = parent.getComponent(i).getMinimumSize();
            width += minimumSize.width;
            height = Math.max(height, minimumSize.height);
        }
        Insets insets = parent.getInsets();
        return new Dimension(width + insets.left + insets.right, height + insets.top + insets.bottom);
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        int width = (parent.getComponentCount() - 1) * this.spacing;
        int height = 0;
        for (int i = parent.getComponentCount() - 1; i >= 0; --i) {
            Dimension preferredSize = parent.getComponent(i).getPreferredSize();
            width += preferredSize.width;
            height = Math.max(height, preferredSize.height);
        }
        Insets insets = parent.getInsets();
        return new Dimension(width + insets.left + insets.right, height + insets.top + insets.bottom);
    }

    @Override
    public void removeLayoutComponent(Component comp) {
    }
}

