/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.runtime.api.context;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.nuiton.jaxx.runtime.api.JAXXObject;
import org.nuiton.jaxx.runtime.api.context.JAXXContext;
import org.nuiton.jaxx.runtime.api.context.JAXXContextEntryDef;
import org.nuiton.jaxx.runtime.api.context.JAXXInitialContext;

public class JAXXContexts {
    public static final String PARENT = "parent";

    public static <O> JAXXContextEntryDef<O> newContextEntryDef(Class<O> klass) {
        return JAXXContexts.newContextEntryDef(null, klass);
    }

    public static <O> JAXXContextEntryDef<O> newContextEntryDef(String name, Class<?> klass) {
        return new JAXXContextEntryDef(name, klass);
    }

    public static <O> JAXXContextEntryDef<List<O>> newListContextEntryDef() {
        return JAXXContexts.newListContextEntryDef(null);
    }

    public static <O> JAXXContextEntryDef<List<O>> newListContextEntryDef(String name) {
        Class<List<O>> castList = JAXXContexts.castList();
        JAXXContextEntryDef<List<O>> contextEntryDef = new JAXXContextEntryDef<List<O>>(name, castList);
        return contextEntryDef;
    }

    public static <K, V> JAXXContextEntryDef<Map<K, V>> newMapContextEntryDef(String name) {
        JAXXContextEntryDef<Map<K, V>> contextEntryDef = new JAXXContextEntryDef<Map<K, V>>(Map.class, name);
        return contextEntryDef;
    }

    public static void initContext(JAXXObject ui, JAXXContext parentContext) {
        if (parentContext instanceof JAXXInitialContext) {
            ((JAXXInitialContext)parentContext).to(ui);
        } else {
            ui.setContextValue(parentContext);
        }
        if (parentContext instanceof JAXXObject) {
            ui.setContextValue(parentContext, PARENT);
        }
    }

    private static <O> Class<List<O>> castList() {
        return Collections.emptyList().getClass();
    }

    public static void checkJAXXContextEntries(JAXXContext context, JAXXContextEntryDef<?> ... defs) throws IllegalArgumentException {
        for (JAXXContextEntryDef<?> def : defs) {
            Object value = def.getContextValue(context);
            if (value != null) continue;
            throw new IllegalArgumentException("the context entry [" + def + "] ] was not found in " + "context " + context);
        }
    }

    public static <T> T checkJAXXContextEntry(JAXXContext context, JAXXContextEntryDef<T> def) throws IllegalArgumentException {
        T value = def.getContextValue(context);
        if (value == null) {
            throw new IllegalArgumentException("the context entry [" + def + "] ] was not found in " + "context " + context);
        }
        return value;
    }
}

