/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.compiler.binding.writers;

import java.util.List;
import org.nuiton.jaxx.compiler.JAXXCompiler;
import org.nuiton.jaxx.compiler.binding.DataBinding;
import org.nuiton.jaxx.compiler.binding.DataListener;
import org.nuiton.jaxx.compiler.binding.writers.AbstractJAXXBindingWriter;
import org.nuiton.jaxx.compiler.java.JavaArgument;
import org.nuiton.jaxx.compiler.java.JavaElementFactory;
import org.nuiton.jaxx.compiler.java.JavaFileGenerator;
import org.nuiton.jaxx.compiler.java.JavaMethod;
import org.nuiton.jaxx.runtime.binding.DefaultJAXXBinding;

public class DefaultJAXXBindingWriter
extends AbstractJAXXBindingWriter<DefaultJAXXBinding> {
    public DefaultJAXXBindingWriter() {
        super(DefaultJAXXBinding.class);
    }

    @Override
    public boolean accept(DataBinding binding) {
        return true;
    }

    @Override
    public void write(DataBinding binding, JavaFileGenerator generator, StringBuilder buffer) {
        DataListener[] trackers = binding.getTrackers();
        String eol = JAXXCompiler.getLineSeparator();
        StringBuilder addBuffer = new StringBuilder();
        StringBuilder removeBuffer = new StringBuilder();
        for (DataListener tracker : trackers) {
            boolean needTest;
            boolean bl = needTest = tracker.getObjectCode() != null;
            if (needTest) {
                addBuffer.append("if (");
                addBuffer.append(tracker.getObjectCode());
                addBuffer.append(" != null) {");
                addBuffer.append(eol);
                removeBuffer.append("if (");
                removeBuffer.append(tracker.getObjectCode());
                removeBuffer.append(" != null) {");
                removeBuffer.append(eol);
            }
            int indentLevel = needTest ? 4 : 0;
            addBuffer.append(JavaFileGenerator.indent(tracker.getAddListenerCode(), indentLevel, false, eol));
            removeBuffer.append(JavaFileGenerator.indent(tracker.getRemoveListenerCode(), indentLevel, false, eol));
            if (needTest) {
                addBuffer.append(eol).append("}");
                removeBuffer.append(eol).append("}");
            }
            addBuffer.append(eol);
            removeBuffer.append(eol);
        }
        List<JavaMethod> bMethods = binding.getMethods();
        bMethods.add(0, JavaElementFactory.newMethod(1, "void", "removeDataBinding", removeBuffer.toString(), true, new JavaArgument[0]));
        bMethods.add(0, JavaElementFactory.newMethod(1, "void", "processDataBinding", binding.getProcessDataBinding(), true, new JavaArgument[0]));
        bMethods.add(0, JavaElementFactory.newMethod(1, "void", "applyDataBinding", addBuffer.toString(), true, new JavaArgument[0]));
        this.writeInvocationMethod(binding, trackers, generator, buffer, bMethods);
    }

    @Override
    protected String getConstructorParams(DataBinding binding, DataListener[] trackers) {
        String params = "this, " + binding.getConstantId() + ", true";
        if (trackers.length > 1) {
            params = params + ", true";
        }
        return params;
    }
}

