/*
 * Decompiled with CFR 0.152.
 */
package jaxx.compiler.reflect;

import java.io.Reader;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import jaxx.compiler.CompilerException;
import jaxx.compiler.JAXXCompiler;
import jaxx.compiler.JAXXEngine;
import jaxx.compiler.java.parser.JavaParser;
import jaxx.compiler.java.parser.ParseException;
import jaxx.compiler.java.parser.SimpleNode;
import jaxx.compiler.reflect.ClassDescriptor;
import jaxx.compiler.reflect.ClassDescriptorLoader;
import jaxx.compiler.reflect.FieldDescriptor;
import jaxx.compiler.reflect.MethodDescriptor;
import jaxx.compiler.tags.TagManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JavaFileParser {
    private static final Log log = LogFactory.getLog(JavaFileParser.class);
    private JAXXCompiler compiler;
    private String className;
    private String packageName = null;
    private String superclass = "java.lang.Object";
    private List<MethodDescriptor> methods = new ArrayList<MethodDescriptor>();
    private List<FieldDescriptor> fields = new ArrayList<FieldDescriptor>();

    private JavaFileParser(ClassLoader classLoader) {
        this.compiler = JAXXEngine.createDummyCompiler(classLoader);
    }

    public static ClassDescriptor parseJavaFile(String displayName, Reader src, ClassLoader classLoader) throws ClassNotFoundException {
        JavaFileParser parser = new JavaFileParser(classLoader);
        if (log.isDebugEnabled()) {
            log.debug((Object)("starting parsing : " + displayName));
        }
        try {
            parser.doParse(displayName, src);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage());
            throw new RuntimeException(e);
        }
        List<MethodDescriptor> publicMethods = parser.methods;
        List<FieldDescriptor> publicFields = parser.fields;
        Iterator<MethodDescriptor> methods = publicMethods.iterator();
        while (methods.hasNext()) {
            MethodDescriptor method = methods.next();
            if (Modifier.isPublic(method.getModifiers())) continue;
            methods.remove();
        }
        Iterator<FieldDescriptor> fields = publicFields.iterator();
        while (fields.hasNext()) {
            FieldDescriptor field = fields.next();
            if (Modifier.isPublic(field.getModifiers())) continue;
            fields.remove();
        }
        ClassDescriptor superclassDescriptor = ClassDescriptorLoader.getClassDescriptor(parser.superclass, classLoader);
        publicMethods.addAll(Arrays.asList(superclassDescriptor.getMethodDescriptors()));
        publicFields.addAll(Arrays.asList(superclassDescriptor.getFieldDescriptors()));
        return new ClassDescriptor(parser.className, parser.packageName, parser.superclass, new String[0], false, false, null, null, classLoader, publicMethods.toArray(new MethodDescriptor[publicMethods.size()]), publicFields.toArray(new FieldDescriptor[publicFields.size()])){

            @Override
            public FieldDescriptor getDeclaredFieldDescriptor(String name) throws NoSuchFieldException {
                throw new NoSuchFieldException(name);
            }

            @Override
            public MethodDescriptor getDeclaredMethodDescriptor(String name, ClassDescriptor ... parameterTypes) throws NoSuchMethodException {
                throw new NoSuchMethodException(name);
            }
        };
    }

    private void doParse(String displayName, Reader src) {
        try {
            JavaParser p = new JavaParser(src);
            p.CompilationUnit();
            SimpleNode node = p.popNode();
            if (node != null) {
                this.scanCompilationUnit(node);
                return;
            }
            throw new CompilerException("Internal error: null node parsing Java file from " + src);
        }
        catch (ParseException e) {
            throw new CompilerException("Error parsing Java source code " + displayName + ": " + e.getMessage());
        }
    }

    private void scanCompilationUnit(SimpleNode node) {
        for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
            SimpleNode child = node.getChild(i);
            int nodeType = child.getId();
            if (nodeType == 2) {
                this.packageName = child.getChild(1).getText().trim();
                this.compiler.addImport(this.packageName + ".*");
                continue;
            }
            if (nodeType == 3) {
                String text = child.getText().trim();
                if (text.startsWith("import")) {
                    text = text.substring("import".length()).trim();
                }
                if (text.endsWith(";")) {
                    text = text.substring(0, text.length() - 1);
                }
                this.compiler.addImport(text);
                continue;
            }
            if (nodeType == 5) {
                this.scanCompilationUnit(child);
                continue;
            }
            if (nodeType != 6 && nodeType != 9) continue;
            this.scanClass(child);
        }
    }

    private void scanClass(SimpleNode node) {
        boolean isInterface = node.firstToken.image.equals("interface");
        this.className = node.firstToken.next.image;
        if (this.packageName != null) {
            this.className = this.packageName + "." + this.className;
        }
        for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
            SimpleNode child = node.getChild(i);
            int nodeType = child.getId();
            if (nodeType == 7) {
                if (isInterface) continue;
                assert (child.jjtGetNumChildren() == 1) : "expected ExtendsList to have exactly one child for a non-interface class";
                String rawName = child.getChild(0).getText().trim();
                this.superclass = TagManager.resolveClassName(rawName, this.compiler);
                if (this.superclass != null) continue;
                throw new CompilerException("Could not find class: " + rawName);
            }
            if (nodeType != 15) continue;
            this.scanClassNode(child);
        }
    }

    private void scanClassNode(SimpleNode node) {
        int nodeType = node.getId();
        if (nodeType == 22) {
            String returnType = null;
            String name = null;
            ArrayList<String> parameterTypes = new ArrayList<String>();
            for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
                SimpleNode child = node.getChild(i);
                int type = child.getId();
                if (type == 36) {
                    returnType = TagManager.resolveClassName(child.getText().trim(), this.compiler);
                    continue;
                }
                if (type != 23) continue;
                name = child.firstToken.image.trim();
                SimpleNode formalParameters = child.getChild(0);
                assert (formalParameters.getId() == 24);
                for (int j = 0; j < formalParameters.jjtGetNumChildren(); ++j) {
                    SimpleNode parameter = formalParameters.getChild(j);
                    String rawParameterType = parameter.getChild(1).getText().trim().replaceAll("\\.\\.\\.", "[]");
                    String parameterType = TagManager.resolveClassName(rawParameterType, this.compiler);
                    if (parameterType == null) {
                        // empty if block
                    }
                    parameterTypes.add(parameterType);
                }
            }
            this.methods.add(new MethodDescriptor(name, 1, returnType, parameterTypes.toArray(new String[parameterTypes.size()]), this.compiler.getClassLoader()));
        } else if (nodeType != 6 && nodeType != 26) {
            if (nodeType == 17) {
                String[] declarationTokens;
                String name;
                String text;
                String declaration = text = node.getText();
                int equals = text.indexOf("=");
                if (equals != -1) {
                    declaration = declaration.substring(0, equals);
                }
                if ((name = (declarationTokens = (declaration = declaration.trim()).split("\\s"))[declarationTokens.length - 1]).endsWith(";")) {
                    name = name.substring(0, name.length() - 1).trim();
                }
                String cName = declarationTokens[declarationTokens.length - 2];
                String type = TagManager.resolveClassName(cName, this.compiler);
                this.fields.add(new FieldDescriptor(name, 1, type, this.compiler.getClassLoader()));
            } else {
                for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
                    SimpleNode child = node.getChild(i);
                    this.scanClassNode(child);
                }
            }
        }
    }
}

