/*
 * Decompiled with CFR 0.152.
 */
package jaxx.compiler.java;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import jaxx.compiler.java.JavaElement;
import jaxx.compiler.java.JavaFileGenerator;

public class JavaField
extends JavaElement
implements Comparable<JavaField> {
    private String type;
    private String initializer;
    private boolean override;

    public JavaField(int modifiers, String type, String name, boolean override) {
        this(modifiers, type, name, override, null);
    }

    public JavaField(int modifiers, String type, String name, boolean override, String initializer) {
        super(modifiers, name);
        this.type = type;
        this.initializer = initializer;
        this.override = override;
    }

    public String getType() {
        return this.type;
    }

    public boolean isOverride() {
        return this.override;
    }

    public String getInitializer() {
        return this.initializer;
    }

    @Override
    public int compareTo(JavaField o) {
        return JavaElementComparator.compare(this, o);
    }

    public String toString() {
        return super.toString() + " " + this.getName() + ", type:" + this.getType() + ", modifiers:" + Modifier.toString(this.getModifiers());
    }

    public static EnumMap<FieldOrder, List<JavaField>> getSortedFields(List<JavaField> fields) {
        int[] scopes;
        EnumMap<FieldOrder, List<JavaField>> result = new EnumMap<FieldOrder, List<JavaField>>(FieldOrder.class);
        for (FieldOrder fieldOrder : FieldOrder.values()) {
            result.put(fieldOrder, new ArrayList());
        }
        EnumSet<FieldOrder> allConstants = EnumSet.allOf(FieldOrder.class);
        ArrayList<JavaField> allFields = new ArrayList<JavaField>(fields);
        for (int scope : scopes = new int[]{8, 1, 4, 2}) {
            EnumSet<FieldOrder> constants = JavaField.getFieldOrderScope(allConstants, scope);
            Iterator itMethods = allFields.iterator();
            block2: while (itMethods.hasNext()) {
                JavaField method = (JavaField)itMethods.next();
                for (FieldOrder constant : constants) {
                    if (!constant.accept(method.getModifiers(), method)) continue;
                    result.get((Object)constant).add(method);
                    itMethods.remove();
                    continue block2;
                }
            }
            constants.clear();
        }
        if (!allFields.isEmpty()) {
            ((List)result.get((Object)FieldOrder.otherFields)).addAll(allFields);
        }
        for (FieldOrder fieldOrder : FieldOrder.values()) {
            Collections.sort(result.get((Object)fieldOrder));
        }
        return result;
    }

    public static EnumSet<FieldOrder> getFieldOrderScope(EnumSet<FieldOrder> allConstants, int scope) {
        EnumSet<FieldOrder> constants = EnumSet.noneOf(FieldOrder.class);
        for (FieldOrder order : allConstants) {
            if (!order.accept(scope)) continue;
            constants.add(order);
        }
        return constants;
    }

    public static enum FieldOrder {
        staticsBean(9, "Constants for all javaBean properties"){

            @Override
            public boolean accept(JavaField field) {
                return field.getName().startsWith("PROPERTY_");
            }
        }
        ,
        staticsPublicBindings(9, "Constants for all public bindings"){

            @Override
            public boolean accept(JavaField field) {
                return field.getName().startsWith("BINDING_") && Modifier.isPublic(field.getModifiers());
            }
        }
        ,
        staticsPrivateBindings(10, "Constants for all none public bindings"){

            @Override
            public boolean accept(JavaField field) {
                return field.getName().startsWith("BINDING_$") && Modifier.isPrivate(field.getModifiers());
            }
        }
        ,
        staticsOthers(8, "Other static fields"),
        internalFields(6, "Internal states"){
            private final List<String> fields = Arrays.asList("delegateContext", "$previousValues", "$bindingSources", "$objectMap", "$activeBindings", "$bindings", "$propertyChangeSupport", "allComponentsCreated", "contextInitialized");

            @Override
            public boolean accept(JavaField field) {
                return this.fields.contains(field.getName());
            }
        }
        ,
        publicFields(1, "Public components"),
        protectedFields(4, "Protected components"),
        privateFields(2, "Private components"),
        otherFields(0, "Other fields"){

            @Override
            public boolean accept(JavaField field) {
                return true;
            }
        };

        private final String header;
        private int modifier;

        private FieldOrder(int modifier, String header) {
            this.header = JavaFileGenerator.getHeader(header);
            this.modifier = modifier;
        }

        public String getHeader() {
            return this.header;
        }

        public boolean accept(JavaField field) {
            return true;
        }

        public boolean accept(int mod) {
            return (mod & this.modifier) != 0;
        }

        public boolean accept(int mod, JavaField method) {
            return this.accept(mod) && this.accept(method);
        }

        public static FieldOrder valueOf(JavaField method, int scope) {
            for (FieldOrder o : FieldOrder.values()) {
                if (!o.accept(scope, method)) continue;
                return o;
            }
            throw new IllegalArgumentException("could not find a " + FieldOrder.class + " for method " + method);
        }
    }
}

