/*
 * Decompiled with CFR 0.152.
 */
package jaxx.compiler.tags;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import jaxx.compiler.CompilerException;
import jaxx.compiler.JAXXCompiler;
import jaxx.compiler.UnsupportedAttributeException;
import jaxx.compiler.css.parser.CSSParser;
import jaxx.compiler.css.parser.SimpleNode;
import jaxx.compiler.tags.TagHandler;
import jaxx.runtime.css.Rule;
import jaxx.runtime.css.Selector;
import jaxx.runtime.css.Stylesheet;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class StyleHandler
implements TagHandler {
    public static final String SOURCE_ATTRIBUTE = "source";

    @Override
    public void compileFirstPass(Element tag, JAXXCompiler compiler) throws CompilerException, IOException {
        boolean source = false;
        NamedNodeMap attributes = tag.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Attr attribute = (Attr)attributes.item(i);
            String name = attribute.getName();
            String attrValue = attribute.getValue();
            if (name.equals(SOURCE_ATTRIBUTE)) {
                source = true;
                File styleFile = new File(compiler.getBaseDir(), attrValue.replace('/', File.separatorChar));
                StringWriter styleBuffer = new StringWriter();
                try {
                    int c;
                    FileReader in = new FileReader(styleFile);
                    char[] readBuffer = new char[2048];
                    while ((c = in.read(readBuffer)) > 0) {
                        styleBuffer.write(readBuffer, 0, c);
                    }
                }
                catch (FileNotFoundException e) {
                    compiler.reportError("stylesheet file not found: " + styleFile);
                }
                compiler.getSourceFiles().push(styleFile);
                compiler.registerStylesheet(this.processStylesheet(styleBuffer.toString()));
                compiler.getSourceFiles().pop();
                continue;
            }
            if (name.startsWith("xmlns") || "http://www.jaxxframework.org/internal".equals(attribute.getNamespaceURI())) continue;
            throw new UnsupportedAttributeException(name);
        }
        StringBuffer style = new StringBuffer();
        NodeList children = tag.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            switch (child.getNodeType()) {
                case 1: {
                    compiler.reportError("<style> tag may not contain child elements: " + tag);
                }
                case 3: 
                case 4: {
                    style.append(((Text)child).getData());
                }
            }
        }
        String styleString = style.toString().trim();
        if (styleString.length() > 0) {
            if (source) {
                compiler.reportError("<style> tag has both a source attribute and an inline stylesheet");
            }
            compiler.registerStylesheet(this.processStylesheet(style.toString()));
        }
    }

    @Override
    public void compileSecondPass(Element tag, JAXXCompiler compiler) throws CompilerException, IOException {
    }

    protected Selector processSelector(SimpleNode selector) {
        if (selector.getId() != 3) {
            throw new IllegalArgumentException("argument node is not a Selector");
        }
        String javaClassName = null;
        String styleClass = null;
        String pseudoClass = null;
        String id = null;
        block6: for (int i = 0; i < selector.jjtGetNumChildren(); ++i) {
            SimpleNode child = selector.getChild(i);
            switch (child.getId()) {
                case 4: {
                    if (child.getText().trim().equals("*")) continue block6;
                    javaClassName = child.getText();
                    continue block6;
                }
                case 6: {
                    styleClass = child.getText().substring(1);
                    continue block6;
                }
                case 7: {
                    pseudoClass = child.getText().substring(1);
                    continue block6;
                }
                case 5: {
                    id = child.getText().substring(1);
                    continue block6;
                }
                default: {
                    throw new IllegalStateException("unexpected child of Selector node, type=" + child.getId());
                }
            }
        }
        return new Selector(javaClassName, styleClass, pseudoClass, id);
    }

    protected Rule processRule(SimpleNode ruleNode) {
        if (ruleNode.getId() != 1) {
            throw new IllegalArgumentException("argument node is not a Rule");
        }
        SimpleNode selectorsNode = ruleNode.getChild(0);
        assert (selectorsNode.getId() == 2) : "expected node to be of type Selectors";
        ArrayList<Selector> selectors = new ArrayList<Selector>();
        for (int i = 0; i < selectorsNode.jjtGetNumChildren(); ++i) {
            SimpleNode selectorNode = selectorsNode.getChild(i);
            selectors.add(this.processSelector(selectorNode));
        }
        HashMap<String, String> properties = new HashMap<String, String>();
        for (int i = 1; i < ruleNode.jjtGetNumChildren(); ++i) {
            SimpleNode declarationNode = ruleNode.getChild(i);
            if (declarationNode.getId() != 10) continue;
            String key = declarationNode.getChild(0).getText();
            SimpleNode valueNode = declarationNode.getChild(1);
            String value = valueNode.getText();
            if (valueNode.firstToken.kind == 22) {
                value = value.substring(1, value.length() - 1);
            }
            properties.put(key, value);
        }
        Rule rule = new Rule(selectors.toArray(new Selector[selectors.size()]), properties);
        return rule;
    }

    protected Stylesheet processStylesheet(String stylesheetText) throws CompilerException {
        SimpleNode node;
        CSSParser p = new CSSParser(new StringReader(stylesheetText));
        try {
            node = p.Stylesheet();
        }
        catch (Error e) {
            throw new CompilerException(e);
        }
        ArrayList<Rule> rules = new ArrayList<Rule>();
        for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
            SimpleNode ruleNode = node.getChild(i);
            Rule rule = this.processRule(ruleNode);
            rules.add(rule);
        }
        Stylesheet stylesheet = new Stylesheet(rules.toArray(new Rule[rules.size()]));
        return stylesheet;
    }
}

