/*
 * Decompiled with CFR 0.152.
 */
package jaxx.compiler.reflect;

import java.util.Arrays;
import jaxx.compiler.reflect.ClassDescriptorLoader;
import jaxx.compiler.reflect.FieldDescriptor;
import jaxx.compiler.reflect.MethodDescriptor;
import jaxx.runtime.JAXXObjectDescriptor;

public abstract class ClassDescriptor {
    private String name;
    private String packageName;
    private String superclass;
    private String[] interfaces;
    private boolean isInterface;
    private boolean isArray;
    private String componentType;
    private JAXXObjectDescriptor jaxxObjectDescriptor;
    private ClassLoader classLoader;
    private MethodDescriptor[] methodDescriptors;
    private FieldDescriptor[] fieldDescriptors;

    public abstract MethodDescriptor getDeclaredMethodDescriptor(String var1, ClassDescriptor ... var2) throws NoSuchMethodException;

    public abstract FieldDescriptor getDeclaredFieldDescriptor(String var1) throws NoSuchFieldException;

    ClassDescriptor(String name, String packageName, String superclass, String[] interfaces, boolean isInterface, boolean isArray, String componentType, JAXXObjectDescriptor jaxxObjectDescriptor, ClassLoader classLoader, MethodDescriptor[] methodDescriptors, FieldDescriptor[] fieldDescriptors) {
        this.name = name;
        this.packageName = packageName;
        this.superclass = superclass;
        this.interfaces = interfaces;
        this.isInterface = isInterface;
        this.isArray = isArray;
        this.componentType = componentType;
        this.jaxxObjectDescriptor = jaxxObjectDescriptor;
        this.classLoader = classLoader;
        this.methodDescriptors = methodDescriptors;
        this.fieldDescriptors = fieldDescriptors;
    }

    public String getName() {
        return this.name;
    }

    public String getSimpleName() {
        int dot = this.name.lastIndexOf(".");
        return dot == -1 ? this.name : this.name.substring(dot + 1);
    }

    public String getPackageName() {
        return this.packageName;
    }

    public ClassDescriptor getSuperclass() {
        try {
            return this.superclass != null ? ClassDescriptorLoader.getClassDescriptor(this.superclass, this.getClassLoader()) : null;
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public ClassDescriptor[] getInterfaces() {
        try {
            ClassDescriptor[] result = new ClassDescriptor[this.interfaces.length];
            for (int i = 0; i < result.length; ++i) {
                result[i] = ClassDescriptorLoader.getClassDescriptor(this.interfaces[i], this.getClassLoader());
            }
            return result;
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isInterface() {
        return this.isInterface;
    }

    public boolean isArray() {
        return this.isArray;
    }

    public ClassDescriptor getComponentType() {
        try {
            return this.componentType != null ? ClassDescriptorLoader.getClassDescriptor(this.componentType, this.getClassLoader()) : null;
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public MethodDescriptor[] getMethodDescriptors() {
        return this.methodDescriptors;
    }

    public MethodDescriptor getMethodDescriptor(String name, ClassDescriptor ... parameterTypes) throws NoSuchMethodException {
        for (MethodDescriptor methodDescriptor : this.methodDescriptors) {
            if (!methodDescriptor.getName().equals(name) || methodDescriptor.getParameterTypes().length != parameterTypes.length || !Arrays.equals(methodDescriptor.getParameterTypes(), parameterTypes)) continue;
            return methodDescriptor;
        }
        throw new NoSuchMethodException("Could not find method " + name + "(" + Arrays.asList(parameterTypes) + ") in " + this.getName());
    }

    public FieldDescriptor[] getFieldDescriptors() {
        return this.fieldDescriptors;
    }

    public FieldDescriptor getFieldDescriptor(String name) throws NoSuchFieldException {
        for (FieldDescriptor fieldDescriptor : this.fieldDescriptors) {
            if (!fieldDescriptor.getName().equals(name)) continue;
            return fieldDescriptor;
        }
        throw new NoSuchFieldException("Could not find field " + name + " in " + this.getName());
    }

    public JAXXObjectDescriptor getJAXXObjectDescriptor() {
        return this.jaxxObjectDescriptor;
    }

    public boolean isAssignableFrom(ClassDescriptor descriptor) {
        while (descriptor != null) {
            if (descriptor == this) {
                return true;
            }
            for (ClassDescriptor anInterface : descriptor.getInterfaces()) {
                if (anInterface != this) continue;
                return true;
            }
            descriptor = descriptor.getSuperclass();
        }
        return false;
    }

    public String toString() {
        return "ClassDescriptor[" + this.getName() + "]";
    }
}

