/*
 * Decompiled with CFR 0.152.
 */
package jaxx.compiler;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.sax.SAXSource;
import jaxx.compiler.CompiledObject;
import jaxx.compiler.CompiledObjectDecorator;
import jaxx.compiler.CompilerConfiguration;
import jaxx.compiler.CompilerException;
import jaxx.compiler.EventHandler;
import jaxx.compiler.JAXXCompilerFinalizer;
import jaxx.compiler.JAXXEngine;
import jaxx.compiler.SymbolTable;
import jaxx.compiler.UnsupportedAttributeException;
import jaxx.compiler.UnsupportedTagException;
import jaxx.compiler.binding.DataBinding;
import jaxx.compiler.css.StylesheetHelper;
import jaxx.compiler.java.JavaField;
import jaxx.compiler.java.JavaFile;
import jaxx.compiler.java.JavaFileGenerator;
import jaxx.compiler.java.JavaMethod;
import jaxx.compiler.java.parser.ParseException;
import jaxx.compiler.reflect.ClassDescriptor;
import jaxx.compiler.reflect.ClassDescriptorLoader;
import jaxx.compiler.reflect.FieldDescriptor;
import jaxx.compiler.reflect.MethodDescriptor;
import jaxx.compiler.script.ScriptManager;
import jaxx.compiler.tags.DefaultObjectHandler;
import jaxx.compiler.tags.TagHandler;
import jaxx.compiler.tags.TagManager;
import jaxx.compiler.types.TypeManager;
import jaxx.runtime.ComponentDescriptor;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.css.Rule;
import jaxx.runtime.css.Stylesheet;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.XMLFilterImpl;

public class JAXXCompiler {
    protected static final Log log = LogFactory.getLog(JAXXCompiler.class);
    public static final boolean STRICT_CHECKS = false;
    public static final String JAXX_NAMESPACE = "http://www.jaxxframework.org/";
    public static final String JAXX_INTERNAL_NAMESPACE = "http://www.jaxxframework.org/internal";
    public static final int INLINE_THRESHOLD = 300;
    protected static String lineSeparator = System.getProperty("line.separator", "\n");
    protected final DefaultObjectHandler firstPassClassTagHandler;
    protected boolean failed;
    protected CompiledObject root;
    protected Set<String> importedPackages = new HashSet<String>();
    protected Set<String> importedClasses = new HashSet<String>();
    protected Stack<CompiledObject> openComponents = new Stack();
    protected int autogenID = 0;
    protected List<DataBinding> dataBindings = new ArrayList<DataBinding>();
    protected SymbolTable symbolTable = new SymbolTable();
    protected File baseDir;
    protected File src;
    protected Document document;
    protected String outputClassName;
    protected ScriptManager scriptManager = new ScriptManager(this);
    protected Stylesheet stylesheet;
    protected List<Rule> inlineStyles = new ArrayList<Rule>();
    protected Map<String, Map<ClassDescriptor, List<EventHandler>>> eventHandlers = new HashMap<String, Map<ClassDescriptor, List<EventHandler>>>();
    protected Map<Object, String> uniqueIds = new HashMap<Object, String>();
    protected Map<EventHandler, String> eventHandlerMethodNames = new HashMap<EventHandler, String>();
    protected ClassLoader classLoader;
    protected List<Runnable> initializers = new ArrayList<Runnable>();
    protected Matcher leftBraceMatcher = Pattern.compile("^(\\{)|[^\\\\](\\{)").matcher("");
    protected Matcher rightBraceMatcher = Pattern.compile("^(\\})|[^\\\\](\\})").matcher("");
    private String[] extraInterfaces;
    private boolean abstractClass;
    private String genericType;
    private String superGenericType;
    protected StringBuffer initializer = new StringBuffer();
    protected StringBuffer lateInitializer = new StringBuffer();
    protected StringBuffer bodyCode = new StringBuffer();
    protected StringBuffer initDataBindings = new StringBuffer();
    protected StringBuffer applyDataBinding = new StringBuffer();
    protected StringBuffer removeDataBinding = new StringBuffer();
    protected StringBuffer processDataBinding = new StringBuffer();
    protected boolean mainDeclared;
    protected JavaFile javaFile;
    protected CompilerConfiguration configuration;
    protected Stack<Element> tagsBeingCompiled = new Stack();
    protected Stack<File> sourceFiles = new Stack();
    protected Map<String, CompiledObject> objects = new LinkedHashMap<String, CompiledObject>();
    protected Map<CompiledObject, String> ids = new LinkedHashMap<CompiledObject, String>();
    protected CompiledObjectDecorator defaultDecorator;
    protected final JAXXEngine engine;

    public JAXXCompiler(JAXXEngine engine, File baseDir, File src, String outputClassName, CompilerConfiguration configuration, List<String> defaultImports) {
        this.engine = engine;
        this.baseDir = baseDir;
        this.src = src;
        this.firstPassClassTagHandler = new DefaultObjectHandler(ClassDescriptorLoader.getClassDescriptor(Object.class));
        this.sourceFiles.push(src);
        this.outputClassName = outputClassName;
        this.configuration = configuration;
        if (outputClassName != null) {
            this.addImport(outputClassName.substring(0, outputClassName.lastIndexOf(".") + 1) + "*");
        }
        if (defaultImports != null) {
            for (String staticImport : defaultImports) {
                this.addImport(staticImport);
            }
        }
        if (configuration != null) {
            if (configuration.getExtraImports() != null) {
                for (String extraImport : configuration.getExtraImports()) {
                    this.addImport(extraImport);
                }
            }
            this.defaultDecorator = engine.getDecorator(configuration.getDefaultDecoratorClass());
            if (this.defaultDecorator == null) {
                log.error((Object)("could not find default decorator : " + configuration.getDefaultDecoratorClass()));
                throw new IllegalArgumentException("could not find default decorator : " + configuration.getDefaultDecoratorClass());
            }
        }
    }

    public void runInitializers() {
        for (Runnable runnable : this.initializers) {
            if (log.isDebugEnabled()) {
                log.debug((Object)runnable);
            }
            try {
                runnable.run();
            }
            catch (Exception e) {
                this.reportError(e.getMessage());
                return;
            }
        }
        this.initializers.clear();
    }

    public void registerInitializer(Runnable r) {
        this.initializers.add(r);
    }

    public void compileFirstPass(final Element tag) throws IOException {
        TagHandler handler;
        String fullClassName;
        boolean namespacePrefix;
        this.tagsBeingCompiled.push(tag);
        String namespace = tag.getNamespaceURI();
        String localName = tag.getLocalName();
        boolean bl = namespacePrefix = tag.getPrefix() != null;
        if (namespace != null && namespace.endsWith("*")) {
            String packageName = namespace.substring(0, namespace.length() - 1);
            if (localName.startsWith(packageName)) {
                fullClassName = TagManager.resolveClassName(localName, this);
            } else {
                fullClassName = TagManager.resolveClassName(packageName + localName, this);
                if (fullClassName == null && !namespacePrefix) {
                    fullClassName = TagManager.resolveClassName(localName, this);
                }
            }
        } else {
            fullClassName = TagManager.resolveClassName(localName, this);
        }
        if (fullClassName != null) {
            String id;
            this.addDependencyClass(fullClassName);
            namespace = fullClassName.substring(0, fullClassName.lastIndexOf(".") + 1) + "*";
            if (this.symbolTable.getSuperclassName() == null) {
                this.symbolTable.setSuperclassName(fullClassName);
            }
            if ((id = tag.getAttribute("id")).length() > 0) {
                this.symbolTable.getClassTagIds().put(id, fullClassName);
                if (tag.getAttributeNode("javaBean") != null) {
                    String capitalizeName = StringUtils.capitalize((String)id);
                    this.symbolTable.getScriptMethods().add(new MethodDescriptor("get" + capitalizeName, 1, fullClassName, new String[0], this.classLoader));
                    if (Boolean.class.getName().equals(fullClassName)) {
                        this.symbolTable.getScriptMethods().add(new MethodDescriptor("is" + capitalizeName, 1, fullClassName, new String[0], this.classLoader));
                    }
                    this.symbolTable.getScriptMethods().add(new MethodDescriptor("set" + capitalizeName, 1, "void", new String[]{fullClassName}, this.classLoader));
                }
            }
        }
        TagHandler tagHandler = handler = namespace != null && namespace.endsWith("*") ? this.firstPassClassTagHandler : TagManager.getTagHandler(tag.getNamespaceURI(), localName, namespacePrefix, this);
        if (handler != this.firstPassClassTagHandler && handler instanceof DefaultObjectHandler) {
            fullClassName = ((DefaultObjectHandler)handler).getBeanClass().getName();
            handler = this.firstPassClassTagHandler;
        }
        if (handler == this.firstPassClassTagHandler) {
            final String finalClassName = fullClassName;
            this.registerInitializer(new Runnable(){

                @Override
                public void run() {
                    DefaultObjectHandler handler = (DefaultObjectHandler)TagManager.getTagHandler(null, finalClassName, JAXXCompiler.this);
                    if (handler == null) {
                        throw new CompilerException("Internal error: missing TagHandler for '" + finalClassName + "'");
                    }
                    handler.registerCompiledObject(tag, JAXXCompiler.this);
                }
            });
        }
        if (handler == null) {
            this.reportError("Could not find a Java class corresponding to: <" + tag.getTagName() + ">");
            this.failed = true;
        } else {
            try {
                handler.compileFirstPass(tag, this);
            }
            catch (CompilerException e) {
                this.reportError(e);
            }
        }
        Element finished = this.tagsBeingCompiled.pop();
        if (finished != tag) {
            throw new RuntimeException("internal error: just finished compiling " + tag + ", but top of tagsBeingCompiled stack is " + finished);
        }
    }

    public void compileSecondPass(Element tag) throws IOException {
        this.tagsBeingCompiled.push(tag);
        TagHandler handler = TagManager.getTagHandler(tag.getNamespaceURI(), tag.getLocalName(), tag.getPrefix() != null, this);
        if (handler == null) {
            this.reportError("Could not find a Java class corresponding to: <" + tag.getTagName() + ">");
            this.failed = true;
        } else {
            handler.compileSecondPass(tag, this);
        }
        Element finished = this.tagsBeingCompiled.pop();
        if (finished != tag) {
            throw new RuntimeException("internal error: just finished compiling " + tag + ", but top of tagsBeingCompiled stack is " + finished);
        }
    }

    protected void compileFirstPass() throws IOException {
        try {
            FileInputStream in = new FileInputStream(this.src);
            this.document = JAXXCompiler.parseDocument(in);
            ((InputStream)in).close();
            this.compileFirstPass(this.document.getDocumentElement());
        }
        catch (SAXParseException e) {
            this.reportError(e.getLineNumber(), "Invalid XML: " + e.getMessage());
        }
        catch (SAXException e) {
            this.reportError(null, "Error parsing XML document: " + e);
        }
    }

    protected void compileSecondPass() throws IOException {
        if (!this.tagsBeingCompiled.isEmpty()) {
            throw new RuntimeException("Internal error: starting pass two, but tagsBeingCompiled is not empty: " + this.tagsBeingCompiled);
        }
        this.compileSecondPass(this.document.getDocumentElement());
    }

    public void openComponent(CompiledObject component) throws CompilerException {
        this.openComponent(component, null);
    }

    public void openComponent(CompiledObject component, String constraints) throws CompilerException {
        CompiledObject parent = this.getOpenComponent();
        this.openInvisibleComponent(component);
        if (parent != null && !component.isOverride()) {
            parent.addChild(component, constraints, this);
        }
    }

    public void openInvisibleComponent(CompiledObject component) {
        if (!this.ids.containsKey(component)) {
            this.registerCompiledObject(component);
        }
        this.openComponents.push(component);
    }

    public CompiledObject getOpenComponent() {
        if (this.openComponents.isEmpty()) {
            return null;
        }
        return this.openComponents.peek();
    }

    public void closeComponent(CompiledObject component) {
        if (this.openComponents.pop() != component) {
            throw new IllegalArgumentException("can only close the topmost open object");
        }
    }

    public void registerCompiledObject(CompiledObject object) {
        assert (this.engine.symbolTables.values().contains(this.symbolTable)) : "attempting to register CompiledObject before pass 1 is complete";
        if (this.root == null) {
            this.root = object;
        }
        String id = object.getId();
        if (this.ids.containsKey(object)) {
            this.reportError("object '" + object + "' is already registered with id '" + this.ids.get(object) + "', cannot re-register as '" + id + "'");
        }
        if (this.objects.containsKey(id) && !(this.objects.get(id) instanceof Element)) {
            this.reportError("id '" + id + "' is already registered to component " + this.objects.get(id));
        }
        this.objects.put(id, object);
        this.ids.put(object, id);
        if (object.getDecorator() == null) {
            object.setDecorator(this.defaultDecorator);
        }
    }

    public CompiledObject getCompiledObject(String id) {
        this.runInitializers();
        assert (this.engine.symbolTables.values().contains(this.symbolTable)) : "attempting to retrieve CompiledObject before pass 1 is complete";
        return this.objects.get(id);
    }

    public boolean inlineCreation(CompiledObject object) {
        return object.getId().startsWith("$") && object.getInitializationCode(this).length() < 300;
    }

    public void checkOverride(CompiledObject object) throws CompilerException {
        if (object.getId().startsWith("$")) {
            return;
        }
        ClassDescriptor ancestor = this.root.getObjectClass();
        if (ancestor == object.getObjectClass()) {
            return;
        }
        while (ancestor != null) {
            try {
                FieldDescriptor f = ancestor.getDeclaredFieldDescriptor(object.getId());
                if (!f.getType().isAssignableFrom(object.getObjectClass())) {
                    this.reportError("attempting to redefine superclass member '" + object.getId() + "' as incompatible type (was " + f.getType() + ", redefined as " + object.getObjectClass() + ")");
                }
                object.setOverride(true);
                object.setOverrideType(f.getType());
                break;
            }
            catch (NoSuchFieldException e) {
                ancestor = ancestor.getSuperclass();
            }
        }
    }

    public String getJavaCode(Object object) {
        String result = TypeManager.getJavaCode(object);
        return result;
    }

    public Object convertFromString(String string, Class<?> type) {
        Object result = TypeManager.convertFromString(string, type);
        return result;
    }

    public List<DataBinding> getDataBindings() {
        return this.dataBindings;
    }

    public String processDataBindings(String stringValue) throws CompilerException {
        int pos = this.getNextLeftBrace(stringValue, 0);
        if (pos != -1) {
            StringBuffer expression = new StringBuffer();
            int lastPos = 0;
            while (pos != -1 && pos < stringValue.length()) {
                int pos2;
                boolean multi;
                if (pos > lastPos) {
                    if (expression.length() > 0) {
                        expression.append(" + ");
                    }
                    expression.append('\"');
                    expression.append(JAXXCompiler.escapeJavaString(stringValue.substring(lastPos, pos)));
                    expression.append('\"');
                }
                boolean bl = multi = expression.length() > 0;
                if (multi) {
                    expression.append(" + ");
                    expression.append('(');
                }
                if ((pos2 = this.getNextRightBrace(stringValue, pos + 1)) == -1) {
                    this.reportError("unmatched '{' in expression: " + stringValue);
                    return "";
                }
                expression.append(stringValue.substring(pos + 1, pos2));
                if (multi) {
                    expression.append(')');
                }
                if (++pos2 < stringValue.length()) {
                    pos = this.getNextLeftBrace(stringValue, pos2);
                    lastPos = pos2;
                    continue;
                }
                lastPos = pos = stringValue.length();
            }
            if (lastPos < stringValue.length()) {
                if (expression.length() > 0) {
                    expression.append(" + ");
                }
                expression.append('\"');
                expression.append(JAXXCompiler.escapeJavaString(stringValue.substring(lastPos)));
                expression.append('\"');
            }
            return expression.toString();
        }
        return null;
    }

    public void registerDataBinding(String src, String dest, String assignment) {
        try {
            src = this.checkJavaCode(src);
            this.dataBindings.add(new DataBinding(src, dest, assignment));
        }
        catch (CompilerException e) {
            this.reportError("While parsing data binding for '" + dest.substring(dest.lastIndexOf(".") + 1) + "': " + e.getMessage());
        }
    }

    public void registerEventHandler(EventHandler handler) {
        ClassDescriptor listenerClass;
        List<EventHandler> handlerList;
        String objectCode = handler.getObjectCode();
        Map<ClassDescriptor, List<EventHandler>> listeners = this.eventHandlers.get(objectCode);
        if (listeners == null) {
            listeners = new HashMap<ClassDescriptor, List<EventHandler>>();
            this.eventHandlers.put(objectCode, listeners);
        }
        if ((handlerList = listeners.get(listenerClass = handler.getListenerClass())) == null) {
            handlerList = new ArrayList<EventHandler>();
            listeners.put(listenerClass, handlerList);
        }
        handlerList.add(handler);
    }

    public String getEventHandlerMethodName(EventHandler handler) {
        String result = this.eventHandlerMethodNames.get(handler);
        if (result == null) {
            if (this.getConfiguration().isOptimize()) {
                result = "$ev" + this.eventHandlerMethodNames.size();
            } else {
                String id = handler.getEventId().substring(0, handler.getEventId().indexOf("."));
                result = "do" + StringUtils.capitalize((String)handler.getListenerMethod().getName()) + "__on__" + id;
                if (this.eventHandlerMethodNames.containsValue(result)) {
                    String result2;
                    int index = 0;
                    while (this.eventHandlerMethodNames.containsValue(result2 = result + "_" + index++)) {
                    }
                    result = result2;
                }
            }
            this.eventHandlerMethodNames.put(handler, result);
        }
        return result;
    }

    public void addScriptField(FieldDescriptor field) {
        this.symbolTable.getScriptFields().add(field);
    }

    public void addScriptMethod(MethodDescriptor method) {
        if (method.getName().equals("main") && method.getParameterTypes().length == 1 && method.getParameterTypes()[0].getName().equals("[Ljava.lang.String;")) {
            this.setMainDeclared(true);
        }
        this.symbolTable.getScriptMethods().add(method);
    }

    public void registerScript(String script) throws CompilerException {
        this.registerScript(script, null);
    }

    public void registerScript(String script, File sourceFile) throws CompilerException {
        File pop;
        if (sourceFile != null) {
            this.sourceFiles.push(sourceFile);
        }
        if (!("".equals(script = script.trim()) || script.endsWith("}") || script.endsWith(";"))) {
            script = script + ";";
        }
        this.scriptManager.registerScript(script);
        if (sourceFile != null && (pop = this.sourceFiles.pop()) != sourceFile) {
            throw new RuntimeException("leaving registerScript(), but " + sourceFile + " was not the top entry on the stack (found " + pop + " instead)");
        }
    }

    public String preprocessScript(String script) throws CompilerException {
        return this.scriptManager.preprocessScript(script);
    }

    public void applyStylesheets() {
        Iterator<CompiledObject> i$ = new ArrayList<CompiledObject>(this.objects.values()).iterator();
        while (i$.hasNext()) {
            CompiledObject o;
            CompiledObject object = o = i$.next();
            TagManager.getTagHandler(object.getObjectClass()).applyStylesheets(object, this);
        }
    }

    public void registerStylesheet(Stylesheet stylesheet) {
        if (this.stylesheet == null) {
            this.stylesheet = stylesheet;
        } else {
            this.stylesheet.add(stylesheet.getRules());
        }
    }

    public void addInlineStyle(CompiledObject object, String propertyName, boolean dataBinding) {
        this.inlineStyles.add(StylesheetHelper.inlineAttribute(object, propertyName, dataBinding));
    }

    public void reportWarning(String warning) {
        Element currentTag = null;
        if (!this.tagsBeingCompiled.isEmpty()) {
            currentTag = this.tagsBeingCompiled.peek();
        }
        this.reportWarning(currentTag, warning, 0);
    }

    public void reportWarning(Element tag, String warning, int lineOffset) {
        String lineAttr;
        String lineNumber = null;
        if (tag != null && (lineAttr = tag.getAttributeNS(JAXX_INTERNAL_NAMESPACE, "line")).length() > 0) {
            lineNumber = lineAttr;
        }
        File srcFile = this.sourceFiles.peek();
        try {
            srcFile = srcFile.getCanonicalFile();
        }
        catch (IOException e) {
            // empty catch block
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append(srcFile);
        if (lineNumber != null) {
            buffer.append(":").append(this.sourceFiles.size() == 1 ? Integer.parseInt(lineNumber) + lineOffset : lineOffset + 1);
        }
        buffer.append(JAXXCompiler.getLineSeparator()).append(warning.trim());
        if (this.engine != null) {
            this.engine.addWarning(buffer.toString());
        } else {
            System.err.println(buffer.toString());
        }
    }

    public void reportError(String error) {
        Element currentTag = null;
        if (!this.tagsBeingCompiled.isEmpty()) {
            currentTag = this.tagsBeingCompiled.peek();
        }
        this.reportError(currentTag, error);
    }

    public void reportError(CompilerException ex) {
        this.reportError(null, ex);
    }

    public void reportError(String extraMessage, CompilerException ex) {
        String message = ex.getMessage();
        if (ex.getClass() == UnsupportedAttributeException.class || ex.getClass() == UnsupportedTagException.class) {
            message = ex.getClass().getName().substring(ex.getClass().getName().lastIndexOf(".") + 1) + ": " + message;
        }
        int lineOffset = ex instanceof ParseException ? Math.max(0, ((ParseException)ex).getLine() - 1) : 0;
        Element currentTag = null;
        if (!this.tagsBeingCompiled.isEmpty()) {
            currentTag = this.tagsBeingCompiled.peek();
        }
        this.reportError(currentTag, extraMessage != null ? extraMessage + message : message, lineOffset);
    }

    public void reportError(Element tag, String error) {
        this.reportError(tag, error, 0);
    }

    public void reportError(Element tag, String error, int lineOffset) {
        String lineAttr;
        int lineNumber = 0;
        if (tag != null && (lineAttr = tag.getAttributeNS(JAXX_INTERNAL_NAMESPACE, "line")).length() > 0) {
            lineNumber = Integer.parseInt(lineAttr);
        }
        lineNumber = Math.max(lineNumber, 1) + lineOffset;
        this.reportError(lineNumber, error);
    }

    public void reportError(int lineNumber, String error) {
        File errorFile = this.sourceFiles.isEmpty() ? null : this.sourceFiles.peek();
        try {
            if (errorFile != null) {
                errorFile = errorFile.getCanonicalFile();
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append(errorFile != null ? errorFile.getPath() : "<unknown source>");
        if (lineNumber > 0) {
            buffer.append(":").append(lineNumber);
        }
        buffer.append(JAXXCompiler.getLineSeparator()).append(": ").append(error);
        if (this.engine != null) {
            this.engine.addError(buffer.toString());
        } else {
            System.err.println(buffer.toString());
        }
        this.failed = true;
    }

    public Map<String, CompiledObject> getObjects() {
        return this.objects;
    }

    public Map<String, Map<ClassDescriptor, List<EventHandler>>> getEventHandlers() {
        return this.eventHandlers;
    }

    public CompilerConfiguration getConfiguration() {
        return this.configuration;
    }

    public String getOutputClassName() {
        return this.outputClassName;
    }

    public File getBaseDir() {
        return this.baseDir;
    }

    public Set<String> getImportedClasses() {
        return this.importedClasses;
    }

    public Set<String> getImportedPackages() {
        return this.importedPackages;
    }

    public Iterator<CompiledObject> getObjectCreationOrder() {
        return this.objects.values().iterator();
    }

    public CompiledObject getRootObject() {
        return this.root;
    }

    public Stack<File> getSourceFiles() {
        return this.sourceFiles;
    }

    public ScriptManager getScriptManager() {
        return this.scriptManager;
    }

    public SymbolTable getSymbolTable() {
        return this.symbolTable;
    }

    public Stylesheet getStylesheet() {
        Stylesheet merged = new Stylesheet();
        if (this.stylesheet != null) {
            merged.add(this.stylesheet.getRules());
        }
        merged.add(this.inlineStyles.toArray(new Rule[this.inlineStyles.size()]));
        return merged;
    }

    public FieldDescriptor[] getScriptFields() {
        List<FieldDescriptor> scriptFields = this.symbolTable.getScriptFields();
        return scriptFields.toArray(new FieldDescriptor[scriptFields.size()]);
    }

    public MethodDescriptor[] getScriptMethods() {
        List<MethodDescriptor> scriptMethods = this.symbolTable.getScriptMethods();
        return scriptMethods.toArray(new MethodDescriptor[scriptMethods.size()]);
    }

    public MethodDescriptor getScriptMethod(String methodName) {
        for (MethodDescriptor m : this.symbolTable.getScriptMethods()) {
            if (!methodName.equals(m.getName())) continue;
            return m;
        }
        return null;
    }

    public boolean isFailed() {
        return this.failed;
    }

    public ClassLoader getClassLoader() {
        if (this.classLoader == null) {
            if (this.configuration.getClassLoader() != null) {
                this.classLoader = this.configuration.getClassLoader();
            } else {
                throw new NullPointerException("compiler configuration requires a classLoader! :\n" + this.configuration);
            }
        }
        return this.classLoader;
    }

    public JAXXObjectDescriptor getJAXXObjectDescriptor() {
        this.runInitializers();
        CompiledObject[] components = new ArrayList<CompiledObject>(this.objects.values()).toArray(new CompiledObject[this.objects.size()]);
        assert (this.initializers.isEmpty()) : "there are pending initializers remaining";
        assert (this.root != null) : "root object has not been defined";
        assert (Arrays.asList(components).contains(this.root)) : "root object is not registered";
        ComponentDescriptor[] descriptors = new ComponentDescriptor[components.length];
        for (int i = 0; i < components.length; ++i) {
            int j;
            CompiledObject parent = components[i].getParent();
            while (parent != null) {
                boolean found = false;
                for (j = i + 1; j < components.length; ++j) {
                    if (components[j] != parent) continue;
                    components[j] = components[i];
                    components[i] = parent;
                    found = true;
                    break;
                }
                if (!found) break;
                parent = components[i].getParent();
            }
            int parentIndex = -1;
            if (parent != null) {
                for (j = 0; j < i; ++j) {
                    if (components[j] != parent) continue;
                    parentIndex = j;
                    break;
                }
            }
            descriptors[i] = new ComponentDescriptor(components[i].getId(), components[i] == this.root ? this.outputClassName : components[i].getObjectClass().getName(), components[i].getStyleClass(), parentIndex != -1 ? descriptors[parentIndex] : null);
        }
        Stylesheet css = this.getStylesheet();
        if (css == null) {
            css = new Stylesheet();
        }
        return new JAXXObjectDescriptor(descriptors, css);
    }

    public StringBuffer getInitializer() {
        return this.initializer;
    }

    public StringBuffer getLateInitializer() {
        return this.lateInitializer;
    }

    public StringBuffer getBodyCode() {
        return this.bodyCode;
    }

    public StringBuffer getInitDataBindings() {
        return this.initDataBindings;
    }

    public StringBuffer getApplyDataBinding() {
        return this.applyDataBinding;
    }

    public StringBuffer getRemoveDataBinding() {
        return this.removeDataBinding;
    }

    public StringBuffer getProcessDataBinding() {
        return this.processDataBinding;
    }

    public boolean isMainDeclared() {
        return this.mainDeclared;
    }

    public void setMainDeclared(boolean mainDeclared) {
        this.mainDeclared = mainDeclared;
    }

    public void appendInitializerCode(String code) {
        this.initializer.append(code);
    }

    public void appendBodyCode(String code) {
        this.bodyCode.append(code);
    }

    public void appendInitDataBindings(String code) {
        this.initDataBindings.append(code);
    }

    public void appendProcessDataBinding(String code) {
        this.processDataBinding.append(code);
    }

    public void appendApplyDataBinding(String code) {
        this.applyDataBinding.append(code);
    }

    public void appendRemoveDataBinding(String code) {
        this.removeDataBinding.append(code);
    }

    public void appendLateInitializer(String code) {
        this.lateInitializer.append(code);
    }

    public boolean hasProcessDataBinding() {
        return this.processDataBinding.length() > 0;
    }

    public boolean hasApplyDataBinding() {
        return this.applyDataBinding.length() > 0;
    }

    public boolean hasRemoveDataBinding() {
        return this.removeDataBinding.length() > 0;
    }

    public boolean hasMethod(String methodName) {
        for (JavaMethod method : this.getJavaFile().getMethods()) {
            if (!methodName.equals(method.getName())) continue;
            return true;
        }
        return false;
    }

    public void addImport(String text) {
        if (text.endsWith("*")) {
            this.importedPackages.add(text.substring(0, text.length() - 1));
        } else {
            this.importedClasses.add(text);
        }
        if (!text.equals("*")) {
            this.getJavaFile().addImport(text);
        }
    }

    public void addDependencyClass(String className) {
        if (!this.engine.containsJaxxFileClassName(className)) {
            File jaxxFile;
            URL jaxxURL = this.getClassLoader().getResource(className.replace('.', '/') + ".jaxx");
            URL classURL = this.getClassLoader().getResource(className.replace('.', '/') + ".class");
            if (jaxxURL != null && classURL != null) {
                try {
                    jaxxFile = JAXXCompiler.URLtoFile(jaxxURL);
                    File classFile = JAXXCompiler.URLtoFile(classURL);
                    if (classFile.lastModified() > jaxxFile.lastModified()) {
                        return;
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (jaxxURL != null && jaxxURL.toString().startsWith("file:")) {
                jaxxFile = JAXXCompiler.URLtoFile(jaxxURL);
                try {
                    jaxxFile = jaxxFile.getCanonicalFile();
                }
                catch (IOException ex) {
                    // empty catch block
                }
                assert (jaxxFile.getName().equalsIgnoreCase(className.substring(className.lastIndexOf(".") + 1) + ".jaxx")) : "expecting file name to match " + className + ", but found " + jaxxFile.getName();
                if (jaxxFile.getName().equals(className.substring(className.lastIndexOf(".") + 1) + ".jaxx")) {
                    if (this.engine.getCurrentPass() != JAXXEngine.LifeCycle.compile_first_pass) {
                        throw new AssertionError((Object)("Internal error: adding dependency class " + className + " during second compilation pass"));
                    }
                    this.engine.addJaxxFileClassName(className);
                    this.engine.addJaxxFile(jaxxFile);
                }
            }
        }
    }

    public String checkJavaCode(String javaCode) {
        javaCode = this.scriptManager.trimScript(javaCode);
        this.scriptManager.checkParse(javaCode);
        return javaCode;
    }

    public boolean checkReference(Element tag, String reference, boolean strict, String attribute) {
        String component = this.getSymbolTable().getClassTagIds().get(reference);
        if (component == null) {
            if (strict) {
                String msg = attribute != null ? "tag '" + tag.getLocalName() + "' could not find the reference '" + reference + "' on attribute [" + attribute + "]" : "tag '" + tag.getLocalName() + "' could not find the reference '" + reference + "'";
                this.reportError(msg);
            }
            return false;
        }
        return true;
    }

    protected int getNextLeftBrace(String string, int pos) {
        this.leftBraceMatcher.reset(string);
        return this.leftBraceMatcher.find(pos) ? Math.max(this.leftBraceMatcher.start(1), this.leftBraceMatcher.start(2)) : -1;
    }

    protected int getNextRightBrace(String string, int pos) {
        this.leftBraceMatcher.reset(string);
        this.rightBraceMatcher.reset(string);
        int openCount = 1;
        while (openCount > 0) {
            int rightPos;
            int leftPos = this.leftBraceMatcher.find(++pos) ? Math.max(this.leftBraceMatcher.start(1), this.leftBraceMatcher.start(2)) : -1;
            int n = rightPos = this.rightBraceMatcher.find(pos) ? Math.max(this.rightBraceMatcher.start(1), this.rightBraceMatcher.start(2)) : -1;
            assert (leftPos == -1 || leftPos >= pos);
            assert (rightPos == -1 || rightPos >= pos);
            if (leftPos != -1 && leftPos < rightPos) {
                pos = leftPos;
                ++openCount;
                continue;
            }
            if (rightPos != -1) {
                pos = rightPos;
                --openCount;
                continue;
            }
            openCount = 0;
        }
        return pos;
    }

    public String getAutoId(ClassDescriptor objectClass) {
        String name = objectClass.getName();
        name = name.substring(name.lastIndexOf(".") + 1);
        return this.getAutoId(name);
    }

    public String getAutoId(String name) {
        if (this.configuration.getOptimize()) {
            return "$" + Integer.toString(this.autogenID++, 36);
        }
        name = name.substring(name.lastIndexOf(".") + 1);
        return "$" + name + this.autogenID++;
    }

    public String getUniqueId(Object object) {
        String result = this.uniqueIds.get(object);
        if (result == null) {
            result = "$u" + this.uniqueIds.size();
            this.uniqueIds.put(object, result);
        }
        return result;
    }

    public void setExtraInterfaces(String[] extraInterfaces) {
        this.extraInterfaces = extraInterfaces;
    }

    public String[] getExtraInterfaces() {
        return this.extraInterfaces;
    }

    public boolean isAbstractClass() {
        return this.abstractClass;
    }

    public void setAbstractClass(boolean abstractClass) {
        this.abstractClass = abstractClass;
    }

    public String getGenericType() {
        return this.genericType;
    }

    public void setGenericType(String genericType) {
        this.genericType = genericType;
    }

    public String getSuperGenericType() {
        return this.superGenericType;
    }

    public void setSuperGenericType(String superGenericType) {
        this.superGenericType = superGenericType;
    }

    public void addSimpleField(JavaField javaField) {
        this.getJavaFile().addSimpleField(javaField);
    }

    public JavaFile getJavaFile() {
        if (this.javaFile == null) {
            this.javaFile = new JavaFile();
        }
        return this.javaFile;
    }

    public void finalizeCompiler(Iterable<JAXXCompilerFinalizer> finalizers) throws Exception {
        int dotPos = this.getOutputClassName().lastIndexOf(".");
        String packageName = dotPos != -1 ? this.getOutputClassName().substring(0, dotPos) : null;
        String simpleClassName = this.getOutputClassName().substring(dotPos + 1);
        CompiledObject compiledObject = this.getRootObject();
        for (JAXXCompilerFinalizer finalizer : finalizers) {
            finalizer.finalizeCompiler(compiledObject, this, this.javaFile, packageName, simpleClassName);
        }
        for (CompiledObject object : this.getObjects().values()) {
            object.finalizeCompiler(this);
        }
        for (JAXXCompilerFinalizer finalizer : finalizers) {
            finalizer.prepareJavaFile(compiledObject, this, this.javaFile, packageName, simpleClassName);
        }
    }

    public void generate(JavaFileGenerator generator) throws IOException {
        File dest = this.getConfiguration().getTargetDirectory() != null ? new File(this.getConfiguration().getTargetDirectory(), this.getOutputClassName().replace('.', File.separatorChar) + ".java") : new File(this.getBaseDir(), this.getOutputClassName().substring(this.getOutputClassName().lastIndexOf(".") + 1) + ".java");
        if (dest.exists() && !dest.setLastModified(System.currentTimeMillis())) {
            log.warn((Object)("could not touch file " + dest));
        }
        PrintWriter out = null;
        try {
            out = new PrintWriter(new FileWriter(dest));
            generator.generateFile(this.javaFile, out);
        }
        catch (IOException e) {
            if (!dest.delete()) {
                log.warn((Object)("could not delete file " + dest));
            }
            throw e;
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    public static String getLineSeparator() {
        return lineSeparator;
    }

    public static String getCanonicalName(Class<?> clazz) {
        if (clazz.isArray()) {
            String canonicalName = JAXXCompiler.getCanonicalName(clazz.getComponentType());
            if (canonicalName != null) {
                return canonicalName + "[]";
            }
            return null;
        }
        return clazz.getName().replace('$', '.');
    }

    public static String getCanonicalName(ClassDescriptor clazz) {
        if (clazz.isArray()) {
            String canonicalName = JAXXCompiler.getCanonicalName(clazz.getComponentType());
            if (canonicalName != null) {
                return canonicalName + "[]";
            }
            return null;
        }
        return clazz.getName().replace('$', '.');
    }

    public static String getCanonicalName(CompiledObject compiled) {
        ClassDescriptor clazz = compiled.getObjectClass();
        if (clazz.isArray()) {
            String canonicalName = JAXXCompiler.getCanonicalName(clazz.getComponentType());
            if (canonicalName != null) {
                if (compiled.getGenericTypesLength() > 0) {
                    canonicalName = canonicalName + compiled.getGenericTypes();
                }
                return canonicalName + "[]";
            }
            return null;
        }
        String canonicalName = clazz.getName().replace('$', '.');
        if (compiled.getGenericTypesLength() > 0) {
            canonicalName = canonicalName + compiled.getGenericTypes();
        }
        return canonicalName;
    }

    public static String escapeJavaString(String raw) {
        StringBuffer out = new StringBuffer(raw);
        for (int i = 0; i < out.length(); ++i) {
            char c = out.charAt(i);
            if (c == '\\' || c == '\"') {
                out.insert(i, '\\');
                ++i;
                continue;
            }
            if (c == '\n') {
                out.replace(i, i + 1, "\\n");
                ++i;
                continue;
            }
            if (c == '\r') {
                out.replace(i, i + 1, "\\r");
                ++i;
                continue;
            }
            if (c >= ' ' && c <= '\u007f') continue;
            String value = Integer.toString(c, 16);
            while (value.length() < 4) {
                value = "0" + value;
            }
            out.replace(i, i + 1, "\\u" + value);
            i += 5;
        }
        return out.toString();
    }

    public static File URLtoFile(URL url) {
        return JAXXCompiler.URLtoFile(url.toString());
    }

    public static File URLtoFile(String urlString) {
        if (!urlString.startsWith("file:")) {
            throw new IllegalArgumentException("url must start with 'file:'");
        }
        if ((urlString = urlString.substring("file:".length())).startsWith("/") && System.getProperty("os.name").startsWith("Windows")) {
            urlString = urlString.substring(1);
        }
        try {
            return new File(URLDecoder.decode(urlString.replace('/', File.separatorChar), "utf-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static SAXParser getSAXParser() {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(true);
            SAXParser parser = factory.newSAXParser();
            return parser;
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    public static Document parseDocument(InputStream in) throws IOException, SAXException {
        try {
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer();
            transformer.setErrorListener(new ErrorListener(){

                @Override
                public void warning(TransformerException ex) throws TransformerException {
                    throw ex;
                }

                @Override
                public void error(TransformerException ex) throws TransformerException {
                    throw ex;
                }

                @Override
                public void fatalError(TransformerException ex) throws TransformerException {
                    throw ex;
                }
            });
            DOMResult result = new DOMResult();
            transformer.transform(new SAXSource(new XMLFilterImpl(JAXXCompiler.getSAXParser().getXMLReader()){
                Locator locator;

                @Override
                public void setDocumentLocator(Locator locator) {
                    this.locator = locator;
                }

                @Override
                public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
                    AttributesImpl resultAtts = new AttributesImpl(atts);
                    resultAtts.addAttribute(JAXXCompiler.JAXX_INTERNAL_NAMESPACE, "line", "internal:line", "CDATA", String.valueOf(this.locator.getLineNumber()));
                    this.getContentHandler().startElement(uri, localName, qName, resultAtts);
                }
            }, new InputSource(in)), result);
            return (Document)result.getNode();
        }
        catch (TransformerConfigurationException e) {
            throw new RuntimeException(e);
        }
        catch (TransformerException e) {
            Throwable ex = e;
            while (((Throwable)ex).getCause() != null) {
                ex = ((Throwable)ex).getCause();
            }
            if (ex instanceof IOException) {
                throw (IOException)ex;
            }
            if (ex instanceof SAXException) {
                throw (SAXException)ex;
            }
            if (ex instanceof RuntimeException) {
                throw (RuntimeException)ex;
            }
            throw new RuntimeException(ex);
        }
    }

    public JAXXEngine getEngine() {
        return this.engine;
    }
}

