package org.nuiton.jaxx.application.swing.table;

/*
 * #%L
 * JAXX :: Application Swing
 * %%
 * Copyright (C) 2008 - 2014 Code Lutin, Tony Chemit
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import org.nuiton.jaxx.application.bean.JavaBeanObjectUtil;

import java.io.Serializable;

/**
 * To represent a column of a table.
 *
 * @author Tony Chemit - dev@tchemit.fr
 * @since 2.8
 */
public class ColumnIdentifier<R> implements Serializable {

    private static final long serialVersionUID = 1L;

    private final String propertyName;

    private final String headerI18nKey;

    private final String headerTipI18nKey;

    public static <R> ColumnIdentifier<R> newId(String propertyName,
                                                String headerI18nKey,
                                                String headerTipI18nKey) {
        return new ColumnIdentifier<>(propertyName,
                                      headerI18nKey,
                                      headerTipI18nKey);
    }

    public static <R> ColumnIdentifier<R> newReadOnlyId(String propertyName,
                                                        String headerI18nKey,
                                                        String headerTipI18nKey) {
        return new ColumnIdentifier<R>(propertyName,
                                       headerI18nKey,
                                       headerTipI18nKey) {

            private static final long serialVersionUID = 1L;

            @Override
            public void setValue(R entry, Object value) {
                // no set
            }
        };
    }

    protected ColumnIdentifier(String propertyName,
                               String headerI18nKey,
                               String headerTipI18nKey) {
        this.propertyName = propertyName;
        this.headerI18nKey = headerI18nKey;
        this.headerTipI18nKey = headerTipI18nKey;
    }

    public String getPropertyName() {
        return propertyName;
    }

    public String getHeaderI18nKey() {
        return headerI18nKey;
    }

    public String getHeaderTipI18nKey() {
        return headerTipI18nKey;
    }

    public Object getValue(R entry) {
        Object result = null;
        if (propertyName != null && entry != null) {
            result = JavaBeanObjectUtil.getProperty(entry, propertyName);
        }
        return result;
    }

    public void setValue(R entry, Object value) {
        if (propertyName != null) {
            JavaBeanObjectUtil.setProperty(entry, propertyName, value);
        }
    }

}
